/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import scala_maven_executions.JavaMainCallerInProcess;

public class GatlingJavaMainCallerInProcess
extends JavaMainCallerInProcess {
    private String oldClassPath;

    public GatlingJavaMainCallerInProcess(AbstractMojo requester, String mainClassName, String classpath, String[] args) throws Exception {
        super(requester, mainClassName, classpath, null, args);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classpath.split(File.pathSeparator)) {
            try {
                urls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                requester.getLog().error((Throwable)e);
            }
        }
        this.oldClassPath = System.getProperty("java.class.path");
        System.setProperty("java.class.path", classpath);
        Thread.currentThread().setContextClassLoader(new URLClassLoader(urls.toArray(new URL[urls.size()])));
    }

    public void addJvmArgs(String ... args) {
    }

    public boolean run(boolean displayCmd, boolean throwFailure) throws Exception {
        throw new UnsupportedOperationException("boolean run(boolean displayCmd, boolean throwFailure) is not supported, call int run() instead");
    }

    public int run() throws Exception {
        return this.runGatling(this.mainClassName, this.args);
    }

    private int runGatling(String mainClassName, List<String> args) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> mainClass = cl.loadClass(mainClassName);
        Method runGatlingMethod = mainClass.getMethod("runGatling", String[].class);
        String[] argArray = args.toArray(new String[args.size()]);
        Integer ret = (Integer)runGatlingMethod.invoke(null, new Object[]{argArray});
        System.setProperty("java.class.path", this.oldClassPath);
        this.oldClassPath = null;
        return ret;
    }
}

