/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.dataadapter.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.lib.dataadapter.client.DataAdapterClientErrorException;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.DataAdapterError;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.FormDataChange;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.OperationChange;
import io.getlime.security.powerauth.lib.dataadapter.model.enumeration.AuthenticationType;
import io.getlime.security.powerauth.lib.dataadapter.model.request.AuthenticationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.BankAccountListRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.CreateSMSAuthorizationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.FormDataChangeNotificationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.OperationChangeNotificationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.UserDetailRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.VerifySMSAuthorizationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.response.AuthenticationResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.BankAccountListResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.CreateSMSAuthorizationResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.UserDetailResponse;
import io.getlime.security.powerauth.lib.nextstep.model.entity.OperationFormData;
import java.io.IOException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class DataAdapterClient {
    private String serviceUrl;
    private ObjectMapper objectMapper;

    public DataAdapterClient() {
    }

    public DataAdapterClient(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        this.objectMapper = new ObjectMapper();
    }

    public DataAdapterClient(String serviceUrl, ObjectMapper objectMapper) {
        this.serviceUrl = serviceUrl;
        this.objectMapper = objectMapper;
    }

    private RestTemplate defaultTemplate() {
        RestTemplate template = new RestTemplate();
        template.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
        return template;
    }

    public ObjectResponse<AuthenticationResponse> authenticateUser(String username, String password) throws DataAdapterClientErrorException {
        try {
            AuthenticationRequest request = new AuthenticationRequest(username, password, AuthenticationType.BASIC);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.defaultTemplate().exchange(this.serviceUrl + "/api/auth/user/authenticate", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<AuthenticationResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<UserDetailResponse> fetchUserDetail(String userId) throws DataAdapterClientErrorException {
        try {
            UserDetailRequest request = new UserDetailRequest(userId);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.defaultTemplate().exchange(this.serviceUrl + "/api/auth/user/info", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<UserDetailResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<CreateSMSAuthorizationResponse> createAuthorizationSMS(String operationId, String userId, String operationName, OperationFormData formData, String lang) throws DataAdapterClientErrorException {
        try {
            CreateSMSAuthorizationRequest request = new CreateSMSAuthorizationRequest(operationId, userId, operationName, formData, lang);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Accept-Language", LocaleContextHolder.getLocale().getLanguage());
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request), (MultiValueMap)headers);
            ResponseEntity response = this.defaultTemplate().exchange(this.serviceUrl + "/api/auth/sms/create", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<CreateSMSAuthorizationResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse verifyAuthorizationSMS(String messageId, String authorizationCode) throws DataAdapterClientErrorException {
        try {
            VerifySMSAuthorizationRequest request = new VerifySMSAuthorizationRequest(messageId, authorizationCode);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            this.defaultTemplate().exchange(this.serviceUrl + "/api/auth/sms/verify", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse>(){}, new Object[0]);
            return new ObjectResponse();
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<BankAccountListResponse> fetchBankAccounts(String userId, String operationName, String operationId, OperationFormData formData) throws DataAdapterClientErrorException {
        try {
            BankAccountListRequest request = new BankAccountListRequest(userId, operationName, operationId, formData);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Accept-Language", LocaleContextHolder.getLocale().getLanguage());
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request), (MultiValueMap)headers);
            ResponseEntity response = this.defaultTemplate().exchange(this.serviceUrl + "/api/auth/account/list", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<BankAccountListResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse formDataChangedNotification(FormDataChange formDataChange, String userId, String operationId) throws DataAdapterClientErrorException {
        try {
            FormDataChangeNotificationRequest request = new FormDataChangeNotificationRequest();
            request.setUserId(userId);
            request.setOperationId(operationId);
            request.setFormDataChange(formDataChange);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.defaultTemplate().exchange(this.serviceUrl + "/api/operation/formData/change", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse operationChangedNotification(OperationChange operationChange, String userId, String operationId) throws DataAdapterClientErrorException {
        try {
            OperationChangeNotificationRequest request = new OperationChangeNotificationRequest();
            request.setUserId(userId);
            request.setOperationId(operationId);
            request.setOperationChange(operationChange);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.defaultTemplate().exchange(this.serviceUrl + "/api/operation/change", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    private DataAdapterClientErrorException resourceAccessException(ResourceAccessException ex) {
        DataAdapterError error = new DataAdapterError("ERROR_GENERIC", ex.getMessage());
        return new DataAdapterClientErrorException(ex, error);
    }

    private DataAdapterClientErrorException invalidErrorResponseBodyException(IOException ex) {
        DataAdapterError error = new DataAdapterError("ERROR_GENERIC", ex.getMessage());
        return new DataAdapterClientErrorException(ex, error);
    }

    private DataAdapterClientErrorException httpStatusException(HttpStatusCodeException ex) throws IOException {
        TypeReference<ObjectResponse<DataAdapterError>> typeReference = new TypeReference<ObjectResponse<DataAdapterError>>(){};
        ObjectResponse errorResponse = (ObjectResponse)this.objectMapper.readValue(ex.getResponseBodyAsString(), (TypeReference)typeReference);
        DataAdapterError error = (DataAdapterError)errorResponse.getResponseObject();
        if (error.getCode() == null) {
            error.setCode("ERROR_GENERIC");
            error.setMessage(ex.getMessage());
        }
        return new DataAdapterClientErrorException(ex, error);
    }
}

