/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.dataadapter.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.lib.dataadapter.client.DataAdapterClientErrorException;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.DataAdapterError;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.FormDataChange;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.OperationChange;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.OperationContext;
import io.getlime.security.powerauth.lib.dataadapter.model.enumeration.AuthenticationType;
import io.getlime.security.powerauth.lib.dataadapter.model.request.AuthenticationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.CreateSMSAuthorizationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.DecorateOperationFormDataRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.FormDataChangeNotificationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.OperationChangeNotificationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.UserDetailRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.VerifySMSAuthorizationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.response.AuthenticationResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.CreateSMSAuthorizationResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.DecorateOperationFormDataResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.UserDetailResponse;
import java.io.IOException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class DataAdapterClient {
    private final String serviceUrl;
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate;

    public DataAdapterClient(String serviceUrl) {
        this(serviceUrl, new ObjectMapper());
    }

    public DataAdapterClient(String serviceUrl, ObjectMapper objectMapper) {
        this.serviceUrl = serviceUrl;
        this.objectMapper = objectMapper;
        this.restTemplate = new RestTemplate();
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ObjectResponse<AuthenticationResponse> authenticateUser(String username, String password, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            AuthenticationRequest request = new AuthenticationRequest(username, password, AuthenticationType.BASIC, operationContext);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/user/authenticate", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<AuthenticationResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<UserDetailResponse> fetchUserDetail(String userId) throws DataAdapterClientErrorException {
        try {
            UserDetailRequest request = new UserDetailRequest(userId);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/user/info", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<UserDetailResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<CreateSMSAuthorizationResponse> createAuthorizationSMS(String userId, OperationContext operationContext, String lang) throws DataAdapterClientErrorException {
        try {
            CreateSMSAuthorizationRequest request = new CreateSMSAuthorizationRequest(userId, lang, operationContext);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Accept-Language", LocaleContextHolder.getLocale().getLanguage());
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request), (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/sms/create", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<CreateSMSAuthorizationResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public Response verifyAuthorizationSMS(String messageId, String authorizationCode, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            VerifySMSAuthorizationRequest request = new VerifySMSAuthorizationRequest(messageId, authorizationCode, operationContext);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            this.restTemplate.exchange(this.serviceUrl + "/api/auth/sms/verify", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse>(){}, new Object[0]);
            return new Response();
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<DecorateOperationFormDataResponse> decorateOperationFormData(String userId, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            DecorateOperationFormDataRequest request = new DecorateOperationFormDataRequest(userId, operationContext);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Accept-Language", LocaleContextHolder.getLocale().getLanguage());
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request), (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/operation/formdata/decorate", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<DecorateOperationFormDataResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse formDataChangedNotification(FormDataChange formDataChange, String userId, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            FormDataChangeNotificationRequest request = new FormDataChangeNotificationRequest();
            request.setUserId(userId);
            request.setOperationContext(operationContext);
            request.setFormDataChange(formDataChange);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/operation/formdata/change", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse operationChangedNotification(OperationChange operationChange, String userId, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            OperationChangeNotificationRequest request = new OperationChangeNotificationRequest();
            request.setUserId(userId);
            request.setOperationContext(operationContext);
            request.setOperationChange(operationChange);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/operation/change", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            try {
                throw this.httpStatusException(ex);
            }
            catch (IOException ex2) {
                throw this.invalidErrorResponseBodyException(ex2);
            }
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    private DataAdapterClientErrorException resourceAccessException(ResourceAccessException ex) {
        DataAdapterError error = new DataAdapterError("ERROR_GENERIC", ex.getMessage());
        return new DataAdapterClientErrorException(ex, error);
    }

    private DataAdapterClientErrorException invalidErrorResponseBodyException(IOException ex) {
        DataAdapterError error = new DataAdapterError("ERROR_GENERIC", ex.getMessage());
        return new DataAdapterClientErrorException(ex, error);
    }

    private DataAdapterClientErrorException httpStatusException(HttpStatusCodeException ex) throws IOException {
        TypeReference<ObjectResponse<DataAdapterError>> typeReference = new TypeReference<ObjectResponse<DataAdapterError>>(){};
        ObjectResponse errorResponse = (ObjectResponse)this.objectMapper.readValue(ex.getResponseBodyAsString(), (TypeReference)typeReference);
        DataAdapterError error = (DataAdapterError)errorResponse.getResponseObject();
        if (error.getCode() == null) {
            error.setCode("ERROR_GENERIC");
            error.setMessage(ex.getMessage());
        }
        return new DataAdapterClientErrorException(ex, error);
    }
}

