/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.dataadapter.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.lib.dataadapter.client.DataAdapterClientErrorException;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.AuthenticationContext;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.ConsentOption;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.DataAdapterError;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.FormDataChange;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.OperationChange;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.OperationContext;
import io.getlime.security.powerauth.lib.dataadapter.model.request.CreateConsentFormRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.CreateSmsAuthorizationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.DecorateOperationFormDataRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.FormDataChangeNotificationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.InitConsentFormRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.OperationChangeNotificationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.SaveConsentFormRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.UserAuthenticationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.UserDetailRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.UserLookupRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.ValidateConsentFormRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.VerifySmsAndPasswordRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.VerifySmsAuthorizationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.response.CreateConsentFormResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.CreateSmsAuthorizationResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.DecorateOperationFormDataResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.InitConsentFormResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.SaveConsentFormResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.UserAuthenticationResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.UserDetailResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.ValidateConsentFormResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.VerifySmsAndPasswordResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.VerifySmsAuthorizationResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class DataAdapterClient {
    private final String serviceUrl;
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate;

    public DataAdapterClient(String serviceUrl) {
        this(serviceUrl, null);
    }

    public DataAdapterClient(String serviceUrl, ObjectMapper objectMapper) {
        this.serviceUrl = serviceUrl;
        this.objectMapper = objectMapper != null ? objectMapper : this.objectMapper();
        this.restTemplate = new RestTemplate();
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter(this.objectMapper);
        ArrayList<MappingJackson2HttpMessageConverter> converters = new ArrayList<MappingJackson2HttpMessageConverter>();
        converters.add(converter);
        this.restTemplate.setMessageConverters(converters);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
    }

    private ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ObjectResponse<UserDetailResponse> lookupUser(String username, String organizationId, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            UserLookupRequest request = new UserLookupRequest(username, organizationId, operationContext);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/user/lookup", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<UserDetailResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<UserAuthenticationResponse> authenticateUser(String userId, String organizationId, String password, AuthenticationContext authenticationContext, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            UserAuthenticationRequest request = new UserAuthenticationRequest(userId, organizationId, password, authenticationContext, operationContext);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/user/authenticate", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<UserAuthenticationResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<UserDetailResponse> fetchUserDetail(String userId, String organizationId) throws DataAdapterClientErrorException {
        try {
            UserDetailRequest request = new UserDetailRequest(userId, organizationId);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/user/info", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<UserDetailResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<CreateSmsAuthorizationResponse> createAuthorizationSms(String userId, String organizationId, OperationContext operationContext, String lang, boolean resend) throws DataAdapterClientErrorException {
        try {
            CreateSmsAuthorizationRequest request = new CreateSmsAuthorizationRequest(userId, organizationId, lang, operationContext, resend);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/sms/create", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<CreateSmsAuthorizationResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<VerifySmsAuthorizationResponse> verifyAuthorizationSms(String messageId, String authorizationCode, String userId, String organizationId, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            VerifySmsAuthorizationRequest request = new VerifySmsAuthorizationRequest(messageId, authorizationCode, userId, organizationId, operationContext);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/sms/verify", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<VerifySmsAuthorizationResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<VerifySmsAndPasswordResponse> verifyAuthorizationSmsAndPassword(String messageId, String authorizationCode, String userId, String organizationId, String password, AuthenticationContext authenticationContext, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            VerifySmsAndPasswordRequest request = new VerifySmsAndPasswordRequest(messageId, authorizationCode, userId, organizationId, password, authenticationContext, operationContext);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/sms/password/verify", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<VerifySmsAndPasswordResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<DecorateOperationFormDataResponse> decorateOperationFormData(String userId, String organizationId, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            DecorateOperationFormDataRequest request = new DecorateOperationFormDataRequest(userId, organizationId, operationContext);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/operation/formdata/decorate", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<DecorateOperationFormDataResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse formDataChangedNotification(FormDataChange formDataChange, String userId, String organizationId, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            FormDataChangeNotificationRequest request = new FormDataChangeNotificationRequest();
            request.setUserId(userId);
            request.setOrganizationId(organizationId);
            request.setOperationContext(operationContext);
            request.setFormDataChange(formDataChange);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/operation/formdata/change", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse operationChangedNotification(OperationChange operationChange, String userId, String organizationId, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            OperationChangeNotificationRequest request = new OperationChangeNotificationRequest();
            request.setUserId(userId);
            request.setOrganizationId(organizationId);
            request.setOperationContext(operationContext);
            request.setOperationChange(operationChange);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/operation/change", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<InitConsentFormResponse> initConsentForm(String userId, String organizationId, OperationContext operationContext) throws DataAdapterClientErrorException {
        try {
            InitConsentFormRequest request = new InitConsentFormRequest(userId, organizationId, operationContext);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/consent/init", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<InitConsentFormResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<CreateConsentFormResponse> createConsentForm(String userId, String organizationId, OperationContext operationContext, String lang) throws DataAdapterClientErrorException {
        try {
            CreateConsentFormRequest request = new CreateConsentFormRequest(userId, organizationId, lang, operationContext);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/consent/create", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<CreateConsentFormResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<ValidateConsentFormResponse> validateConsentForm(String userId, String organizationId, OperationContext operationContext, String lang, List<ConsentOption> options) throws DataAdapterClientErrorException {
        try {
            ValidateConsentFormRequest request = new ValidateConsentFormRequest(userId, organizationId, operationContext, lang, options);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/consent/validate", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<ValidateConsentFormResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<SaveConsentFormResponse> saveConsentForm(String userId, String organizationId, OperationContext operationContext, List<ConsentOption> options) throws DataAdapterClientErrorException {
        try {
            SaveConsentFormRequest request = new SaveConsentFormRequest(userId, organizationId, operationContext, options);
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/api/auth/consent/save", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<SaveConsentFormResponse>>(){}, new Object[0]);
            return new ObjectResponse(((ObjectResponse)response.getBody()).getResponseObject());
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    private DataAdapterClientErrorException resourceAccessException(ResourceAccessException ex) {
        DataAdapterError error = new DataAdapterError("COMMUNICATION_ERROR", ex.getMessage());
        return new DataAdapterClientErrorException(ex, error);
    }

    private DataAdapterClientErrorException httpStatusException(HttpStatusCodeException ex) {
        try {
            TypeReference<ObjectResponse<DataAdapterError>> typeReference = new TypeReference<ObjectResponse<DataAdapterError>>(){};
            ObjectResponse errorResponse = (ObjectResponse)this.objectMapper.readValue(ex.getResponseBodyAsString(), (TypeReference)typeReference);
            DataAdapterError error = (DataAdapterError)errorResponse.getResponseObject();
            if (error == null) {
                error = new DataAdapterError();
            }
            if (error.getCode() == null) {
                error.setCode("ERROR_GENERIC");
                error.setMessage(ex.getMessage());
            }
            return new DataAdapterClientErrorException(ex, error);
        }
        catch (IOException ex2) {
            if (ex.getStatusCode() != HttpStatus.OK) {
                DataAdapterError error = new DataAdapterError("COMMUNICATION_ERROR", "HTTP error occurred: " + ex.getMessage());
                return new DataAdapterClientErrorException(ex, error);
            }
            DataAdapterError error = new DataAdapterError("ERROR_GENERIC", "IO error occurred: " + ex2.getMessage());
            return new DataAdapterClientErrorException(ex2, error);
        }
    }
}

