/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.dataadapter.client;

import com.wultra.core.rest.client.base.DefaultRestClient;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientConfiguration;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.lib.dataadapter.client.DataAdapterClientErrorException;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.AuthenticationContext;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.ConsentOption;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.DataAdapterError;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.FormDataChange;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.OperationChange;
import io.getlime.security.powerauth.lib.dataadapter.model.entity.OperationContext;
import io.getlime.security.powerauth.lib.dataadapter.model.enumeration.AccountStatus;
import io.getlime.security.powerauth.lib.dataadapter.model.request.AfsRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.AfsRequestParameters;
import io.getlime.security.powerauth.lib.dataadapter.model.request.CreateConsentFormRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.CreateImplicitLoginOperationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.CreateSmsAuthorizationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.DecorateOperationFormDataRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.FormDataChangeNotificationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.GetPAOperationMappingRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.InitAuthMethodRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.InitConsentFormRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.OperationChangeNotificationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.SaveConsentFormRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.SendAuthorizationSmsRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.UserAuthenticationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.UserDetailRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.UserLookupRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.ValidateConsentFormRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.VerifyCertificateRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.VerifySmsAndPasswordRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.request.VerifySmsAuthorizationRequest;
import io.getlime.security.powerauth.lib.dataadapter.model.response.AfsResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.CreateConsentFormResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.CreateImplicitLoginOperationResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.CreateSmsAuthorizationResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.DecorateOperationFormDataResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.GetPAOperationMappingResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.InitAuthMethodResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.InitConsentFormResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.SaveConsentFormResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.SendAuthorizationSmsResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.UserAuthenticationResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.UserDetailResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.ValidateConsentFormResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.VerifyCertificateResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.VerifySmsAndPasswordResponse;
import io.getlime.security.powerauth.lib.dataadapter.model.response.VerifySmsAuthorizationResponse;
import io.getlime.security.powerauth.lib.nextstep.model.enumeration.AuthMethod;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAdapterClient {
    private static final Logger logger = LoggerFactory.getLogger(DataAdapterClient.class);
    private final RestClient restClient;

    public DataAdapterClient(String serviceBaseUrl) throws DataAdapterClientErrorException {
        try {
            this.restClient = new DefaultRestClient(serviceBaseUrl);
        }
        catch (RestClientException ex) {
            DataAdapterClientErrorException ex2 = new DataAdapterClientErrorException(ex, new DataAdapterError(this.resolveErrorCode(ex), "Rest client initialization failed."));
            this.logError(ex2);
            throw ex2;
        }
    }

    public DataAdapterClient(RestClientConfiguration restClientConfiguration) throws DataAdapterClientErrorException {
        try {
            this.restClient = new DefaultRestClient(restClientConfiguration);
        }
        catch (RestClientException ex) {
            DataAdapterClientErrorException ex2 = new DataAdapterClientErrorException(ex, new DataAdapterError(this.resolveErrorCode(ex), "Rest client initialization failed."));
            this.logError(ex2);
            throw ex2;
        }
    }

    public ObjectResponse<UserDetailResponse> lookupUser(String username, String organizationId, String clientCertificate, OperationContext operationContext) throws DataAdapterClientErrorException {
        UserLookupRequest request = new UserLookupRequest(username, organizationId, clientCertificate, operationContext);
        return this.postObjectImpl("/api/auth/user/lookup", new ObjectRequest((Object)request), UserDetailResponse.class);
    }

    public ObjectResponse<UserAuthenticationResponse> authenticateUser(String userId, String organizationId, String password, AuthenticationContext authenticationContext, OperationContext operationContext) throws DataAdapterClientErrorException {
        UserAuthenticationRequest request = new UserAuthenticationRequest(userId, organizationId, password, authenticationContext, operationContext);
        return this.postObjectImpl("/api/auth/user/authenticate", new ObjectRequest((Object)request), UserAuthenticationResponse.class);
    }

    public ObjectResponse<UserDetailResponse> fetchUserDetail(String userId, String organizationId) throws DataAdapterClientErrorException {
        UserDetailRequest request = new UserDetailRequest(userId, organizationId);
        return this.postObjectImpl("/api/auth/user/info", new ObjectRequest((Object)request), UserDetailResponse.class);
    }

    public ObjectResponse<InitAuthMethodResponse> initAuthMethod(String userId, String organizationId, AuthMethod authMethod, OperationContext operationContext) throws DataAdapterClientErrorException {
        InitAuthMethodRequest request = new InitAuthMethodRequest(userId, organizationId, authMethod, operationContext);
        return this.postObjectImpl("/api/auth/method/init", new ObjectRequest((Object)request), InitAuthMethodResponse.class);
    }

    public ObjectResponse<CreateSmsAuthorizationResponse> createAndSendAuthorizationSms(String userId, String organizationId, AccountStatus accountStatus, AuthMethod authMethod, OperationContext operationContext, String lang, boolean resend) throws DataAdapterClientErrorException {
        CreateSmsAuthorizationRequest request = new CreateSmsAuthorizationRequest(userId, organizationId, accountStatus, lang, authMethod, operationContext, resend);
        return this.postObjectImpl("/api/auth/sms/create", new ObjectRequest((Object)request), CreateSmsAuthorizationResponse.class);
    }

    public ObjectResponse<SendAuthorizationSmsResponse> sendAuthorizationSms(String userId, String organizationId, AccountStatus accountStatus, AuthMethod authMethod, OperationContext operationContext, String messageId, String authorizationCode, String lang, boolean resend) throws DataAdapterClientErrorException {
        SendAuthorizationSmsRequest request = new SendAuthorizationSmsRequest(userId, organizationId, accountStatus, authMethod, operationContext, messageId, authorizationCode, lang, resend);
        return this.postObjectImpl("/api/auth/sms/send", new ObjectRequest((Object)request), SendAuthorizationSmsResponse.class);
    }

    public ObjectResponse<VerifySmsAuthorizationResponse> verifyAuthorizationSms(String messageId, String authorizationCode, String userId, String organizationId, AccountStatus accountStatus, OperationContext operationContext) throws DataAdapterClientErrorException {
        VerifySmsAuthorizationRequest request = new VerifySmsAuthorizationRequest(messageId, authorizationCode, userId, organizationId, accountStatus, operationContext);
        return this.postObjectImpl("/api/auth/sms/verify", new ObjectRequest((Object)request), VerifySmsAuthorizationResponse.class);
    }

    public ObjectResponse<VerifySmsAndPasswordResponse> verifyAuthorizationSmsAndPassword(String messageId, String authorizationCode, String userId, String organizationId, AccountStatus accountStatus, String password, AuthenticationContext authenticationContext, OperationContext operationContext) throws DataAdapterClientErrorException {
        VerifySmsAndPasswordRequest request = new VerifySmsAndPasswordRequest(messageId, authorizationCode, userId, organizationId, accountStatus, password, authenticationContext, operationContext);
        return this.postObjectImpl("/api/auth/sms/password/verify", new ObjectRequest((Object)request), VerifySmsAndPasswordResponse.class);
    }

    public ObjectResponse<CreateImplicitLoginOperationResponse> createImplicitLoginOperation(String clientId, String[] scopes) throws DataAdapterClientErrorException {
        CreateImplicitLoginOperationRequest request = new CreateImplicitLoginOperationRequest(clientId, scopes);
        return this.postObjectImpl("/api/operation/create", new ObjectRequest((Object)request), CreateImplicitLoginOperationResponse.class);
    }

    public ObjectResponse<GetPAOperationMappingResponse> getPAOperationMapping(String userId, String organizationId, AuthMethod authMethod, OperationContext operationContext) throws DataAdapterClientErrorException {
        GetPAOperationMappingRequest request = new GetPAOperationMappingRequest();
        request.setUserId(userId);
        request.setOrganizationId(organizationId);
        request.setAuthMethod(authMethod);
        request.setOperationContext(operationContext);
        return this.postObjectImpl("/api/operation/mapping", new ObjectRequest((Object)request), GetPAOperationMappingResponse.class);
    }

    public ObjectResponse<VerifyCertificateResponse> verifyClientCertificate(String userId, String organizationId, String clientCertificate, AuthMethod authMethod, AccountStatus accountStatus, OperationContext operationContext) throws DataAdapterClientErrorException {
        VerifyCertificateRequest request = new VerifyCertificateRequest(userId, organizationId, clientCertificate, authMethod, accountStatus, operationContext);
        return this.postObjectImpl("/api/auth/certificate/verify", new ObjectRequest((Object)request), VerifyCertificateResponse.class);
    }

    public ObjectResponse<DecorateOperationFormDataResponse> decorateOperationFormData(String userId, String organizationId, AuthMethod authMethod, OperationContext operationContext) throws DataAdapterClientErrorException {
        DecorateOperationFormDataRequest request = new DecorateOperationFormDataRequest(userId, organizationId, authMethod, operationContext);
        return this.postObjectImpl("/api/operation/formdata/decorate", new ObjectRequest((Object)request), DecorateOperationFormDataResponse.class);
    }

    public Response formDataChangedNotification(FormDataChange formDataChange, String userId, String organizationId, OperationContext operationContext) throws DataAdapterClientErrorException {
        FormDataChangeNotificationRequest request = new FormDataChangeNotificationRequest();
        request.setUserId(userId);
        request.setOrganizationId(organizationId);
        request.setOperationContext(operationContext);
        request.setFormDataChange(formDataChange);
        return this.postObjectImpl("/api/operation/formdata/change", new ObjectRequest((Object)request));
    }

    public Response operationChangedNotification(OperationChange operationChange, String userId, String organizationId, OperationContext operationContext) throws DataAdapterClientErrorException {
        OperationChangeNotificationRequest request = new OperationChangeNotificationRequest();
        request.setUserId(userId);
        request.setOrganizationId(organizationId);
        request.setOperationContext(operationContext);
        request.setOperationChange(operationChange);
        return this.postObjectImpl("/api/operation/change", new ObjectRequest((Object)request));
    }

    public ObjectResponse<InitConsentFormResponse> initConsentForm(String userId, String organizationId, OperationContext operationContext) throws DataAdapterClientErrorException {
        InitConsentFormRequest request = new InitConsentFormRequest(userId, organizationId, operationContext);
        return this.postObjectImpl("/api/auth/consent/init", new ObjectRequest((Object)request), InitConsentFormResponse.class);
    }

    public ObjectResponse<CreateConsentFormResponse> createConsentForm(String userId, String organizationId, OperationContext operationContext, String lang) throws DataAdapterClientErrorException {
        CreateConsentFormRequest request = new CreateConsentFormRequest(userId, organizationId, lang, operationContext);
        return this.postObjectImpl("/api/auth/consent/create", new ObjectRequest((Object)request), CreateConsentFormResponse.class);
    }

    public ObjectResponse<ValidateConsentFormResponse> validateConsentForm(String userId, String organizationId, OperationContext operationContext, String lang, List<ConsentOption> options) throws DataAdapterClientErrorException {
        ValidateConsentFormRequest request = new ValidateConsentFormRequest(userId, organizationId, operationContext, lang, options);
        return this.postObjectImpl("/api/auth/consent/validate", new ObjectRequest((Object)request), ValidateConsentFormResponse.class);
    }

    public ObjectResponse<SaveConsentFormResponse> saveConsentForm(String userId, String organizationId, OperationContext operationContext, List<ConsentOption> options) throws DataAdapterClientErrorException {
        SaveConsentFormRequest request = new SaveConsentFormRequest(userId, organizationId, operationContext, options);
        return this.postObjectImpl("/api/auth/consent/save", new ObjectRequest((Object)request), SaveConsentFormResponse.class);
    }

    public ObjectResponse<AfsResponse> executeAfsAction(String userId, String organizationId, OperationContext operationContext, AfsRequestParameters afsRequestParameters, Map<String, Object> extras) throws DataAdapterClientErrorException {
        AfsRequest request = new AfsRequest(userId, organizationId, operationContext, afsRequestParameters, extras);
        return this.postObjectImpl("/api/afs/action/execute", new ObjectRequest((Object)request), AfsResponse.class);
    }

    private Response postObjectImpl(String path, ObjectRequest<?> request) throws DataAdapterClientErrorException {
        try {
            return this.restClient.postObject(path, request);
        }
        catch (RestClientException ex) {
            DataAdapterClientErrorException ex2 = new DataAdapterClientErrorException(ex, new DataAdapterError(this.resolveErrorCode(ex), "HTTP POST request failed."));
            this.logError(ex2);
            throw ex2;
        }
    }

    private <T> ObjectResponse<T> postObjectImpl(String path, ObjectRequest<?> request, Class<T> responseType) throws DataAdapterClientErrorException {
        try {
            return this.restClient.postObject(path, request, responseType);
        }
        catch (RestClientException ex) {
            DataAdapterClientErrorException ex2 = new DataAdapterClientErrorException(ex, new DataAdapterError(this.resolveErrorCode(ex), "HTTP POST request failed."));
            this.logError(ex2);
            throw ex2;
        }
    }

    private void logError(DataAdapterClientErrorException ex) {
        DataAdapterError error = ex.getError();
        if (error != null) {
            logger.warn("Data Adapter REST API call failed with error code: {}", (Object)error.getCode());
        } else {
            logger.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    private String resolveErrorCode(RestClientException ex) {
        if (ex.getStatusCode() == null) {
            return "ERROR_GENERIC";
        }
        if (ex.getStatusCode().is4xxClientError()) {
            return "DATA_ADAPTER_CLIENT_ERROR";
        }
        if (ex.getStatusCode().is5xxServerError()) {
            return "REMOTE_ERROR";
        }
        return "COMMUNICATION_ERROR";
    }
}

