/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.soap.spring.client;

import io.getlime.powerauth.soap.ActivationHistoryRequest;
import io.getlime.powerauth.soap.ActivationHistoryResponse;
import io.getlime.powerauth.soap.BlockActivationRequest;
import io.getlime.powerauth.soap.BlockActivationResponse;
import io.getlime.powerauth.soap.CommitActivationRequest;
import io.getlime.powerauth.soap.CommitActivationResponse;
import io.getlime.powerauth.soap.CreateActivationRequest;
import io.getlime.powerauth.soap.CreateActivationResponse;
import io.getlime.powerauth.soap.CreateApplicationRequest;
import io.getlime.powerauth.soap.CreateApplicationResponse;
import io.getlime.powerauth.soap.CreateApplicationVersionRequest;
import io.getlime.powerauth.soap.CreateApplicationVersionResponse;
import io.getlime.powerauth.soap.CreateCallbackUrlRequest;
import io.getlime.powerauth.soap.CreateCallbackUrlResponse;
import io.getlime.powerauth.soap.CreateIntegrationRequest;
import io.getlime.powerauth.soap.CreateIntegrationResponse;
import io.getlime.powerauth.soap.CreateOfflineSignaturePayloadRequest;
import io.getlime.powerauth.soap.CreateOfflineSignaturePayloadResponse;
import io.getlime.powerauth.soap.CreateTokenRequest;
import io.getlime.powerauth.soap.CreateTokenResponse;
import io.getlime.powerauth.soap.GetActivationListForUserRequest;
import io.getlime.powerauth.soap.GetActivationListForUserResponse;
import io.getlime.powerauth.soap.GetActivationStatusRequest;
import io.getlime.powerauth.soap.GetActivationStatusResponse;
import io.getlime.powerauth.soap.GetApplicationDetailRequest;
import io.getlime.powerauth.soap.GetApplicationDetailResponse;
import io.getlime.powerauth.soap.GetApplicationListRequest;
import io.getlime.powerauth.soap.GetApplicationListResponse;
import io.getlime.powerauth.soap.GetCallbackUrlListRequest;
import io.getlime.powerauth.soap.GetCallbackUrlListResponse;
import io.getlime.powerauth.soap.GetIntegrationListRequest;
import io.getlime.powerauth.soap.GetIntegrationListResponse;
import io.getlime.powerauth.soap.GetNonPersonalizedEncryptionKeyRequest;
import io.getlime.powerauth.soap.GetNonPersonalizedEncryptionKeyResponse;
import io.getlime.powerauth.soap.GetPersonalizedEncryptionKeyRequest;
import io.getlime.powerauth.soap.GetPersonalizedEncryptionKeyResponse;
import io.getlime.powerauth.soap.GetSystemStatusRequest;
import io.getlime.powerauth.soap.GetSystemStatusResponse;
import io.getlime.powerauth.soap.InitActivationRequest;
import io.getlime.powerauth.soap.InitActivationResponse;
import io.getlime.powerauth.soap.PrepareActivationRequest;
import io.getlime.powerauth.soap.PrepareActivationResponse;
import io.getlime.powerauth.soap.RemoveActivationRequest;
import io.getlime.powerauth.soap.RemoveActivationResponse;
import io.getlime.powerauth.soap.RemoveCallbackUrlRequest;
import io.getlime.powerauth.soap.RemoveCallbackUrlResponse;
import io.getlime.powerauth.soap.RemoveIntegrationRequest;
import io.getlime.powerauth.soap.RemoveIntegrationResponse;
import io.getlime.powerauth.soap.RemoveTokenRequest;
import io.getlime.powerauth.soap.RemoveTokenResponse;
import io.getlime.powerauth.soap.SignatureAuditRequest;
import io.getlime.powerauth.soap.SignatureAuditResponse;
import io.getlime.powerauth.soap.SignatureType;
import io.getlime.powerauth.soap.SupportApplicationVersionRequest;
import io.getlime.powerauth.soap.SupportApplicationVersionResponse;
import io.getlime.powerauth.soap.UnblockActivationRequest;
import io.getlime.powerauth.soap.UnblockActivationResponse;
import io.getlime.powerauth.soap.UnsupportApplicationVersionRequest;
import io.getlime.powerauth.soap.UnsupportApplicationVersionResponse;
import io.getlime.powerauth.soap.ValidateTokenRequest;
import io.getlime.powerauth.soap.ValidateTokenResponse;
import io.getlime.powerauth.soap.VaultUnlockRequest;
import io.getlime.powerauth.soap.VaultUnlockResponse;
import io.getlime.powerauth.soap.VerifyECDSASignatureRequest;
import io.getlime.powerauth.soap.VerifyECDSASignatureResponse;
import io.getlime.powerauth.soap.VerifyOfflineSignatureRequest;
import io.getlime.powerauth.soap.VerifyOfflineSignatureResponse;
import io.getlime.powerauth.soap.VerifySignatureRequest;
import io.getlime.powerauth.soap.VerifySignatureResponse;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.springframework.ws.client.core.support.WebServiceGatewaySupport;

public class PowerAuthServiceClient
extends WebServiceGatewaySupport {
    private XMLGregorianCalendar calendarWithDate(Date date) {
        try {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public GetSystemStatusResponse getSystemStatus(GetSystemStatusRequest request) {
        return (GetSystemStatusResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public GetSystemStatusResponse getSystemStatus() {
        GetSystemStatusRequest request = new GetSystemStatusRequest();
        return (GetSystemStatusResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public InitActivationResponse initActivation(InitActivationRequest request) {
        return (InitActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public InitActivationResponse initActivation(String userId, Long applicationId) {
        return this.initActivation(userId, applicationId, null, null);
    }

    public InitActivationResponse initActivation(String userId, Long applicationId, Long maxFailureCount, Date timestampActivationExpire) {
        InitActivationRequest request = new InitActivationRequest();
        request.setUserId(userId);
        request.setApplicationId(applicationId);
        if (maxFailureCount != null) {
            request.setMaxFailureCount(maxFailureCount);
        }
        if (timestampActivationExpire != null) {
            request.setTimestampActivationExpire(this.calendarWithDate(timestampActivationExpire));
        }
        return this.initActivation(request);
    }

    public PrepareActivationResponse prepareActivation(PrepareActivationRequest request) {
        return (PrepareActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public PrepareActivationResponse prepareActivation(String activationIdShort, String activationName, String activationNonce, String ephemeralPublicKey, String cDevicePublicKey, String extras, String applicationKey, String applicationSignature) {
        PrepareActivationRequest request = new PrepareActivationRequest();
        request.setActivationIdShort(activationIdShort);
        request.setActivationName(activationName);
        request.setActivationNonce(activationNonce);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedDevicePublicKey(cDevicePublicKey);
        request.setExtras(extras);
        request.setApplicationKey(applicationKey);
        request.setApplicationSignature(applicationSignature);
        return this.prepareActivation(request);
    }

    public CreateActivationResponse createActivation(CreateActivationRequest request) {
        return (CreateActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CreateActivationResponse createActivation(String applicationKey, String userId, String identity, String activationName, String activationNonce, String ephemeralPublicKey, String cDevicePublicKey, String extras, String applicationSignature) {
        return this.createActivation(applicationKey, userId, null, null, identity, "00000-00000", activationName, activationNonce, ephemeralPublicKey, cDevicePublicKey, extras, applicationSignature);
    }

    public CreateActivationResponse createActivation(String applicationKey, String userId, Long maxFailureCount, Date timestampActivationExpire, String identity, String activationOtp, String activationName, String activationNonce, String ephemeralPublicKey, String cDevicePublicKey, String extras, String applicationSignature) {
        CreateActivationRequest request = new CreateActivationRequest();
        request.setApplicationKey(applicationKey);
        request.setUserId(userId);
        if (maxFailureCount != null) {
            request.setMaxFailureCount(maxFailureCount);
        }
        if (timestampActivationExpire != null) {
            request.setTimestampActivationExpire(this.calendarWithDate(timestampActivationExpire));
        }
        request.setIdentity(identity);
        request.setActivationOtp(activationOtp);
        request.setActivationName(activationName);
        request.setActivationNonce(activationNonce);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedDevicePublicKey(cDevicePublicKey);
        request.setExtras(extras);
        request.setApplicationSignature(applicationSignature);
        return this.createActivation(request);
    }

    public CommitActivationResponse commitActivation(CommitActivationRequest request) {
        return (CommitActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CommitActivationResponse commitActivation(String activationId) {
        CommitActivationRequest request = new CommitActivationRequest();
        request.setActivationId(activationId);
        return this.commitActivation(request);
    }

    public GetActivationStatusResponse getActivationStatus(GetActivationStatusRequest request) {
        return (GetActivationStatusResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public GetActivationStatusResponse getActivationStatus(String activationId) {
        GetActivationStatusRequest request = new GetActivationStatusRequest();
        request.setActivationId(activationId);
        return this.getActivationStatus(request);
    }

    public GetActivationListForUserResponse getActivationListForUser(GetActivationListForUserRequest request) {
        return (GetActivationListForUserResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<GetActivationListForUserResponse.Activations> getActivationListForUser(String userId) {
        GetActivationListForUserRequest request = new GetActivationListForUserRequest();
        request.setUserId(userId);
        return this.getActivationListForUser(request).getActivations();
    }

    public RemoveActivationResponse removeActivation(RemoveActivationRequest request) {
        return (RemoveActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public RemoveActivationResponse removeActivation(String activationId) {
        RemoveActivationRequest request = new RemoveActivationRequest();
        request.setActivationId(activationId);
        return this.removeActivation(request);
    }

    public BlockActivationResponse blockActivation(BlockActivationRequest request) {
        return (BlockActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public BlockActivationResponse blockActivation(String activationId, String reason) {
        BlockActivationRequest request = new BlockActivationRequest();
        request.setActivationId(activationId);
        request.setReason(reason);
        return this.blockActivation(request);
    }

    public UnblockActivationResponse unblockActivation(UnblockActivationRequest request) {
        return (UnblockActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public UnblockActivationResponse unblockActivation(String activationId) {
        UnblockActivationRequest request = new UnblockActivationRequest();
        request.setActivationId(activationId);
        return this.unblockActivation(request);
    }

    public VaultUnlockResponse unlockVault(VaultUnlockRequest request) {
        return (VaultUnlockResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public VaultUnlockResponse unlockVault(String activationId, String applicationKey, String data, String signature, SignatureType signatureType, String reason) {
        VaultUnlockRequest request = new VaultUnlockRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setData(data);
        request.setSignature(signature);
        request.setSignatureType(signatureType);
        request.setReason(reason);
        return this.unlockVault(request);
    }

    public CreateOfflineSignaturePayloadResponse createOfflineSignaturePayload(String activationId, String data, String message) {
        CreateOfflineSignaturePayloadRequest request = new CreateOfflineSignaturePayloadRequest();
        request.setActivationId(activationId);
        request.setData(data);
        request.setMessage(message);
        return this.createOfflineSignaturePayload(request);
    }

    public CreateOfflineSignaturePayloadResponse createOfflineSignaturePayload(CreateOfflineSignaturePayloadRequest request) {
        return (CreateOfflineSignaturePayloadResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public VerifyOfflineSignatureResponse verifyOfflineSignature(String activationId, String data, String signature, SignatureType signatureType) {
        VerifyOfflineSignatureRequest request = new VerifyOfflineSignatureRequest();
        request.setActivationId(activationId);
        request.setData(data);
        request.setSignature(signature);
        request.setSignatureType(signatureType);
        return this.verifyOfflineSignature(request);
    }

    public VerifyOfflineSignatureResponse verifyOfflineSignature(VerifyOfflineSignatureRequest request) {
        return (VerifyOfflineSignatureResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public VerifySignatureResponse verifySignature(VerifySignatureRequest request) {
        return (VerifySignatureResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public VerifySignatureResponse verifySignature(String activationId, String applicationKey, String data, String signature, SignatureType signatureType) {
        VerifySignatureRequest request = new VerifySignatureRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setData(data);
        request.setSignature(signature);
        request.setSignatureType(signatureType);
        return this.verifySignature(request);
    }

    public VerifyECDSASignatureResponse verifyECDSASignature(VerifyECDSASignatureRequest request) {
        return (VerifyECDSASignatureResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public VerifyECDSASignatureResponse verifyECDSASignature(String activationId, String data, String signature) {
        VerifyECDSASignatureRequest request = new VerifyECDSASignatureRequest();
        request.setActivationId(activationId);
        request.setData(data);
        request.setSignature(signature);
        return this.verifyECDSASignature(request);
    }

    public GetPersonalizedEncryptionKeyResponse generatePersonalizedE2EEncryptionKey(GetPersonalizedEncryptionKeyRequest request) {
        return (GetPersonalizedEncryptionKeyResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public GetPersonalizedEncryptionKeyResponse generatePersonalizedE2EEncryptionKey(String activationId, String sessionIndex) {
        GetPersonalizedEncryptionKeyRequest request = new GetPersonalizedEncryptionKeyRequest();
        request.setActivationId(activationId);
        request.setSessionIndex(sessionIndex);
        return this.generatePersonalizedE2EEncryptionKey(request);
    }

    public GetNonPersonalizedEncryptionKeyResponse generateNonPersonalizedE2EEncryptionKey(GetNonPersonalizedEncryptionKeyRequest request) {
        return (GetNonPersonalizedEncryptionKeyResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public GetNonPersonalizedEncryptionKeyResponse generateNonPersonalizedE2EEncryptionKey(String applicationKey, String ephemeralPublicKeyBase64, String sessionIndex) {
        GetNonPersonalizedEncryptionKeyRequest request = new GetNonPersonalizedEncryptionKeyRequest();
        request.setApplicationKey(applicationKey);
        request.setEphemeralPublicKey(ephemeralPublicKeyBase64);
        request.setSessionIndex(sessionIndex);
        return this.generateNonPersonalizedE2EEncryptionKey(request);
    }

    public SignatureAuditResponse getSignatureAuditLog(SignatureAuditRequest request) {
        return (SignatureAuditResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<SignatureAuditResponse.Items> getSignatureAuditLog(String userId, Date startingDate, Date endingDate) {
        SignatureAuditRequest request = new SignatureAuditRequest();
        request.setUserId(userId);
        request.setTimestampFrom(this.calendarWithDate(startingDate));
        request.setTimestampTo(this.calendarWithDate(endingDate));
        return this.getSignatureAuditLog(request).getItems();
    }

    public List<SignatureAuditResponse.Items> getSignatureAuditLog(String userId, Long applicationId, Date startingDate, Date endingDate) {
        SignatureAuditRequest request = new SignatureAuditRequest();
        request.setUserId(userId);
        request.setApplicationId(applicationId);
        request.setTimestampFrom(this.calendarWithDate(startingDate));
        request.setTimestampTo(this.calendarWithDate(endingDate));
        return this.getSignatureAuditLog(request).getItems();
    }

    public ActivationHistoryResponse getActivationHistory(ActivationHistoryRequest request) {
        return (ActivationHistoryResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<ActivationHistoryResponse.Items> getActivationHistory(String activationId, Date startingDate, Date endingDate) {
        ActivationHistoryRequest request = new ActivationHistoryRequest();
        request.setActivationId(activationId);
        request.setTimestampFrom(this.calendarWithDate(startingDate));
        request.setTimestampTo(this.calendarWithDate(endingDate));
        return this.getActivationHistory(request).getItems();
    }

    public GetApplicationListResponse getApplicationList(GetApplicationListRequest request) {
        return (GetApplicationListResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<GetApplicationListResponse.Applications> getApplicationList() {
        return this.getApplicationList(new GetApplicationListRequest()).getApplications();
    }

    public GetApplicationDetailResponse getApplicationDetail(GetApplicationDetailRequest request) {
        return (GetApplicationDetailResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public GetApplicationDetailResponse getApplicationDetail(Long applicationId) {
        GetApplicationDetailRequest request = new GetApplicationDetailRequest();
        request.setApplicationId(applicationId);
        return this.getApplicationDetail(request);
    }

    public CreateApplicationResponse createApplication(CreateApplicationRequest request) {
        return (CreateApplicationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CreateApplicationResponse createApplication(String name) {
        CreateApplicationRequest request = new CreateApplicationRequest();
        request.setApplicationName(name);
        return this.createApplication(request);
    }

    public CreateApplicationVersionResponse createApplicationVersion(CreateApplicationVersionRequest request) {
        return (CreateApplicationVersionResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CreateApplicationVersionResponse createApplicationVersion(Long applicationId, String versionName) {
        CreateApplicationVersionRequest request = new CreateApplicationVersionRequest();
        request.setApplicationId(applicationId);
        request.setApplicationVersionName(versionName);
        return this.createApplicationVersion(request);
    }

    public UnsupportApplicationVersionResponse unsupportApplicationVersion(UnsupportApplicationVersionRequest request) {
        return (UnsupportApplicationVersionResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public UnsupportApplicationVersionResponse unsupportApplicationVersion(Long versionId) {
        UnsupportApplicationVersionRequest request = new UnsupportApplicationVersionRequest();
        request.setApplicationVersionId(versionId);
        return this.unsupportApplicationVersion(request);
    }

    public SupportApplicationVersionResponse supportApplicationVersion(SupportApplicationVersionRequest request) {
        return (SupportApplicationVersionResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public SupportApplicationVersionResponse supportApplicationVersion(Long versionId) {
        SupportApplicationVersionRequest request = new SupportApplicationVersionRequest();
        request.setApplicationVersionId(versionId);
        return this.supportApplicationVersion(request);
    }

    public CreateIntegrationResponse createIntegration(CreateIntegrationRequest request) {
        return (CreateIntegrationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CreateIntegrationResponse createIntegration(String name) {
        CreateIntegrationRequest request = new CreateIntegrationRequest();
        request.setName(name);
        return this.createIntegration(request);
    }

    public GetIntegrationListResponse getIntegrationList(GetIntegrationListRequest request) {
        return (GetIntegrationListResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<GetIntegrationListResponse.Items> getIntegrationList() {
        return this.getIntegrationList(new GetIntegrationListRequest()).getItems();
    }

    public RemoveIntegrationResponse removeIntegration(RemoveIntegrationRequest request) {
        return (RemoveIntegrationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public RemoveIntegrationResponse removeIntegration(String id) {
        RemoveIntegrationRequest request = new RemoveIntegrationRequest();
        request.setId(id);
        return this.removeIntegration(request);
    }

    public CreateCallbackUrlResponse createCallbackUrl(CreateCallbackUrlRequest request) {
        return (CreateCallbackUrlResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CreateCallbackUrlResponse createCallbackUrl(Long applicationId, String name, String callbackUrl) {
        CreateCallbackUrlRequest request = new CreateCallbackUrlRequest();
        request.setApplicationId(applicationId);
        request.setName(name);
        request.setCallbackUrl(callbackUrl);
        return this.createCallbackUrl(request);
    }

    public GetCallbackUrlListResponse getCallbackUrlList(GetCallbackUrlListRequest request) {
        return (GetCallbackUrlListResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<GetCallbackUrlListResponse.CallbackUrlList> getCallbackUrlList(Long applicationId) {
        GetCallbackUrlListRequest request = new GetCallbackUrlListRequest();
        request.setApplicationId(applicationId);
        return this.getCallbackUrlList(request).getCallbackUrlList();
    }

    public RemoveCallbackUrlResponse removeCallbackUrl(RemoveCallbackUrlRequest request) {
        return (RemoveCallbackUrlResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public RemoveCallbackUrlResponse removeCallbackUrl(String callbackUrlId) {
        RemoveCallbackUrlRequest request = new RemoveCallbackUrlRequest();
        request.setId(callbackUrlId);
        return this.removeCallbackUrl(request);
    }

    public CreateTokenResponse createToken(CreateTokenRequest request) {
        return (CreateTokenResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CreateTokenResponse createToken(String activationId, String ephemeralPublicKey, SignatureType signatureType) {
        CreateTokenRequest request = new CreateTokenRequest();
        request.setActivationId(activationId);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setSignatureType(signatureType);
        return this.createToken(request);
    }

    public ValidateTokenResponse validateToken(ValidateTokenRequest request) {
        return (ValidateTokenResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public ValidateTokenResponse validateToken(String tokenId, String nonce, long timestamp, String tokenDigest) {
        ValidateTokenRequest request = new ValidateTokenRequest();
        request.setTokenId(tokenId);
        request.setNonce(nonce);
        request.setTimestamp(timestamp);
        request.setTokenDigest(tokenDigest);
        return this.validateToken(request);
    }

    public RemoveTokenResponse removeToken(RemoveTokenRequest request) {
        return (RemoveTokenResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public RemoveTokenResponse removeToken(String tokenId, String activationId) {
        RemoveTokenRequest request = new RemoveTokenRequest();
        request.setTokenId(tokenId);
        request.setActivationId(activationId);
        return this.removeToken(request);
    }
}

