/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.soap.spring.client;

import io.getlime.powerauth.soap.v2.CreateActivationRequest;
import io.getlime.powerauth.soap.v2.CreateActivationResponse;
import io.getlime.powerauth.soap.v2.CreateTokenResponse;
import io.getlime.powerauth.soap.v2.GetNonPersonalizedEncryptionKeyRequest;
import io.getlime.powerauth.soap.v2.GetNonPersonalizedEncryptionKeyResponse;
import io.getlime.powerauth.soap.v2.GetPersonalizedEncryptionKeyRequest;
import io.getlime.powerauth.soap.v2.GetPersonalizedEncryptionKeyResponse;
import io.getlime.powerauth.soap.v2.PrepareActivationRequest;
import io.getlime.powerauth.soap.v2.PrepareActivationResponse;
import io.getlime.powerauth.soap.v2.VaultUnlockRequest;
import io.getlime.powerauth.soap.v3.ActivationHistoryRequest;
import io.getlime.powerauth.soap.v3.ActivationHistoryResponse;
import io.getlime.powerauth.soap.v3.ActivationStatus;
import io.getlime.powerauth.soap.v3.BlockActivationRequest;
import io.getlime.powerauth.soap.v3.BlockActivationResponse;
import io.getlime.powerauth.soap.v3.CommitActivationRequest;
import io.getlime.powerauth.soap.v3.CommitActivationResponse;
import io.getlime.powerauth.soap.v3.CommitUpgradeRequest;
import io.getlime.powerauth.soap.v3.CommitUpgradeResponse;
import io.getlime.powerauth.soap.v3.ConfirmRecoveryCodeRequest;
import io.getlime.powerauth.soap.v3.ConfirmRecoveryCodeResponse;
import io.getlime.powerauth.soap.v3.CreateApplicationRequest;
import io.getlime.powerauth.soap.v3.CreateApplicationResponse;
import io.getlime.powerauth.soap.v3.CreateApplicationVersionRequest;
import io.getlime.powerauth.soap.v3.CreateApplicationVersionResponse;
import io.getlime.powerauth.soap.v3.CreateCallbackUrlRequest;
import io.getlime.powerauth.soap.v3.CreateCallbackUrlResponse;
import io.getlime.powerauth.soap.v3.CreateIntegrationRequest;
import io.getlime.powerauth.soap.v3.CreateIntegrationResponse;
import io.getlime.powerauth.soap.v3.CreateNonPersonalizedOfflineSignaturePayloadRequest;
import io.getlime.powerauth.soap.v3.CreateNonPersonalizedOfflineSignaturePayloadResponse;
import io.getlime.powerauth.soap.v3.CreatePersonalizedOfflineSignaturePayloadRequest;
import io.getlime.powerauth.soap.v3.CreatePersonalizedOfflineSignaturePayloadResponse;
import io.getlime.powerauth.soap.v3.CreateRecoveryCodeRequest;
import io.getlime.powerauth.soap.v3.CreateRecoveryCodeResponse;
import io.getlime.powerauth.soap.v3.CreateTokenRequest;
import io.getlime.powerauth.soap.v3.GetActivationListForUserRequest;
import io.getlime.powerauth.soap.v3.GetActivationListForUserResponse;
import io.getlime.powerauth.soap.v3.GetActivationStatusRequest;
import io.getlime.powerauth.soap.v3.GetActivationStatusResponse;
import io.getlime.powerauth.soap.v3.GetApplicationDetailRequest;
import io.getlime.powerauth.soap.v3.GetApplicationDetailResponse;
import io.getlime.powerauth.soap.v3.GetApplicationListRequest;
import io.getlime.powerauth.soap.v3.GetApplicationListResponse;
import io.getlime.powerauth.soap.v3.GetCallbackUrlListRequest;
import io.getlime.powerauth.soap.v3.GetCallbackUrlListResponse;
import io.getlime.powerauth.soap.v3.GetEciesDecryptorRequest;
import io.getlime.powerauth.soap.v3.GetEciesDecryptorResponse;
import io.getlime.powerauth.soap.v3.GetIntegrationListRequest;
import io.getlime.powerauth.soap.v3.GetIntegrationListResponse;
import io.getlime.powerauth.soap.v3.GetRecoveryConfigRequest;
import io.getlime.powerauth.soap.v3.GetRecoveryConfigResponse;
import io.getlime.powerauth.soap.v3.GetSystemStatusRequest;
import io.getlime.powerauth.soap.v3.GetSystemStatusResponse;
import io.getlime.powerauth.soap.v3.InitActivationRequest;
import io.getlime.powerauth.soap.v3.InitActivationResponse;
import io.getlime.powerauth.soap.v3.LookupActivationsRequest;
import io.getlime.powerauth.soap.v3.LookupActivationsResponse;
import io.getlime.powerauth.soap.v3.LookupApplicationByAppKeyRequest;
import io.getlime.powerauth.soap.v3.LookupApplicationByAppKeyResponse;
import io.getlime.powerauth.soap.v3.LookupRecoveryCodesRequest;
import io.getlime.powerauth.soap.v3.LookupRecoveryCodesResponse;
import io.getlime.powerauth.soap.v3.RecoveryCodeActivationRequest;
import io.getlime.powerauth.soap.v3.RecoveryCodeActivationResponse;
import io.getlime.powerauth.soap.v3.RecoveryCodeStatus;
import io.getlime.powerauth.soap.v3.RecoveryPukStatus;
import io.getlime.powerauth.soap.v3.RemoveActivationRequest;
import io.getlime.powerauth.soap.v3.RemoveActivationResponse;
import io.getlime.powerauth.soap.v3.RemoveCallbackUrlRequest;
import io.getlime.powerauth.soap.v3.RemoveCallbackUrlResponse;
import io.getlime.powerauth.soap.v3.RemoveIntegrationRequest;
import io.getlime.powerauth.soap.v3.RemoveIntegrationResponse;
import io.getlime.powerauth.soap.v3.RemoveTokenRequest;
import io.getlime.powerauth.soap.v3.RemoveTokenResponse;
import io.getlime.powerauth.soap.v3.RevokeRecoveryCodesRequest;
import io.getlime.powerauth.soap.v3.RevokeRecoveryCodesResponse;
import io.getlime.powerauth.soap.v3.SignatureAuditRequest;
import io.getlime.powerauth.soap.v3.SignatureAuditResponse;
import io.getlime.powerauth.soap.v3.SignatureType;
import io.getlime.powerauth.soap.v3.StartUpgradeRequest;
import io.getlime.powerauth.soap.v3.StartUpgradeResponse;
import io.getlime.powerauth.soap.v3.SupportApplicationVersionRequest;
import io.getlime.powerauth.soap.v3.SupportApplicationVersionResponse;
import io.getlime.powerauth.soap.v3.UnblockActivationRequest;
import io.getlime.powerauth.soap.v3.UnblockActivationResponse;
import io.getlime.powerauth.soap.v3.UnsupportApplicationVersionRequest;
import io.getlime.powerauth.soap.v3.UnsupportApplicationVersionResponse;
import io.getlime.powerauth.soap.v3.UpdateRecoveryConfigRequest;
import io.getlime.powerauth.soap.v3.UpdateRecoveryConfigResponse;
import io.getlime.powerauth.soap.v3.UpdateStatusForActivationsRequest;
import io.getlime.powerauth.soap.v3.UpdateStatusForActivationsResponse;
import io.getlime.powerauth.soap.v3.ValidateTokenRequest;
import io.getlime.powerauth.soap.v3.ValidateTokenResponse;
import io.getlime.powerauth.soap.v3.VaultUnlockResponse;
import io.getlime.powerauth.soap.v3.VerifyECDSASignatureRequest;
import io.getlime.powerauth.soap.v3.VerifyECDSASignatureResponse;
import io.getlime.powerauth.soap.v3.VerifyOfflineSignatureRequest;
import io.getlime.powerauth.soap.v3.VerifyOfflineSignatureResponse;
import io.getlime.powerauth.soap.v3.VerifySignatureRequest;
import io.getlime.powerauth.soap.v3.VerifySignatureResponse;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.client.core.support.WebServiceGatewaySupport;

public class PowerAuthServiceClient
extends WebServiceGatewaySupport {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthServiceClient.class);

    private XMLGregorianCalendar calendarWithDate(Date date) {
        try {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException e) {
            logger.error("Unable to prepare a new calendar instance", (Throwable)e);
            return null;
        }
    }

    public GetSystemStatusResponse getSystemStatus(GetSystemStatusRequest request) {
        return (GetSystemStatusResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public GetSystemStatusResponse getSystemStatus() {
        GetSystemStatusRequest request = new GetSystemStatusRequest();
        return (GetSystemStatusResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public InitActivationResponse initActivation(InitActivationRequest request) {
        return (InitActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public InitActivationResponse initActivation(String userId, Long applicationId) {
        return this.initActivation(userId, applicationId, null, null);
    }

    public InitActivationResponse initActivation(String userId, Long applicationId, Long maxFailureCount, Date timestampActivationExpire) {
        InitActivationRequest request = new InitActivationRequest();
        request.setUserId(userId);
        request.setApplicationId(applicationId);
        if (maxFailureCount != null) {
            request.setMaxFailureCount(maxFailureCount);
        }
        if (timestampActivationExpire != null) {
            request.setTimestampActivationExpire(this.calendarWithDate(timestampActivationExpire));
        }
        return this.initActivation(request);
    }

    public io.getlime.powerauth.soap.v3.PrepareActivationResponse prepareActivation(io.getlime.powerauth.soap.v3.PrepareActivationRequest request) {
        return (io.getlime.powerauth.soap.v3.PrepareActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public io.getlime.powerauth.soap.v3.PrepareActivationResponse prepareActivation(String activationCode, String applicationKey, String ephemeralPublicKey, String encryptedData, String mac, String nonce) {
        io.getlime.powerauth.soap.v3.PrepareActivationRequest request = new io.getlime.powerauth.soap.v3.PrepareActivationRequest();
        request.setActivationCode(activationCode);
        request.setApplicationKey(applicationKey);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        return this.prepareActivation(request);
    }

    public io.getlime.powerauth.soap.v3.CreateActivationResponse createActivation(io.getlime.powerauth.soap.v3.CreateActivationRequest request) {
        return (io.getlime.powerauth.soap.v3.CreateActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public io.getlime.powerauth.soap.v3.CreateActivationResponse createActivation(String userId, Date timestampActivationExpire, Long maxFailureCount, String applicationKey, String ephemeralPublicKey, String encryptedData, String mac, String nonce) {
        io.getlime.powerauth.soap.v3.CreateActivationRequest request = new io.getlime.powerauth.soap.v3.CreateActivationRequest();
        request.setUserId(userId);
        if (timestampActivationExpire != null) {
            request.setTimestampActivationExpire(this.calendarWithDate(timestampActivationExpire));
        }
        if (maxFailureCount != null) {
            request.setMaxFailureCount(maxFailureCount);
        }
        request.setApplicationKey(applicationKey);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        return this.createActivation(request);
    }

    public CommitActivationResponse commitActivation(CommitActivationRequest request) {
        return (CommitActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CommitActivationResponse commitActivation(String activationId, String externalUserId) {
        CommitActivationRequest request = new CommitActivationRequest();
        request.setActivationId(activationId);
        request.setExternalUserId(externalUserId);
        return this.commitActivation(request);
    }

    public GetActivationStatusResponse getActivationStatus(GetActivationStatusRequest request) {
        return (GetActivationStatusResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public GetActivationStatusResponse getActivationStatus(String activationId) {
        GetActivationStatusResponse response = this.getActivationStatusWithEncryptedStatusBlob(activationId, null);
        response.setEncryptedStatusBlob(null);
        return response;
    }

    public GetActivationStatusResponse getActivationStatusWithEncryptedStatusBlob(String activationId, String challenge) {
        GetActivationStatusRequest request = new GetActivationStatusRequest();
        request.setActivationId(activationId);
        request.setChallenge(challenge);
        return this.getActivationStatus(request);
    }

    public GetActivationListForUserResponse getActivationListForUser(GetActivationListForUserRequest request) {
        return (GetActivationListForUserResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<GetActivationListForUserResponse.Activations> getActivationListForUser(String userId) {
        GetActivationListForUserRequest request = new GetActivationListForUserRequest();
        request.setUserId(userId);
        return this.getActivationListForUser(request).getActivations();
    }

    public LookupActivationsResponse lookupActivations(LookupActivationsRequest request) {
        return (LookupActivationsResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<LookupActivationsResponse.Activations> lookupActivations(List<String> userIds, List<Long> applicationIds, Date timestampLastUsedBefore, Date timestampLastUsedAfter, ActivationStatus activationStatus) {
        LookupActivationsRequest request = new LookupActivationsRequest();
        request.getUserIds().addAll(userIds);
        if (request.getApplicationIds() != null) {
            request.getApplicationIds().addAll(applicationIds);
        }
        if (timestampLastUsedBefore != null) {
            request.setTimestampLastUsedBefore(this.calendarWithDate(timestampLastUsedBefore));
        }
        if (timestampLastUsedBefore != null) {
            request.setTimestampLastUsedAfter(this.calendarWithDate(timestampLastUsedAfter));
        }
        if (request.getActivationStatus() != null) {
            request.setActivationStatus(activationStatus);
        }
        return this.lookupActivations(request).getActivations();
    }

    public UpdateStatusForActivationsResponse updateStatusForActivations(UpdateStatusForActivationsRequest request) {
        return (UpdateStatusForActivationsResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public UpdateStatusForActivationsResponse updateStatusForActivations(List<String> activationIds, ActivationStatus activationStatus) {
        UpdateStatusForActivationsRequest request = new UpdateStatusForActivationsRequest();
        request.getActivationIds().addAll(activationIds);
        if (activationStatus != null) {
            request.setActivationStatus(activationStatus);
        }
        return this.updateStatusForActivations(request);
    }

    public RemoveActivationResponse removeActivation(RemoveActivationRequest request) {
        return (RemoveActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public RemoveActivationResponse removeActivation(String activationId, String externalUserId) {
        RemoveActivationRequest request = new RemoveActivationRequest();
        request.setActivationId(activationId);
        request.setExternalUserId(externalUserId);
        return this.removeActivation(request);
    }

    public BlockActivationResponse blockActivation(BlockActivationRequest request) {
        return (BlockActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public BlockActivationResponse blockActivation(String activationId, String reason, String externalUserId) {
        BlockActivationRequest request = new BlockActivationRequest();
        request.setActivationId(activationId);
        request.setReason(reason);
        request.setExternalUserId(externalUserId);
        return this.blockActivation(request);
    }

    public UnblockActivationResponse unblockActivation(UnblockActivationRequest request) {
        return (UnblockActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public UnblockActivationResponse unblockActivation(String activationId, String externalUserId) {
        UnblockActivationRequest request = new UnblockActivationRequest();
        request.setActivationId(activationId);
        request.setExternalUserId(externalUserId);
        return this.unblockActivation(request);
    }

    public VaultUnlockResponse unlockVault(io.getlime.powerauth.soap.v3.VaultUnlockRequest request) {
        return (VaultUnlockResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public VaultUnlockResponse unlockVault(String activationId, String applicationKey, String signature, SignatureType signatureType, String signatureVersion, String signedData, String ephemeralPublicKey, String encryptedData, String mac, String nonce) {
        io.getlime.powerauth.soap.v3.VaultUnlockRequest request = new io.getlime.powerauth.soap.v3.VaultUnlockRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setSignedData(signedData);
        request.setSignature(signature);
        request.setSignatureType(signatureType);
        request.setSignatureVersion(signatureVersion);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        return this.unlockVault(request);
    }

    public CreatePersonalizedOfflineSignaturePayloadResponse createPersonalizedOfflineSignaturePayload(String activationId, String data) {
        CreatePersonalizedOfflineSignaturePayloadRequest request = new CreatePersonalizedOfflineSignaturePayloadRequest();
        request.setActivationId(activationId);
        request.setData(data);
        return this.createPersonalizedOfflineSignaturePayload(request);
    }

    public CreatePersonalizedOfflineSignaturePayloadResponse createPersonalizedOfflineSignaturePayload(CreatePersonalizedOfflineSignaturePayloadRequest request) {
        return (CreatePersonalizedOfflineSignaturePayloadResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CreateNonPersonalizedOfflineSignaturePayloadResponse createNonPersonalizedOfflineSignaturePayload(long applicationId, String data) {
        CreateNonPersonalizedOfflineSignaturePayloadRequest request = new CreateNonPersonalizedOfflineSignaturePayloadRequest();
        request.setApplicationId(applicationId);
        request.setData(data);
        return this.createNonPersonalizedOfflineSignaturePayload(request);
    }

    public CreateNonPersonalizedOfflineSignaturePayloadResponse createNonPersonalizedOfflineSignaturePayload(CreateNonPersonalizedOfflineSignaturePayloadRequest request) {
        return (CreateNonPersonalizedOfflineSignaturePayloadResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public VerifyOfflineSignatureResponse verifyOfflineSignature(String activationId, String data, String signature, boolean allowBiometry) {
        VerifyOfflineSignatureRequest request = new VerifyOfflineSignatureRequest();
        request.setActivationId(activationId);
        request.setData(data);
        request.setSignature(signature);
        request.setAllowBiometry(allowBiometry);
        return this.verifyOfflineSignature(request);
    }

    public VerifyOfflineSignatureResponse verifyOfflineSignature(VerifyOfflineSignatureRequest request) {
        return (VerifyOfflineSignatureResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public VerifySignatureResponse verifySignature(VerifySignatureRequest request) {
        return (VerifySignatureResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public VerifySignatureResponse verifySignature(String activationId, String applicationKey, String data, String signature, SignatureType signatureType, String signatureVersion, Long forcedSignatureVersion) {
        VerifySignatureRequest request = new VerifySignatureRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setData(data);
        request.setSignature(signature);
        request.setSignatureType(signatureType);
        request.setSignatureVersion(signatureVersion);
        request.setForcedSignatureVersion(forcedSignatureVersion);
        return this.verifySignature(request);
    }

    public VerifyECDSASignatureResponse verifyECDSASignature(VerifyECDSASignatureRequest request) {
        return (VerifyECDSASignatureResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public VerifyECDSASignatureResponse verifyECDSASignature(String activationId, String data, String signature) {
        VerifyECDSASignatureRequest request = new VerifyECDSASignatureRequest();
        request.setActivationId(activationId);
        request.setData(data);
        request.setSignature(signature);
        return this.verifyECDSASignature(request);
    }

    public SignatureAuditResponse getSignatureAuditLog(SignatureAuditRequest request) {
        return (SignatureAuditResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<SignatureAuditResponse.Items> getSignatureAuditLog(String userId, Date startingDate, Date endingDate) {
        SignatureAuditRequest request = new SignatureAuditRequest();
        request.setUserId(userId);
        request.setTimestampFrom(this.calendarWithDate(startingDate));
        request.setTimestampTo(this.calendarWithDate(endingDate));
        return this.getSignatureAuditLog(request).getItems();
    }

    public List<SignatureAuditResponse.Items> getSignatureAuditLog(String userId, Long applicationId, Date startingDate, Date endingDate) {
        SignatureAuditRequest request = new SignatureAuditRequest();
        request.setUserId(userId);
        request.setApplicationId(applicationId);
        request.setTimestampFrom(this.calendarWithDate(startingDate));
        request.setTimestampTo(this.calendarWithDate(endingDate));
        return this.getSignatureAuditLog(request).getItems();
    }

    public ActivationHistoryResponse getActivationHistory(ActivationHistoryRequest request) {
        return (ActivationHistoryResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<ActivationHistoryResponse.Items> getActivationHistory(String activationId, Date startingDate, Date endingDate) {
        ActivationHistoryRequest request = new ActivationHistoryRequest();
        request.setActivationId(activationId);
        request.setTimestampFrom(this.calendarWithDate(startingDate));
        request.setTimestampTo(this.calendarWithDate(endingDate));
        return this.getActivationHistory(request).getItems();
    }

    public GetApplicationListResponse getApplicationList(GetApplicationListRequest request) {
        return (GetApplicationListResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<GetApplicationListResponse.Applications> getApplicationList() {
        return this.getApplicationList(new GetApplicationListRequest()).getApplications();
    }

    public GetApplicationDetailResponse getApplicationDetail(GetApplicationDetailRequest request) {
        return (GetApplicationDetailResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public GetApplicationDetailResponse getApplicationDetail(Long applicationId) {
        GetApplicationDetailRequest request = new GetApplicationDetailRequest();
        request.setApplicationId(applicationId);
        return this.getApplicationDetail(request);
    }

    public GetApplicationDetailResponse getApplicationDetail(String applicationName) {
        GetApplicationDetailRequest request = new GetApplicationDetailRequest();
        request.setApplicationName(applicationName);
        return this.getApplicationDetail(request);
    }

    public LookupApplicationByAppKeyResponse lookupApplicationByAppKey(LookupApplicationByAppKeyRequest request) {
        return (LookupApplicationByAppKeyResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public LookupApplicationByAppKeyResponse lookupApplicationByAppKey(String applicationKey) {
        LookupApplicationByAppKeyRequest request = new LookupApplicationByAppKeyRequest();
        request.setApplicationKey(applicationKey);
        return this.lookupApplicationByAppKey(request);
    }

    public CreateApplicationResponse createApplication(CreateApplicationRequest request) {
        return (CreateApplicationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CreateApplicationResponse createApplication(String name) {
        CreateApplicationRequest request = new CreateApplicationRequest();
        request.setApplicationName(name);
        return this.createApplication(request);
    }

    public CreateApplicationVersionResponse createApplicationVersion(CreateApplicationVersionRequest request) {
        return (CreateApplicationVersionResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CreateApplicationVersionResponse createApplicationVersion(Long applicationId, String versionName) {
        CreateApplicationVersionRequest request = new CreateApplicationVersionRequest();
        request.setApplicationId(applicationId);
        request.setApplicationVersionName(versionName);
        return this.createApplicationVersion(request);
    }

    public UnsupportApplicationVersionResponse unsupportApplicationVersion(UnsupportApplicationVersionRequest request) {
        return (UnsupportApplicationVersionResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public UnsupportApplicationVersionResponse unsupportApplicationVersion(Long versionId) {
        UnsupportApplicationVersionRequest request = new UnsupportApplicationVersionRequest();
        request.setApplicationVersionId(versionId);
        return this.unsupportApplicationVersion(request);
    }

    public SupportApplicationVersionResponse supportApplicationVersion(SupportApplicationVersionRequest request) {
        return (SupportApplicationVersionResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public SupportApplicationVersionResponse supportApplicationVersion(Long versionId) {
        SupportApplicationVersionRequest request = new SupportApplicationVersionRequest();
        request.setApplicationVersionId(versionId);
        return this.supportApplicationVersion(request);
    }

    public CreateIntegrationResponse createIntegration(CreateIntegrationRequest request) {
        return (CreateIntegrationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CreateIntegrationResponse createIntegration(String name) {
        CreateIntegrationRequest request = new CreateIntegrationRequest();
        request.setName(name);
        return this.createIntegration(request);
    }

    public GetIntegrationListResponse getIntegrationList(GetIntegrationListRequest request) {
        return (GetIntegrationListResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<GetIntegrationListResponse.Items> getIntegrationList() {
        return this.getIntegrationList(new GetIntegrationListRequest()).getItems();
    }

    public RemoveIntegrationResponse removeIntegration(RemoveIntegrationRequest request) {
        return (RemoveIntegrationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public RemoveIntegrationResponse removeIntegration(String id) {
        RemoveIntegrationRequest request = new RemoveIntegrationRequest();
        request.setId(id);
        return this.removeIntegration(request);
    }

    public CreateCallbackUrlResponse createCallbackUrl(CreateCallbackUrlRequest request) {
        return (CreateCallbackUrlResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CreateCallbackUrlResponse createCallbackUrl(Long applicationId, String name, String callbackUrl) {
        CreateCallbackUrlRequest request = new CreateCallbackUrlRequest();
        request.setApplicationId(applicationId);
        request.setName(name);
        request.setCallbackUrl(callbackUrl);
        return this.createCallbackUrl(request);
    }

    public GetCallbackUrlListResponse getCallbackUrlList(GetCallbackUrlListRequest request) {
        return (GetCallbackUrlListResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public List<GetCallbackUrlListResponse.CallbackUrlList> getCallbackUrlList(Long applicationId) {
        GetCallbackUrlListRequest request = new GetCallbackUrlListRequest();
        request.setApplicationId(applicationId);
        return this.getCallbackUrlList(request).getCallbackUrlList();
    }

    public RemoveCallbackUrlResponse removeCallbackUrl(RemoveCallbackUrlRequest request) {
        return (RemoveCallbackUrlResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public RemoveCallbackUrlResponse removeCallbackUrl(String callbackUrlId) {
        RemoveCallbackUrlRequest request = new RemoveCallbackUrlRequest();
        request.setId(callbackUrlId);
        return this.removeCallbackUrl(request);
    }

    public io.getlime.powerauth.soap.v3.CreateTokenResponse createToken(CreateTokenRequest request) {
        return (io.getlime.powerauth.soap.v3.CreateTokenResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public io.getlime.powerauth.soap.v3.CreateTokenResponse createToken(String activationId, String applicationKey, String ephemeralPublicKey, String encryptedData, String mac, String nonce, SignatureType signatureType) {
        CreateTokenRequest request = new CreateTokenRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setNonce(nonce);
        request.setSignatureType(signatureType);
        return this.createToken(request);
    }

    public ValidateTokenResponse validateToken(ValidateTokenRequest request) {
        return (ValidateTokenResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public ValidateTokenResponse validateToken(String tokenId, String nonce, long timestamp, String tokenDigest) {
        ValidateTokenRequest request = new ValidateTokenRequest();
        request.setTokenId(tokenId);
        request.setNonce(nonce);
        request.setTimestamp(timestamp);
        request.setTokenDigest(tokenDigest);
        return this.validateToken(request);
    }

    public RemoveTokenResponse removeToken(RemoveTokenRequest request) {
        return (RemoveTokenResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public RemoveTokenResponse removeToken(String tokenId, String activationId) {
        RemoveTokenRequest request = new RemoveTokenRequest();
        request.setTokenId(tokenId);
        request.setActivationId(activationId);
        return this.removeToken(request);
    }

    public GetEciesDecryptorResponse getEciesDecryptor(GetEciesDecryptorRequest request) {
        return (GetEciesDecryptorResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public GetEciesDecryptorResponse getEciesDecryptor(String activationId, String applicationKey, String ephemeralPublicKey) {
        GetEciesDecryptorRequest request = new GetEciesDecryptorRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        return this.getEciesDecryptor(request);
    }

    public StartUpgradeResponse startUpgrade(StartUpgradeRequest request) {
        return (StartUpgradeResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public StartUpgradeResponse startUpgrade(String activationId, String applicationKey, String ephemeralPublicKey, String encryptedData, String mac, String nonce) {
        StartUpgradeRequest request = new StartUpgradeRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        return this.startUpgrade(request);
    }

    public CommitUpgradeResponse commitUpgrade(CommitUpgradeRequest request) {
        return (CommitUpgradeResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CommitUpgradeResponse commitUpgrade(String activationId, String applicationKey) {
        CommitUpgradeRequest request = new CommitUpgradeRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        return this.commitUpgrade(request);
    }

    public CreateRecoveryCodeResponse createRecoveryCode(CreateRecoveryCodeRequest request) {
        return (CreateRecoveryCodeResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public CreateRecoveryCodeResponse createRecoveryCode(Long applicationId, String userId, Long pukCount) {
        CreateRecoveryCodeRequest request = new CreateRecoveryCodeRequest();
        request.setApplicationId(applicationId);
        request.setUserId(userId);
        request.setPukCount(pukCount);
        return this.createRecoveryCode(request);
    }

    public ConfirmRecoveryCodeResponse confirmRecoveryCode(ConfirmRecoveryCodeRequest request) {
        return (ConfirmRecoveryCodeResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public ConfirmRecoveryCodeResponse confirmRecoveryCode(String activationId, String applicationKey, String ephemeralPublicKey, String encryptedData, String mac, String nonce) {
        ConfirmRecoveryCodeRequest request = new ConfirmRecoveryCodeRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        return this.confirmRecoveryCode(request);
    }

    public LookupRecoveryCodesResponse lookupRecoveryCodes(LookupRecoveryCodesRequest request) {
        return (LookupRecoveryCodesResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public LookupRecoveryCodesResponse lookupRecoveryCodes(String userId, String activationId, Long applicationId, RecoveryCodeStatus recoveryCodeStatus, RecoveryPukStatus recoveryPukStatus) {
        LookupRecoveryCodesRequest request = new LookupRecoveryCodesRequest();
        request.setUserId(userId);
        request.setActivationId(activationId);
        request.setApplicationId(applicationId);
        request.setRecoveryCodeStatus(recoveryCodeStatus);
        request.setRecoveryPukStatus(recoveryPukStatus);
        return this.lookupRecoveryCodes(request);
    }

    public RevokeRecoveryCodesResponse revokeRecoveryCodes(RevokeRecoveryCodesRequest request) {
        return (RevokeRecoveryCodesResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public RevokeRecoveryCodesResponse revokeRecoveryCodes(List<Long> recoveryCodeIds) {
        RevokeRecoveryCodesRequest request = new RevokeRecoveryCodesRequest();
        request.getRecoveryCodeIds().addAll(recoveryCodeIds);
        return this.revokeRecoveryCodes(request);
    }

    public RecoveryCodeActivationResponse createActivationUsingRecoveryCode(RecoveryCodeActivationRequest request) {
        return (RecoveryCodeActivationResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public RecoveryCodeActivationResponse createActivationUsingRecoveryCode(String recoveryCode, String puk, String applicationKey, Long maxFailureCount, String ephemeralPublicKey, String encryptedData, String mac, String nonce) {
        RecoveryCodeActivationRequest request = new RecoveryCodeActivationRequest();
        request.setRecoveryCode(recoveryCode);
        request.setPuk(puk);
        request.setApplicationKey(applicationKey);
        if (maxFailureCount != null) {
            request.setMaxFailureCount(maxFailureCount);
        }
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        return this.createActivationUsingRecoveryCode(request);
    }

    public GetRecoveryConfigResponse getRecoveryConfig(GetRecoveryConfigRequest request) {
        return (GetRecoveryConfigResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public GetRecoveryConfigResponse getRecoveryConfig(Long applicationId) {
        GetRecoveryConfigRequest request = new GetRecoveryConfigRequest();
        request.setApplicationId(applicationId);
        return this.getRecoveryConfig(request);
    }

    public UpdateRecoveryConfigResponse updateRecoveryConfig(UpdateRecoveryConfigRequest request) {
        return (UpdateRecoveryConfigResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public UpdateRecoveryConfigResponse updateRecoveryConfig(Long applicationId, Boolean activationRecoveryEnabled, Boolean recoveryPostcardEnabled, Boolean allowMultipleRecoveryCodes, String remoteRecoveryPublicKeyBase64) {
        UpdateRecoveryConfigRequest request = new UpdateRecoveryConfigRequest();
        request.setApplicationId(applicationId);
        request.setActivationRecoveryEnabled(activationRecoveryEnabled);
        request.setRecoveryPostcardEnabled(recoveryPostcardEnabled);
        request.setAllowMultipleRecoveryCodes(allowMultipleRecoveryCodes);
        request.setRemotePostcardPublicKey(remoteRecoveryPublicKeyBase64);
        return this.updateRecoveryConfig(request);
    }

    public PowerAuthServiceClientV2 v2() {
        return new PowerAuthServiceClientV2();
    }

    public class PowerAuthServiceClientV2 {
        public PrepareActivationResponse prepareActivation(PrepareActivationRequest request) {
            return (PrepareActivationResponse)PowerAuthServiceClient.this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
        }

        public PrepareActivationResponse prepareActivation(String activationIdShort, String activationName, String activationNonce, String ephemeralPublicKey, String cDevicePublicKey, String extras, String applicationKey, String applicationSignature) {
            PrepareActivationRequest request = new PrepareActivationRequest();
            request.setActivationIdShort(activationIdShort);
            request.setActivationName(activationName);
            request.setActivationNonce(activationNonce);
            request.setEphemeralPublicKey(ephemeralPublicKey);
            request.setEncryptedDevicePublicKey(cDevicePublicKey);
            request.setExtras(extras);
            request.setApplicationKey(applicationKey);
            request.setApplicationSignature(applicationSignature);
            return this.prepareActivation(request);
        }

        public CreateActivationResponse createActivation(CreateActivationRequest request) {
            return (CreateActivationResponse)PowerAuthServiceClient.this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
        }

        public CreateActivationResponse createActivation(String applicationKey, String userId, String identity, String activationName, String activationNonce, String ephemeralPublicKey, String cDevicePublicKey, String extras, String applicationSignature) {
            return this.createActivation(applicationKey, userId, null, null, identity, "00000-00000", activationName, activationNonce, ephemeralPublicKey, cDevicePublicKey, extras, applicationSignature);
        }

        public CreateActivationResponse createActivation(String applicationKey, String userId, Long maxFailureCount, Date timestampActivationExpire, String identity, String activationOtp, String activationName, String activationNonce, String ephemeralPublicKey, String cDevicePublicKey, String extras, String applicationSignature) {
            CreateActivationRequest request = new CreateActivationRequest();
            request.setApplicationKey(applicationKey);
            request.setUserId(userId);
            if (maxFailureCount != null) {
                request.setMaxFailureCount(maxFailureCount);
            }
            if (timestampActivationExpire != null) {
                request.setTimestampActivationExpire(PowerAuthServiceClient.this.calendarWithDate(timestampActivationExpire));
            }
            request.setIdentity(identity);
            request.setActivationOtp(activationOtp);
            request.setActivationName(activationName);
            request.setActivationNonce(activationNonce);
            request.setEphemeralPublicKey(ephemeralPublicKey);
            request.setEncryptedDevicePublicKey(cDevicePublicKey);
            request.setExtras(extras);
            request.setApplicationSignature(applicationSignature);
            return this.createActivation(request);
        }

        public io.getlime.powerauth.soap.v2.VaultUnlockResponse unlockVault(VaultUnlockRequest request) {
            return (io.getlime.powerauth.soap.v2.VaultUnlockResponse)PowerAuthServiceClient.this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
        }

        public io.getlime.powerauth.soap.v2.VaultUnlockResponse unlockVault(String activationId, String applicationKey, String data, String signature, io.getlime.powerauth.soap.v2.SignatureType signatureType, String reason) {
            VaultUnlockRequest request = new VaultUnlockRequest();
            request.setActivationId(activationId);
            request.setApplicationKey(applicationKey);
            request.setData(data);
            request.setSignature(signature);
            request.setSignatureType(signatureType);
            request.setReason(reason);
            return this.unlockVault(request);
        }

        public GetPersonalizedEncryptionKeyResponse generatePersonalizedE2EEncryptionKey(GetPersonalizedEncryptionKeyRequest request) {
            return (GetPersonalizedEncryptionKeyResponse)PowerAuthServiceClient.this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
        }

        public GetPersonalizedEncryptionKeyResponse generatePersonalizedE2EEncryptionKey(String activationId, String sessionIndex) {
            GetPersonalizedEncryptionKeyRequest request = new GetPersonalizedEncryptionKeyRequest();
            request.setActivationId(activationId);
            request.setSessionIndex(sessionIndex);
            return this.generatePersonalizedE2EEncryptionKey(request);
        }

        public GetNonPersonalizedEncryptionKeyResponse generateNonPersonalizedE2EEncryptionKey(GetNonPersonalizedEncryptionKeyRequest request) {
            return (GetNonPersonalizedEncryptionKeyResponse)PowerAuthServiceClient.this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
        }

        public GetNonPersonalizedEncryptionKeyResponse generateNonPersonalizedE2EEncryptionKey(String applicationKey, String ephemeralPublicKeyBase64, String sessionIndex) {
            GetNonPersonalizedEncryptionKeyRequest request = new GetNonPersonalizedEncryptionKeyRequest();
            request.setApplicationKey(applicationKey);
            request.setEphemeralPublicKey(ephemeralPublicKeyBase64);
            request.setSessionIndex(sessionIndex);
            return this.generateNonPersonalizedE2EEncryptionKey(request);
        }

        public CreateTokenResponse createToken(io.getlime.powerauth.soap.v2.CreateTokenRequest request) {
            return (CreateTokenResponse)PowerAuthServiceClient.this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
        }

        public CreateTokenResponse createToken(String activationId, String ephemeralPublicKey, io.getlime.powerauth.soap.v2.SignatureType signatureType) {
            io.getlime.powerauth.soap.v2.CreateTokenRequest request = new io.getlime.powerauth.soap.v2.CreateTokenRequest();
            request.setActivationId(activationId);
            request.setEphemeralPublicKey(ephemeralPublicKey);
            request.setSignatureType(signatureType);
            return this.createToken(request);
        }
    }
}

