/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.soap.spring.client;

import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.model.error.PowerAuthClientException;
import com.wultra.security.powerauth.client.model.error.PowerAuthError;
import com.wultra.security.powerauth.client.model.error.PowerAuthErrorRecovery;
import com.wultra.security.powerauth.client.v2.GetNonPersonalizedEncryptionKeyRequest;
import com.wultra.security.powerauth.client.v2.GetNonPersonalizedEncryptionKeyResponse;
import com.wultra.security.powerauth.client.v2.GetPersonalizedEncryptionKeyRequest;
import com.wultra.security.powerauth.client.v2.GetPersonalizedEncryptionKeyResponse;
import com.wultra.security.powerauth.client.v2.PrepareActivationRequest;
import com.wultra.security.powerauth.client.v2.PrepareActivationResponse;
import com.wultra.security.powerauth.client.v2.SignatureType;
import com.wultra.security.powerauth.client.v2.VaultUnlockRequest;
import com.wultra.security.powerauth.client.v3.ActivationHistoryRequest;
import com.wultra.security.powerauth.client.v3.ActivationHistoryResponse;
import com.wultra.security.powerauth.client.v3.ActivationOtpValidation;
import com.wultra.security.powerauth.client.v3.ActivationStatus;
import com.wultra.security.powerauth.client.v3.AddActivationFlagsRequest;
import com.wultra.security.powerauth.client.v3.AddActivationFlagsResponse;
import com.wultra.security.powerauth.client.v3.AddApplicationRolesRequest;
import com.wultra.security.powerauth.client.v3.AddApplicationRolesResponse;
import com.wultra.security.powerauth.client.v3.BlockActivationRequest;
import com.wultra.security.powerauth.client.v3.BlockActivationResponse;
import com.wultra.security.powerauth.client.v3.CommitActivationRequest;
import com.wultra.security.powerauth.client.v3.CommitActivationResponse;
import com.wultra.security.powerauth.client.v3.CommitUpgradeRequest;
import com.wultra.security.powerauth.client.v3.CommitUpgradeResponse;
import com.wultra.security.powerauth.client.v3.ConfirmRecoveryCodeRequest;
import com.wultra.security.powerauth.client.v3.ConfirmRecoveryCodeResponse;
import com.wultra.security.powerauth.client.v3.CreateActivationRequest;
import com.wultra.security.powerauth.client.v3.CreateActivationResponse;
import com.wultra.security.powerauth.client.v3.CreateApplicationRequest;
import com.wultra.security.powerauth.client.v3.CreateApplicationResponse;
import com.wultra.security.powerauth.client.v3.CreateApplicationVersionRequest;
import com.wultra.security.powerauth.client.v3.CreateApplicationVersionResponse;
import com.wultra.security.powerauth.client.v3.CreateCallbackUrlRequest;
import com.wultra.security.powerauth.client.v3.CreateCallbackUrlResponse;
import com.wultra.security.powerauth.client.v3.CreateIntegrationRequest;
import com.wultra.security.powerauth.client.v3.CreateIntegrationResponse;
import com.wultra.security.powerauth.client.v3.CreateNonPersonalizedOfflineSignaturePayloadRequest;
import com.wultra.security.powerauth.client.v3.CreateNonPersonalizedOfflineSignaturePayloadResponse;
import com.wultra.security.powerauth.client.v3.CreatePersonalizedOfflineSignaturePayloadRequest;
import com.wultra.security.powerauth.client.v3.CreatePersonalizedOfflineSignaturePayloadResponse;
import com.wultra.security.powerauth.client.v3.CreateRecoveryCodeRequest;
import com.wultra.security.powerauth.client.v3.CreateRecoveryCodeResponse;
import com.wultra.security.powerauth.client.v3.CreateTokenRequest;
import com.wultra.security.powerauth.client.v3.CreateTokenResponse;
import com.wultra.security.powerauth.client.v3.GetActivationListForUserRequest;
import com.wultra.security.powerauth.client.v3.GetActivationListForUserResponse;
import com.wultra.security.powerauth.client.v3.GetActivationStatusRequest;
import com.wultra.security.powerauth.client.v3.GetActivationStatusResponse;
import com.wultra.security.powerauth.client.v3.GetApplicationDetailRequest;
import com.wultra.security.powerauth.client.v3.GetApplicationDetailResponse;
import com.wultra.security.powerauth.client.v3.GetApplicationListRequest;
import com.wultra.security.powerauth.client.v3.GetApplicationListResponse;
import com.wultra.security.powerauth.client.v3.GetCallbackUrlListRequest;
import com.wultra.security.powerauth.client.v3.GetCallbackUrlListResponse;
import com.wultra.security.powerauth.client.v3.GetEciesDecryptorRequest;
import com.wultra.security.powerauth.client.v3.GetEciesDecryptorResponse;
import com.wultra.security.powerauth.client.v3.GetErrorCodeListRequest;
import com.wultra.security.powerauth.client.v3.GetErrorCodeListResponse;
import com.wultra.security.powerauth.client.v3.GetIntegrationListRequest;
import com.wultra.security.powerauth.client.v3.GetIntegrationListResponse;
import com.wultra.security.powerauth.client.v3.GetRecoveryConfigRequest;
import com.wultra.security.powerauth.client.v3.GetRecoveryConfigResponse;
import com.wultra.security.powerauth.client.v3.GetSystemStatusRequest;
import com.wultra.security.powerauth.client.v3.GetSystemStatusResponse;
import com.wultra.security.powerauth.client.v3.InitActivationRequest;
import com.wultra.security.powerauth.client.v3.InitActivationResponse;
import com.wultra.security.powerauth.client.v3.ListActivationFlagsRequest;
import com.wultra.security.powerauth.client.v3.ListActivationFlagsResponse;
import com.wultra.security.powerauth.client.v3.ListApplicationRolesRequest;
import com.wultra.security.powerauth.client.v3.ListApplicationRolesResponse;
import com.wultra.security.powerauth.client.v3.LookupActivationsRequest;
import com.wultra.security.powerauth.client.v3.LookupActivationsResponse;
import com.wultra.security.powerauth.client.v3.LookupApplicationByAppKeyRequest;
import com.wultra.security.powerauth.client.v3.LookupApplicationByAppKeyResponse;
import com.wultra.security.powerauth.client.v3.LookupRecoveryCodesRequest;
import com.wultra.security.powerauth.client.v3.LookupRecoveryCodesResponse;
import com.wultra.security.powerauth.client.v3.RecoveryCodeActivationRequest;
import com.wultra.security.powerauth.client.v3.RecoveryCodeActivationResponse;
import com.wultra.security.powerauth.client.v3.RecoveryCodeStatus;
import com.wultra.security.powerauth.client.v3.RecoveryPukStatus;
import com.wultra.security.powerauth.client.v3.RemoveActivationFlagsRequest;
import com.wultra.security.powerauth.client.v3.RemoveActivationFlagsResponse;
import com.wultra.security.powerauth.client.v3.RemoveActivationRequest;
import com.wultra.security.powerauth.client.v3.RemoveActivationResponse;
import com.wultra.security.powerauth.client.v3.RemoveApplicationRolesRequest;
import com.wultra.security.powerauth.client.v3.RemoveApplicationRolesResponse;
import com.wultra.security.powerauth.client.v3.RemoveCallbackUrlRequest;
import com.wultra.security.powerauth.client.v3.RemoveCallbackUrlResponse;
import com.wultra.security.powerauth.client.v3.RemoveIntegrationRequest;
import com.wultra.security.powerauth.client.v3.RemoveIntegrationResponse;
import com.wultra.security.powerauth.client.v3.RemoveTokenRequest;
import com.wultra.security.powerauth.client.v3.RemoveTokenResponse;
import com.wultra.security.powerauth.client.v3.RevokeRecoveryCodesRequest;
import com.wultra.security.powerauth.client.v3.RevokeRecoveryCodesResponse;
import com.wultra.security.powerauth.client.v3.SignatureAuditRequest;
import com.wultra.security.powerauth.client.v3.SignatureAuditResponse;
import com.wultra.security.powerauth.client.v3.StartUpgradeRequest;
import com.wultra.security.powerauth.client.v3.StartUpgradeResponse;
import com.wultra.security.powerauth.client.v3.SupportApplicationVersionRequest;
import com.wultra.security.powerauth.client.v3.SupportApplicationVersionResponse;
import com.wultra.security.powerauth.client.v3.UnblockActivationRequest;
import com.wultra.security.powerauth.client.v3.UnblockActivationResponse;
import com.wultra.security.powerauth.client.v3.UnsupportApplicationVersionRequest;
import com.wultra.security.powerauth.client.v3.UnsupportApplicationVersionResponse;
import com.wultra.security.powerauth.client.v3.UpdateActivationFlagsRequest;
import com.wultra.security.powerauth.client.v3.UpdateActivationFlagsResponse;
import com.wultra.security.powerauth.client.v3.UpdateActivationOtpRequest;
import com.wultra.security.powerauth.client.v3.UpdateActivationOtpResponse;
import com.wultra.security.powerauth.client.v3.UpdateApplicationRolesRequest;
import com.wultra.security.powerauth.client.v3.UpdateApplicationRolesResponse;
import com.wultra.security.powerauth.client.v3.UpdateCallbackUrlRequest;
import com.wultra.security.powerauth.client.v3.UpdateCallbackUrlResponse;
import com.wultra.security.powerauth.client.v3.UpdateRecoveryConfigRequest;
import com.wultra.security.powerauth.client.v3.UpdateRecoveryConfigResponse;
import com.wultra.security.powerauth.client.v3.UpdateStatusForActivationsRequest;
import com.wultra.security.powerauth.client.v3.UpdateStatusForActivationsResponse;
import com.wultra.security.powerauth.client.v3.ValidateTokenRequest;
import com.wultra.security.powerauth.client.v3.ValidateTokenResponse;
import com.wultra.security.powerauth.client.v3.VaultUnlockResponse;
import com.wultra.security.powerauth.client.v3.VerifyECDSASignatureRequest;
import com.wultra.security.powerauth.client.v3.VerifyECDSASignatureResponse;
import com.wultra.security.powerauth.client.v3.VerifyOfflineSignatureRequest;
import com.wultra.security.powerauth.client.v3.VerifyOfflineSignatureResponse;
import com.wultra.security.powerauth.client.v3.VerifySignatureRequest;
import com.wultra.security.powerauth.client.v3.VerifySignatureResponse;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.dom.DOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.client.core.support.WebServiceGatewaySupport;
import org.springframework.ws.soap.SoapFaultDetail;
import org.springframework.ws.soap.SoapFaultDetailElement;
import org.springframework.ws.soap.client.SoapFaultClientException;
import org.w3c.dom.Node;

@Deprecated
public class PowerAuthServiceClient
extends WebServiceGatewaySupport
implements PowerAuthClient {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthServiceClient.class);

    private Object callWsApi(Object request) throws PowerAuthClientException {
        try {
            return this.getWebServiceTemplate().marshalSendAndReceive(request);
        }
        catch (SoapFaultClientException ex) {
            throw this.handleSoapError(ex);
        }
    }

    private PowerAuthClientException handleSoapError(SoapFaultClientException ex) {
        PowerAuthError error;
        SoapFaultDetail faultDetail = ex.getSoapFault().getFaultDetail();
        String errorCode = null;
        String errorMessage = null;
        String localizedErrorMessage = null;
        Integer currentRecoveryPukIndex = null;
        Iterator iter = faultDetail.getDetailEntries();
        while (iter.hasNext()) {
            SoapFaultDetailElement detail = (SoapFaultDetailElement)iter.next();
            Node node = ((DOMSource)detail.getSource()).getNode();
            switch (node.getLocalName()) {
                case "errorCode": {
                    errorCode = node.getTextContent();
                    break;
                }
                case "message": {
                    errorMessage = node.getTextContent();
                    break;
                }
                case "localizedMessage": {
                    localizedErrorMessage = node.getTextContent();
                    break;
                }
                case "currentRecoveryPukIndex": {
                    try {
                        currentRecoveryPukIndex = Integer.parseInt(node.getTextContent());
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if ("ERR0028".equals(errorCode)) {
            PowerAuthErrorRecovery errorRecovery = new PowerAuthErrorRecovery();
            if (currentRecoveryPukIndex != null) {
                errorRecovery.setCurrentRecoveryPukIndex(currentRecoveryPukIndex.intValue());
            }
            error = errorRecovery;
        } else {
            error = new PowerAuthError();
        }
        error.setCode(errorCode);
        error.setMessage(errorMessage);
        error.setLocalizedMessage(localizedErrorMessage);
        return new PowerAuthClientException(errorMessage, (Throwable)ex, error);
    }

    private XMLGregorianCalendar calendarWithDate(Date date) {
        try {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException e) {
            logger.error("Unable to prepare a new calendar instance", (Throwable)e);
            return null;
        }
    }

    public GetSystemStatusResponse getSystemStatus(GetSystemStatusRequest request) throws PowerAuthClientException {
        return (GetSystemStatusResponse)this.callWsApi(request);
    }

    public GetSystemStatusResponse getSystemStatus() throws PowerAuthClientException {
        GetSystemStatusRequest request = new GetSystemStatusRequest();
        return (GetSystemStatusResponse)this.callWsApi(request);
    }

    public GetErrorCodeListResponse getErrorList(GetErrorCodeListRequest request) throws PowerAuthClientException {
        return (GetErrorCodeListResponse)this.callWsApi(request);
    }

    public GetErrorCodeListResponse getErrorList(String language) throws PowerAuthClientException {
        GetErrorCodeListRequest request = new GetErrorCodeListRequest();
        request.setLanguage(language);
        return (GetErrorCodeListResponse)this.callWsApi(request);
    }

    public InitActivationResponse initActivation(InitActivationRequest request) throws PowerAuthClientException {
        return (InitActivationResponse)this.callWsApi(request);
    }

    public InitActivationResponse initActivation(String userId, Long applicationId) throws PowerAuthClientException {
        return this.initActivation(userId, applicationId, null, null, ActivationOtpValidation.NONE, null);
    }

    public InitActivationResponse initActivation(String userId, Long applicationId, ActivationOtpValidation otpValidation, String otp) throws PowerAuthClientException {
        return this.initActivation(userId, applicationId, null, null, otpValidation, otp);
    }

    public InitActivationResponse initActivation(String userId, Long applicationId, Long maxFailureCount, Date timestampActivationExpire) throws PowerAuthClientException {
        return this.initActivation(userId, applicationId, maxFailureCount, timestampActivationExpire, ActivationOtpValidation.NONE, null);
    }

    public InitActivationResponse initActivation(String userId, Long applicationId, Long maxFailureCount, Date timestampActivationExpire, ActivationOtpValidation otpValidation, String otp) throws PowerAuthClientException {
        InitActivationRequest request = new InitActivationRequest();
        request.setUserId(userId);
        request.setApplicationId(applicationId.longValue());
        request.setActivationOtpValidation(otpValidation);
        request.setActivationOtp(otp);
        if (maxFailureCount != null) {
            request.setMaxFailureCount(maxFailureCount);
        }
        if (timestampActivationExpire != null) {
            request.setTimestampActivationExpire(this.calendarWithDate(timestampActivationExpire));
        }
        return this.initActivation(request);
    }

    public com.wultra.security.powerauth.client.v3.PrepareActivationResponse prepareActivation(com.wultra.security.powerauth.client.v3.PrepareActivationRequest request) throws PowerAuthClientException {
        return (com.wultra.security.powerauth.client.v3.PrepareActivationResponse)this.callWsApi(request);
    }

    public com.wultra.security.powerauth.client.v3.PrepareActivationResponse prepareActivation(String activationCode, String applicationKey, String ephemeralPublicKey, String encryptedData, String mac, String nonce) throws PowerAuthClientException {
        com.wultra.security.powerauth.client.v3.PrepareActivationRequest request = new com.wultra.security.powerauth.client.v3.PrepareActivationRequest();
        request.setActivationCode(activationCode);
        request.setApplicationKey(applicationKey);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        return this.prepareActivation(request);
    }

    public CreateActivationResponse createActivation(CreateActivationRequest request) throws PowerAuthClientException {
        return (CreateActivationResponse)this.callWsApi(request);
    }

    public CreateActivationResponse createActivation(String userId, Date timestampActivationExpire, Long maxFailureCount, String applicationKey, String ephemeralPublicKey, String encryptedData, String mac, String nonce) throws PowerAuthClientException {
        CreateActivationRequest request = new CreateActivationRequest();
        request.setUserId(userId);
        if (timestampActivationExpire != null) {
            request.setTimestampActivationExpire(this.calendarWithDate(timestampActivationExpire));
        }
        if (maxFailureCount != null) {
            request.setMaxFailureCount(maxFailureCount);
        }
        request.setApplicationKey(applicationKey);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        return this.createActivation(request);
    }

    public CommitActivationResponse commitActivation(CommitActivationRequest request) throws PowerAuthClientException {
        return (CommitActivationResponse)this.callWsApi(request);
    }

    public CommitActivationResponse commitActivation(String activationId, String externalUserId) throws PowerAuthClientException {
        CommitActivationRequest request = new CommitActivationRequest();
        request.setActivationId(activationId);
        request.setExternalUserId(externalUserId);
        return this.commitActivation(request);
    }

    public CommitActivationResponse commitActivation(String activationId, String externalUserId, String activationOtp) throws PowerAuthClientException {
        CommitActivationRequest request = new CommitActivationRequest();
        request.setActivationId(activationId);
        request.setExternalUserId(externalUserId);
        request.setActivationOtp(activationOtp);
        return this.commitActivation(request);
    }

    public UpdateActivationOtpResponse updateActivationOtp(String activationId, String externalUserId, String activationOtp) throws PowerAuthClientException {
        UpdateActivationOtpRequest request = new UpdateActivationOtpRequest();
        request.setActivationId(activationId);
        request.setExternalUserId(externalUserId);
        request.setActivationOtp(activationOtp);
        return this.updateActivationOtp(request);
    }

    public UpdateActivationOtpResponse updateActivationOtp(UpdateActivationOtpRequest request) throws PowerAuthClientException {
        return (UpdateActivationOtpResponse)this.callWsApi(request);
    }

    public GetActivationStatusResponse getActivationStatus(GetActivationStatusRequest request) throws PowerAuthClientException {
        return (GetActivationStatusResponse)this.callWsApi(request);
    }

    public GetActivationStatusResponse getActivationStatus(String activationId) throws PowerAuthClientException {
        GetActivationStatusResponse response = this.getActivationStatusWithEncryptedStatusBlob(activationId, null);
        response.setEncryptedStatusBlob(null);
        return response;
    }

    public GetActivationStatusResponse getActivationStatusWithEncryptedStatusBlob(String activationId, String challenge) throws PowerAuthClientException {
        GetActivationStatusRequest request = new GetActivationStatusRequest();
        request.setActivationId(activationId);
        request.setChallenge(challenge);
        return this.getActivationStatus(request);
    }

    public GetActivationListForUserResponse getActivationListForUser(GetActivationListForUserRequest request) throws PowerAuthClientException {
        return (GetActivationListForUserResponse)this.callWsApi(request);
    }

    public List<GetActivationListForUserResponse.Activations> getActivationListForUser(String userId) throws PowerAuthClientException {
        GetActivationListForUserRequest request = new GetActivationListForUserRequest();
        request.setUserId(userId);
        return this.getActivationListForUser(request).getActivations();
    }

    public LookupActivationsResponse lookupActivations(LookupActivationsRequest request) throws PowerAuthClientException {
        return (LookupActivationsResponse)this.callWsApi(request);
    }

    public List<LookupActivationsResponse.Activations> lookupActivations(List<String> userIds, List<Long> applicationIds, Date timestampLastUsedBefore, Date timestampLastUsedAfter, ActivationStatus activationStatus, List<String> activationFlags) throws PowerAuthClientException {
        LookupActivationsRequest request = new LookupActivationsRequest();
        request.getUserIds().addAll(userIds);
        if (applicationIds != null) {
            request.getApplicationIds().addAll(applicationIds);
        }
        if (timestampLastUsedBefore != null) {
            request.setTimestampLastUsedBefore(this.calendarWithDate(timestampLastUsedBefore));
        }
        if (timestampLastUsedAfter != null) {
            request.setTimestampLastUsedAfter(this.calendarWithDate(timestampLastUsedAfter));
        }
        if (activationStatus != null) {
            request.setActivationStatus(activationStatus);
        }
        if (activationFlags != null) {
            request.getActivationFlags().addAll(activationFlags);
        }
        return this.lookupActivations(request).getActivations();
    }

    public UpdateStatusForActivationsResponse updateStatusForActivations(UpdateStatusForActivationsRequest request) throws PowerAuthClientException {
        return (UpdateStatusForActivationsResponse)this.callWsApi(request);
    }

    public UpdateStatusForActivationsResponse updateStatusForActivations(List<String> activationIds, ActivationStatus activationStatus) throws PowerAuthClientException {
        UpdateStatusForActivationsRequest request = new UpdateStatusForActivationsRequest();
        request.getActivationIds().addAll(activationIds);
        if (activationStatus != null) {
            request.setActivationStatus(activationStatus);
        }
        return this.updateStatusForActivations(request);
    }

    public RemoveActivationResponse removeActivation(RemoveActivationRequest request) throws PowerAuthClientException {
        return (RemoveActivationResponse)this.callWsApi(request);
    }

    public RemoveActivationResponse removeActivation(String activationId, String externalUserId) throws PowerAuthClientException {
        return this.removeActivation(activationId, externalUserId, false);
    }

    public RemoveActivationResponse removeActivation(String activationId, String externalUserId, Boolean revokeRecoveryCodes) throws PowerAuthClientException {
        RemoveActivationRequest request = new RemoveActivationRequest();
        request.setActivationId(activationId);
        request.setExternalUserId(externalUserId);
        request.setRevokeRecoveryCodes(revokeRecoveryCodes);
        return this.removeActivation(request);
    }

    public BlockActivationResponse blockActivation(BlockActivationRequest request) throws PowerAuthClientException {
        return (BlockActivationResponse)this.callWsApi(request);
    }

    public BlockActivationResponse blockActivation(String activationId, String reason, String externalUserId) throws PowerAuthClientException {
        BlockActivationRequest request = new BlockActivationRequest();
        request.setActivationId(activationId);
        request.setReason(reason);
        request.setExternalUserId(externalUserId);
        return this.blockActivation(request);
    }

    public UnblockActivationResponse unblockActivation(UnblockActivationRequest request) throws PowerAuthClientException {
        return (UnblockActivationResponse)this.callWsApi(request);
    }

    public UnblockActivationResponse unblockActivation(String activationId, String externalUserId) throws PowerAuthClientException {
        UnblockActivationRequest request = new UnblockActivationRequest();
        request.setActivationId(activationId);
        request.setExternalUserId(externalUserId);
        return this.unblockActivation(request);
    }

    public VaultUnlockResponse unlockVault(com.wultra.security.powerauth.client.v3.VaultUnlockRequest request) throws PowerAuthClientException {
        return (VaultUnlockResponse)this.callWsApi(request);
    }

    public VaultUnlockResponse unlockVault(String activationId, String applicationKey, String signature, com.wultra.security.powerauth.client.v3.SignatureType signatureType, String signatureVersion, String signedData, String ephemeralPublicKey, String encryptedData, String mac, String nonce) throws PowerAuthClientException {
        com.wultra.security.powerauth.client.v3.VaultUnlockRequest request = new com.wultra.security.powerauth.client.v3.VaultUnlockRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setSignedData(signedData);
        request.setSignature(signature);
        request.setSignatureType(signatureType);
        request.setSignatureVersion(signatureVersion);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        return this.unlockVault(request);
    }

    public CreatePersonalizedOfflineSignaturePayloadResponse createPersonalizedOfflineSignaturePayload(String activationId, String data) throws PowerAuthClientException {
        CreatePersonalizedOfflineSignaturePayloadRequest request = new CreatePersonalizedOfflineSignaturePayloadRequest();
        request.setActivationId(activationId);
        request.setData(data);
        return this.createPersonalizedOfflineSignaturePayload(request);
    }

    public CreatePersonalizedOfflineSignaturePayloadResponse createPersonalizedOfflineSignaturePayload(CreatePersonalizedOfflineSignaturePayloadRequest request) throws PowerAuthClientException {
        return (CreatePersonalizedOfflineSignaturePayloadResponse)this.callWsApi(request);
    }

    public CreateNonPersonalizedOfflineSignaturePayloadResponse createNonPersonalizedOfflineSignaturePayload(long applicationId, String data) throws PowerAuthClientException {
        CreateNonPersonalizedOfflineSignaturePayloadRequest request = new CreateNonPersonalizedOfflineSignaturePayloadRequest();
        request.setApplicationId(applicationId);
        request.setData(data);
        return this.createNonPersonalizedOfflineSignaturePayload(request);
    }

    public CreateNonPersonalizedOfflineSignaturePayloadResponse createNonPersonalizedOfflineSignaturePayload(CreateNonPersonalizedOfflineSignaturePayloadRequest request) throws PowerAuthClientException {
        return (CreateNonPersonalizedOfflineSignaturePayloadResponse)this.callWsApi(request);
    }

    public VerifyOfflineSignatureResponse verifyOfflineSignature(String activationId, String data, String signature, boolean allowBiometry) throws PowerAuthClientException {
        VerifyOfflineSignatureRequest request = new VerifyOfflineSignatureRequest();
        request.setActivationId(activationId);
        request.setData(data);
        request.setSignature(signature);
        request.setAllowBiometry(allowBiometry);
        return this.verifyOfflineSignature(request);
    }

    public VerifyOfflineSignatureResponse verifyOfflineSignature(VerifyOfflineSignatureRequest request) throws PowerAuthClientException {
        return (VerifyOfflineSignatureResponse)this.callWsApi(request);
    }

    public VerifySignatureResponse verifySignature(VerifySignatureRequest request) throws PowerAuthClientException {
        return (VerifySignatureResponse)this.callWsApi(request);
    }

    public VerifySignatureResponse verifySignature(String activationId, String applicationKey, String data, String signature, com.wultra.security.powerauth.client.v3.SignatureType signatureType, String signatureVersion, Long forcedSignatureVersion) throws PowerAuthClientException {
        VerifySignatureRequest request = new VerifySignatureRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setData(data);
        request.setSignature(signature);
        request.setSignatureType(signatureType);
        request.setSignatureVersion(signatureVersion);
        request.setForcedSignatureVersion(forcedSignatureVersion);
        return this.verifySignature(request);
    }

    public VerifyECDSASignatureResponse verifyECDSASignature(VerifyECDSASignatureRequest request) throws PowerAuthClientException {
        return (VerifyECDSASignatureResponse)this.callWsApi(request);
    }

    public VerifyECDSASignatureResponse verifyECDSASignature(String activationId, String data, String signature) throws PowerAuthClientException {
        VerifyECDSASignatureRequest request = new VerifyECDSASignatureRequest();
        request.setActivationId(activationId);
        request.setData(data);
        request.setSignature(signature);
        return this.verifyECDSASignature(request);
    }

    public SignatureAuditResponse getSignatureAuditLog(SignatureAuditRequest request) throws PowerAuthClientException {
        return (SignatureAuditResponse)this.callWsApi(request);
    }

    public List<SignatureAuditResponse.Items> getSignatureAuditLog(String userId, Date startingDate, Date endingDate) throws PowerAuthClientException {
        SignatureAuditRequest request = new SignatureAuditRequest();
        request.setUserId(userId);
        request.setTimestampFrom(this.calendarWithDate(startingDate));
        request.setTimestampTo(this.calendarWithDate(endingDate));
        return this.getSignatureAuditLog(request).getItems();
    }

    public List<SignatureAuditResponse.Items> getSignatureAuditLog(String userId, Long applicationId, Date startingDate, Date endingDate) throws PowerAuthClientException {
        SignatureAuditRequest request = new SignatureAuditRequest();
        request.setUserId(userId);
        request.setApplicationId(applicationId);
        request.setTimestampFrom(this.calendarWithDate(startingDate));
        request.setTimestampTo(this.calendarWithDate(endingDate));
        return this.getSignatureAuditLog(request).getItems();
    }

    public ActivationHistoryResponse getActivationHistory(ActivationHistoryRequest request) throws PowerAuthClientException {
        return (ActivationHistoryResponse)this.callWsApi(request);
    }

    public List<ActivationHistoryResponse.Items> getActivationHistory(String activationId, Date startingDate, Date endingDate) throws PowerAuthClientException {
        ActivationHistoryRequest request = new ActivationHistoryRequest();
        request.setActivationId(activationId);
        request.setTimestampFrom(this.calendarWithDate(startingDate));
        request.setTimestampTo(this.calendarWithDate(endingDate));
        return this.getActivationHistory(request).getItems();
    }

    public GetApplicationListResponse getApplicationList(GetApplicationListRequest request) throws PowerAuthClientException {
        return (GetApplicationListResponse)this.callWsApi(request);
    }

    public List<GetApplicationListResponse.Applications> getApplicationList() throws PowerAuthClientException {
        return this.getApplicationList(new GetApplicationListRequest()).getApplications();
    }

    public GetApplicationDetailResponse getApplicationDetail(GetApplicationDetailRequest request) throws PowerAuthClientException {
        return (GetApplicationDetailResponse)this.callWsApi(request);
    }

    public GetApplicationDetailResponse getApplicationDetail(Long applicationId) throws PowerAuthClientException {
        GetApplicationDetailRequest request = new GetApplicationDetailRequest();
        request.setApplicationId(applicationId);
        return this.getApplicationDetail(request);
    }

    public GetApplicationDetailResponse getApplicationDetail(String applicationName) throws PowerAuthClientException {
        GetApplicationDetailRequest request = new GetApplicationDetailRequest();
        request.setApplicationName(applicationName);
        return this.getApplicationDetail(request);
    }

    public LookupApplicationByAppKeyResponse lookupApplicationByAppKey(LookupApplicationByAppKeyRequest request) throws PowerAuthClientException {
        return (LookupApplicationByAppKeyResponse)this.callWsApi(request);
    }

    public LookupApplicationByAppKeyResponse lookupApplicationByAppKey(String applicationKey) throws PowerAuthClientException {
        LookupApplicationByAppKeyRequest request = new LookupApplicationByAppKeyRequest();
        request.setApplicationKey(applicationKey);
        return this.lookupApplicationByAppKey(request);
    }

    public CreateApplicationResponse createApplication(CreateApplicationRequest request) throws PowerAuthClientException {
        return (CreateApplicationResponse)this.callWsApi(request);
    }

    public CreateApplicationResponse createApplication(String name) throws PowerAuthClientException {
        CreateApplicationRequest request = new CreateApplicationRequest();
        request.setApplicationName(name);
        return this.createApplication(request);
    }

    public CreateApplicationVersionResponse createApplicationVersion(CreateApplicationVersionRequest request) throws PowerAuthClientException {
        return (CreateApplicationVersionResponse)this.callWsApi(request);
    }

    public CreateApplicationVersionResponse createApplicationVersion(Long applicationId, String versionName) throws PowerAuthClientException {
        CreateApplicationVersionRequest request = new CreateApplicationVersionRequest();
        request.setApplicationId(applicationId.longValue());
        request.setApplicationVersionName(versionName);
        return this.createApplicationVersion(request);
    }

    public UnsupportApplicationVersionResponse unsupportApplicationVersion(UnsupportApplicationVersionRequest request) throws PowerAuthClientException {
        return (UnsupportApplicationVersionResponse)this.callWsApi(request);
    }

    public UnsupportApplicationVersionResponse unsupportApplicationVersion(Long versionId) throws PowerAuthClientException {
        UnsupportApplicationVersionRequest request = new UnsupportApplicationVersionRequest();
        request.setApplicationVersionId(versionId.longValue());
        return this.unsupportApplicationVersion(request);
    }

    public SupportApplicationVersionResponse supportApplicationVersion(SupportApplicationVersionRequest request) throws PowerAuthClientException {
        return (SupportApplicationVersionResponse)this.callWsApi(request);
    }

    public SupportApplicationVersionResponse supportApplicationVersion(Long versionId) throws PowerAuthClientException {
        SupportApplicationVersionRequest request = new SupportApplicationVersionRequest();
        request.setApplicationVersionId(versionId.longValue());
        return this.supportApplicationVersion(request);
    }

    public CreateIntegrationResponse createIntegration(CreateIntegrationRequest request) throws PowerAuthClientException {
        return (CreateIntegrationResponse)this.callWsApi(request);
    }

    public CreateIntegrationResponse createIntegration(String name) throws PowerAuthClientException {
        CreateIntegrationRequest request = new CreateIntegrationRequest();
        request.setName(name);
        return this.createIntegration(request);
    }

    public GetIntegrationListResponse getIntegrationList(GetIntegrationListRequest request) throws PowerAuthClientException {
        return (GetIntegrationListResponse)this.callWsApi(request);
    }

    public List<GetIntegrationListResponse.Items> getIntegrationList() throws PowerAuthClientException {
        return this.getIntegrationList(new GetIntegrationListRequest()).getItems();
    }

    public RemoveIntegrationResponse removeIntegration(RemoveIntegrationRequest request) throws PowerAuthClientException {
        return (RemoveIntegrationResponse)this.callWsApi(request);
    }

    public RemoveIntegrationResponse removeIntegration(String id) throws PowerAuthClientException {
        RemoveIntegrationRequest request = new RemoveIntegrationRequest();
        request.setId(id);
        return this.removeIntegration(request);
    }

    public CreateCallbackUrlResponse createCallbackUrl(CreateCallbackUrlRequest request) throws PowerAuthClientException {
        return (CreateCallbackUrlResponse)this.callWsApi(request);
    }

    public CreateCallbackUrlResponse createCallbackUrl(Long applicationId, String name, String callbackUrl, List<String> attributes) throws PowerAuthClientException {
        CreateCallbackUrlRequest request = new CreateCallbackUrlRequest();
        request.setApplicationId(applicationId.longValue());
        request.setName(name);
        request.setCallbackUrl(callbackUrl);
        if (attributes != null) {
            request.getAttributes().addAll(attributes);
        }
        return this.createCallbackUrl(request);
    }

    public UpdateCallbackUrlResponse updateCallbackUrl(UpdateCallbackUrlRequest request) throws PowerAuthClientException {
        return (UpdateCallbackUrlResponse)this.callWsApi(request);
    }

    public UpdateCallbackUrlResponse updateCallbackUrl(String id, long applicationId, String name, String callbackUrl, List<String> attributes) throws PowerAuthClientException {
        UpdateCallbackUrlRequest request = new UpdateCallbackUrlRequest();
        request.setId(id);
        request.setApplicationId(applicationId);
        request.setName(name);
        request.setCallbackUrl(callbackUrl);
        if (attributes != null) {
            request.getAttributes().addAll(attributes);
        }
        return this.updateCallbackUrl(request);
    }

    public GetCallbackUrlListResponse getCallbackUrlList(GetCallbackUrlListRequest request) throws PowerAuthClientException {
        return (GetCallbackUrlListResponse)this.callWsApi(request);
    }

    public List<GetCallbackUrlListResponse.CallbackUrlList> getCallbackUrlList(Long applicationId) throws PowerAuthClientException {
        GetCallbackUrlListRequest request = new GetCallbackUrlListRequest();
        request.setApplicationId(applicationId.longValue());
        return this.getCallbackUrlList(request).getCallbackUrlList();
    }

    public RemoveCallbackUrlResponse removeCallbackUrl(RemoveCallbackUrlRequest request) throws PowerAuthClientException {
        return (RemoveCallbackUrlResponse)this.callWsApi(request);
    }

    public RemoveCallbackUrlResponse removeCallbackUrl(String callbackUrlId) throws PowerAuthClientException {
        RemoveCallbackUrlRequest request = new RemoveCallbackUrlRequest();
        request.setId(callbackUrlId);
        return this.removeCallbackUrl(request);
    }

    public CreateTokenResponse createToken(CreateTokenRequest request) throws PowerAuthClientException {
        return (CreateTokenResponse)this.callWsApi(request);
    }

    public CreateTokenResponse createToken(String activationId, String applicationKey, String ephemeralPublicKey, String encryptedData, String mac, String nonce, com.wultra.security.powerauth.client.v3.SignatureType signatureType) throws PowerAuthClientException {
        CreateTokenRequest request = new CreateTokenRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setNonce(nonce);
        request.setSignatureType(signatureType);
        return this.createToken(request);
    }

    public ValidateTokenResponse validateToken(ValidateTokenRequest request) throws PowerAuthClientException {
        return (ValidateTokenResponse)this.callWsApi(request);
    }

    public ValidateTokenResponse validateToken(String tokenId, String nonce, long timestamp, String tokenDigest) throws PowerAuthClientException {
        ValidateTokenRequest request = new ValidateTokenRequest();
        request.setTokenId(tokenId);
        request.setNonce(nonce);
        request.setTimestamp(timestamp);
        request.setTokenDigest(tokenDigest);
        return this.validateToken(request);
    }

    public RemoveTokenResponse removeToken(RemoveTokenRequest request) throws PowerAuthClientException {
        return (RemoveTokenResponse)this.callWsApi(request);
    }

    public RemoveTokenResponse removeToken(String tokenId, String activationId) throws PowerAuthClientException {
        RemoveTokenRequest request = new RemoveTokenRequest();
        request.setTokenId(tokenId);
        request.setActivationId(activationId);
        return this.removeToken(request);
    }

    public GetEciesDecryptorResponse getEciesDecryptor(GetEciesDecryptorRequest request) throws PowerAuthClientException {
        return (GetEciesDecryptorResponse)this.callWsApi(request);
    }

    public GetEciesDecryptorResponse getEciesDecryptor(String activationId, String applicationKey, String ephemeralPublicKey) throws PowerAuthClientException {
        GetEciesDecryptorRequest request = new GetEciesDecryptorRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        return this.getEciesDecryptor(request);
    }

    public StartUpgradeResponse startUpgrade(StartUpgradeRequest request) throws PowerAuthClientException {
        return (StartUpgradeResponse)this.callWsApi(request);
    }

    public StartUpgradeResponse startUpgrade(String activationId, String applicationKey, String ephemeralPublicKey, String encryptedData, String mac, String nonce) throws PowerAuthClientException {
        StartUpgradeRequest request = new StartUpgradeRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        return this.startUpgrade(request);
    }

    public CommitUpgradeResponse commitUpgrade(CommitUpgradeRequest request) throws PowerAuthClientException {
        return (CommitUpgradeResponse)this.callWsApi(request);
    }

    public CommitUpgradeResponse commitUpgrade(String activationId, String applicationKey) throws PowerAuthClientException {
        CommitUpgradeRequest request = new CommitUpgradeRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        return this.commitUpgrade(request);
    }

    public CreateRecoveryCodeResponse createRecoveryCode(CreateRecoveryCodeRequest request) throws PowerAuthClientException {
        return (CreateRecoveryCodeResponse)this.callWsApi(request);
    }

    public CreateRecoveryCodeResponse createRecoveryCode(Long applicationId, String userId, Long pukCount) throws PowerAuthClientException {
        CreateRecoveryCodeRequest request = new CreateRecoveryCodeRequest();
        request.setApplicationId(applicationId.longValue());
        request.setUserId(userId);
        request.setPukCount(pukCount.longValue());
        return this.createRecoveryCode(request);
    }

    public ConfirmRecoveryCodeResponse confirmRecoveryCode(ConfirmRecoveryCodeRequest request) throws PowerAuthClientException {
        return (ConfirmRecoveryCodeResponse)this.callWsApi(request);
    }

    public ConfirmRecoveryCodeResponse confirmRecoveryCode(String activationId, String applicationKey, String ephemeralPublicKey, String encryptedData, String mac, String nonce) throws PowerAuthClientException {
        ConfirmRecoveryCodeRequest request = new ConfirmRecoveryCodeRequest();
        request.setActivationId(activationId);
        request.setApplicationKey(applicationKey);
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        return this.confirmRecoveryCode(request);
    }

    public LookupRecoveryCodesResponse lookupRecoveryCodes(LookupRecoveryCodesRequest request) throws PowerAuthClientException {
        return (LookupRecoveryCodesResponse)this.callWsApi(request);
    }

    public LookupRecoveryCodesResponse lookupRecoveryCodes(String userId, String activationId, Long applicationId, RecoveryCodeStatus recoveryCodeStatus, RecoveryPukStatus recoveryPukStatus) throws PowerAuthClientException {
        LookupRecoveryCodesRequest request = new LookupRecoveryCodesRequest();
        request.setUserId(userId);
        request.setActivationId(activationId);
        request.setApplicationId(applicationId);
        request.setRecoveryCodeStatus(recoveryCodeStatus);
        request.setRecoveryPukStatus(recoveryPukStatus);
        return this.lookupRecoveryCodes(request);
    }

    public RevokeRecoveryCodesResponse revokeRecoveryCodes(RevokeRecoveryCodesRequest request) throws PowerAuthClientException {
        return (RevokeRecoveryCodesResponse)this.callWsApi(request);
    }

    public RevokeRecoveryCodesResponse revokeRecoveryCodes(List<Long> recoveryCodeIds) throws PowerAuthClientException {
        RevokeRecoveryCodesRequest request = new RevokeRecoveryCodesRequest();
        request.getRecoveryCodeIds().addAll(recoveryCodeIds);
        return this.revokeRecoveryCodes(request);
    }

    public RecoveryCodeActivationResponse createActivationUsingRecoveryCode(RecoveryCodeActivationRequest request) throws PowerAuthClientException {
        return (RecoveryCodeActivationResponse)this.callWsApi(request);
    }

    public RecoveryCodeActivationResponse createActivationUsingRecoveryCode(String recoveryCode, String puk, String applicationKey, Long maxFailureCount, String ephemeralPublicKey, String encryptedData, String mac, String nonce) throws PowerAuthClientException {
        RecoveryCodeActivationRequest request = new RecoveryCodeActivationRequest();
        request.setRecoveryCode(recoveryCode);
        request.setPuk(puk);
        request.setApplicationKey(applicationKey);
        if (maxFailureCount != null) {
            request.setMaxFailureCount(maxFailureCount);
        }
        request.setEphemeralPublicKey(ephemeralPublicKey);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        return this.createActivationUsingRecoveryCode(request);
    }

    public GetRecoveryConfigResponse getRecoveryConfig(GetRecoveryConfigRequest request) throws PowerAuthClientException {
        return (GetRecoveryConfigResponse)this.callWsApi(request);
    }

    public GetRecoveryConfigResponse getRecoveryConfig(Long applicationId) throws PowerAuthClientException {
        GetRecoveryConfigRequest request = new GetRecoveryConfigRequest();
        request.setApplicationId(applicationId.longValue());
        return this.getRecoveryConfig(request);
    }

    public UpdateRecoveryConfigResponse updateRecoveryConfig(UpdateRecoveryConfigRequest request) throws PowerAuthClientException {
        return (UpdateRecoveryConfigResponse)this.callWsApi(request);
    }

    public UpdateRecoveryConfigResponse updateRecoveryConfig(Long applicationId, Boolean activationRecoveryEnabled, Boolean recoveryPostcardEnabled, Boolean allowMultipleRecoveryCodes, String remoteRecoveryPublicKeyBase64) throws PowerAuthClientException {
        UpdateRecoveryConfigRequest request = new UpdateRecoveryConfigRequest();
        request.setApplicationId(applicationId.longValue());
        request.setActivationRecoveryEnabled(activationRecoveryEnabled.booleanValue());
        request.setRecoveryPostcardEnabled(recoveryPostcardEnabled.booleanValue());
        request.setAllowMultipleRecoveryCodes(allowMultipleRecoveryCodes);
        request.setRemotePostcardPublicKey(remoteRecoveryPublicKeyBase64);
        return this.updateRecoveryConfig(request);
    }

    public ListActivationFlagsResponse listActivationFlags(ListActivationFlagsRequest request) throws PowerAuthClientException {
        return (ListActivationFlagsResponse)this.callWsApi(request);
    }

    public ListActivationFlagsResponse listActivationFlags(String activationId) throws PowerAuthClientException {
        ListActivationFlagsRequest request = new ListActivationFlagsRequest();
        request.setActivationId(activationId);
        return this.listActivationFlags(request);
    }

    public AddActivationFlagsResponse addActivationFlags(AddActivationFlagsRequest request) {
        return (AddActivationFlagsResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public AddActivationFlagsResponse addActivationFlags(String activationId, List<String> activationFlags) {
        AddActivationFlagsRequest request = new AddActivationFlagsRequest();
        request.setActivationId(activationId);
        request.getActivationFlags().addAll(activationFlags);
        return this.addActivationFlags(request);
    }

    public UpdateActivationFlagsResponse updateActivationFlags(UpdateActivationFlagsRequest request) throws PowerAuthClientException {
        return (UpdateActivationFlagsResponse)this.callWsApi(request);
    }

    public UpdateActivationFlagsResponse updateActivationFlags(String activationId, List<String> activationFlags) throws PowerAuthClientException {
        UpdateActivationFlagsRequest request = new UpdateActivationFlagsRequest();
        request.setActivationId(activationId);
        request.getActivationFlags().addAll(activationFlags);
        return this.updateActivationFlags(request);
    }

    public RemoveActivationFlagsResponse removeActivationFlags(RemoveActivationFlagsRequest request) throws PowerAuthClientException {
        return (RemoveActivationFlagsResponse)this.callWsApi(request);
    }

    public RemoveActivationFlagsResponse removeActivationFlags(String activationId, List<String> activationFlags) throws PowerAuthClientException {
        RemoveActivationFlagsRequest request = new RemoveActivationFlagsRequest();
        request.setActivationId(activationId);
        request.getActivationFlags().addAll(activationFlags);
        return this.removeActivationFlags(request);
    }

    public ListApplicationRolesResponse listApplicationRoles(ListApplicationRolesRequest request) {
        return (ListApplicationRolesResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public ListApplicationRolesResponse listApplicationRoles(Long applicationId) {
        ListApplicationRolesRequest request = new ListApplicationRolesRequest();
        request.setApplicationId(applicationId.longValue());
        return this.listApplicationRoles(request);
    }

    public AddApplicationRolesResponse addApplicationRoles(AddApplicationRolesRequest request) {
        return (AddApplicationRolesResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public AddApplicationRolesResponse addApplicationRoles(Long applicationId, List<String> applicationRoles) {
        AddApplicationRolesRequest request = new AddApplicationRolesRequest();
        request.setApplicationId(applicationId.longValue());
        request.getApplicationRoles().addAll(applicationRoles);
        return this.addApplicationRoles(request);
    }

    public UpdateApplicationRolesResponse updateApplicationRoles(UpdateApplicationRolesRequest request) {
        return (UpdateApplicationRolesResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public UpdateApplicationRolesResponse updateApplicationRoles(Long applicationId, List<String> applicationRoles) {
        UpdateApplicationRolesRequest request = new UpdateApplicationRolesRequest();
        request.setApplicationId(applicationId.longValue());
        request.getApplicationRoles().addAll(applicationRoles);
        return this.updateApplicationRoles(request);
    }

    public RemoveApplicationRolesResponse removeApplicationRoles(RemoveApplicationRolesRequest request) {
        return (RemoveApplicationRolesResponse)this.getWebServiceTemplate().marshalSendAndReceive((Object)request);
    }

    public RemoveApplicationRolesResponse removeApplicationRoles(Long applicationId, List<String> applicationRoles) {
        RemoveApplicationRolesRequest request = new RemoveApplicationRolesRequest();
        request.setApplicationId(applicationId.longValue());
        request.getApplicationRoles().addAll(applicationRoles);
        return this.removeApplicationRoles(request);
    }

    public PowerAuthServiceClientV2 v2() {
        return new PowerAuthServiceClientV2();
    }

    public class PowerAuthServiceClientV2
    implements PowerAuthClient.PowerAuthClientV2 {
        public PrepareActivationResponse prepareActivation(PrepareActivationRequest request) throws PowerAuthClientException {
            return (PrepareActivationResponse)PowerAuthServiceClient.this.callWsApi(request);
        }

        public PrepareActivationResponse prepareActivation(String activationIdShort, String activationName, String activationNonce, String ephemeralPublicKey, String cDevicePublicKey, String extras, String applicationKey, String applicationSignature) throws PowerAuthClientException {
            PrepareActivationRequest request = new PrepareActivationRequest();
            request.setActivationIdShort(activationIdShort);
            request.setActivationName(activationName);
            request.setActivationNonce(activationNonce);
            request.setEphemeralPublicKey(ephemeralPublicKey);
            request.setEncryptedDevicePublicKey(cDevicePublicKey);
            request.setExtras(extras);
            request.setApplicationKey(applicationKey);
            request.setApplicationSignature(applicationSignature);
            return this.prepareActivation(request);
        }

        public com.wultra.security.powerauth.client.v2.CreateActivationResponse createActivation(com.wultra.security.powerauth.client.v2.CreateActivationRequest request) throws PowerAuthClientException {
            return (com.wultra.security.powerauth.client.v2.CreateActivationResponse)PowerAuthServiceClient.this.callWsApi(request);
        }

        public com.wultra.security.powerauth.client.v2.CreateActivationResponse createActivation(String applicationKey, String userId, String identity, String activationName, String activationNonce, String ephemeralPublicKey, String cDevicePublicKey, String extras, String applicationSignature) throws PowerAuthClientException {
            return this.createActivation(applicationKey, userId, null, null, identity, "00000-00000", activationName, activationNonce, ephemeralPublicKey, cDevicePublicKey, extras, applicationSignature);
        }

        public com.wultra.security.powerauth.client.v2.CreateActivationResponse createActivation(String applicationKey, String userId, Long maxFailureCount, Date timestampActivationExpire, String identity, String activationOtp, String activationName, String activationNonce, String ephemeralPublicKey, String cDevicePublicKey, String extras, String applicationSignature) throws PowerAuthClientException {
            com.wultra.security.powerauth.client.v2.CreateActivationRequest request = new com.wultra.security.powerauth.client.v2.CreateActivationRequest();
            request.setApplicationKey(applicationKey);
            request.setUserId(userId);
            if (maxFailureCount != null) {
                request.setMaxFailureCount(maxFailureCount);
            }
            if (timestampActivationExpire != null) {
                request.setTimestampActivationExpire(PowerAuthServiceClient.this.calendarWithDate(timestampActivationExpire));
            }
            request.setIdentity(identity);
            request.setActivationOtp(activationOtp);
            request.setActivationName(activationName);
            request.setActivationNonce(activationNonce);
            request.setEphemeralPublicKey(ephemeralPublicKey);
            request.setEncryptedDevicePublicKey(cDevicePublicKey);
            request.setExtras(extras);
            request.setApplicationSignature(applicationSignature);
            return this.createActivation(request);
        }

        public com.wultra.security.powerauth.client.v2.VaultUnlockResponse unlockVault(VaultUnlockRequest request) throws PowerAuthClientException {
            return (com.wultra.security.powerauth.client.v2.VaultUnlockResponse)PowerAuthServiceClient.this.callWsApi(request);
        }

        public com.wultra.security.powerauth.client.v2.VaultUnlockResponse unlockVault(String activationId, String applicationKey, String data, String signature, SignatureType signatureType, String reason) throws PowerAuthClientException {
            VaultUnlockRequest request = new VaultUnlockRequest();
            request.setActivationId(activationId);
            request.setApplicationKey(applicationKey);
            request.setData(data);
            request.setSignature(signature);
            request.setSignatureType(signatureType);
            request.setReason(reason);
            return this.unlockVault(request);
        }

        public GetPersonalizedEncryptionKeyResponse generatePersonalizedE2EEncryptionKey(GetPersonalizedEncryptionKeyRequest request) throws PowerAuthClientException {
            return (GetPersonalizedEncryptionKeyResponse)PowerAuthServiceClient.this.callWsApi(request);
        }

        public GetPersonalizedEncryptionKeyResponse generatePersonalizedE2EEncryptionKey(String activationId, String sessionIndex) throws PowerAuthClientException {
            GetPersonalizedEncryptionKeyRequest request = new GetPersonalizedEncryptionKeyRequest();
            request.setActivationId(activationId);
            request.setSessionIndex(sessionIndex);
            return this.generatePersonalizedE2EEncryptionKey(request);
        }

        public GetNonPersonalizedEncryptionKeyResponse generateNonPersonalizedE2EEncryptionKey(GetNonPersonalizedEncryptionKeyRequest request) throws PowerAuthClientException {
            return (GetNonPersonalizedEncryptionKeyResponse)PowerAuthServiceClient.this.callWsApi(request);
        }

        public GetNonPersonalizedEncryptionKeyResponse generateNonPersonalizedE2EEncryptionKey(String applicationKey, String ephemeralPublicKeyBase64, String sessionIndex) throws PowerAuthClientException {
            GetNonPersonalizedEncryptionKeyRequest request = new GetNonPersonalizedEncryptionKeyRequest();
            request.setApplicationKey(applicationKey);
            request.setEphemeralPublicKey(ephemeralPublicKeyBase64);
            request.setSessionIndex(sessionIndex);
            return this.generateNonPersonalizedE2EEncryptionKey(request);
        }

        public com.wultra.security.powerauth.client.v2.CreateTokenResponse createToken(com.wultra.security.powerauth.client.v2.CreateTokenRequest request) throws PowerAuthClientException {
            return (com.wultra.security.powerauth.client.v2.CreateTokenResponse)PowerAuthServiceClient.this.callWsApi(request);
        }

        public com.wultra.security.powerauth.client.v2.CreateTokenResponse createToken(String activationId, String ephemeralPublicKey, SignatureType signatureType) throws PowerAuthClientException {
            com.wultra.security.powerauth.client.v2.CreateTokenRequest request = new com.wultra.security.powerauth.client.v2.CreateTokenRequest();
            request.setActivationId(activationId);
            request.setEphemeralPublicKey(ephemeralPublicKey);
            request.setSignatureType(signatureType);
            return this.createToken(request);
        }
    }
}

