/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.io.BaseEncoding;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.model.ActivationStatusBlobInfo;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import io.getlime.security.powerauth.rest.api.model.base.PowerAuthApiRequest;
import io.getlime.security.powerauth.rest.api.model.base.PowerAuthApiResponse;
import io.getlime.security.powerauth.rest.api.model.request.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.ActivationStatusResponse;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.json.simple.JSONObject;

public class GetStatusStep
implements BaseStep {
    private static final PowerAuthClientActivation activation = new PowerAuthClientActivation();
    private static final CryptoProviderUtil keyConversion = PowerAuthConfiguration.INSTANCE.getKeyConvertor();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        String uriString = (String)context.get("URI_STRING");
        JSONObject resultStatusObject = (JSONObject)context.get("STATUS_OBJECT");
        if (stepLogger != null) {
            stepLogger.writeItem("Activation Status Check Started", null, "OK", null);
        }
        String uri = uriString + "/pa/activation/status";
        String activationId = (String)resultStatusObject.get((Object)"activationId");
        String transportMasterKeyBase64 = (String)resultStatusObject.get((Object)"transportMasterKey");
        SecretKey transportMasterKey = keyConversion.convertBytesToSharedSecretKey(BaseEncoding.base64().decode((CharSequence)transportMasterKeyBase64));
        ActivationStatusRequest requestObject = new ActivationStatusRequest();
        requestObject.setActivationId(activationId);
        PowerAuthApiRequest body = new PowerAuthApiRequest();
        body.setRequestObject((Object)requestObject);
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            if (stepLogger != null) {
                stepLogger.writeServerCall(uri, "POST", requestObject, headers);
            }
            HttpResponse response = Unirest.post((String)uri).headers(headers).body((Object)body).asString();
            TypeReference<PowerAuthApiResponse<ActivationStatusResponse>> typeReference = new TypeReference<PowerAuthApiResponse<ActivationStatusResponse>>(){};
            PowerAuthApiResponse responseWrapper = (PowerAuthApiResponse)RestClientConfiguration.defaultMapper().readValue(response.getRawBody(), (TypeReference)typeReference);
            if (response.getStatus() == 200) {
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK(responseWrapper, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                }
                ActivationStatusResponse responseObject = (ActivationStatusResponse)responseWrapper.getResponseObject();
                byte[] cStatusBlob = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedStatusBlob());
                ActivationStatusBlobInfo statusBlob = activation.getStatusFromEncryptedBlob(cStatusBlob, transportMasterKey);
                HashMap<String, String> objectMap = new HashMap<String, String>();
                objectMap.put("activationId", activationId);
                objectMap.put("statusBlob", (String)statusBlob);
                if (stepLogger != null) {
                    stepLogger.writeItem("Avtivation Status", "Activation status successfully obtained", "OK", objectMap);
                    stepLogger.writeDoneOK();
                }
                return resultStatusObject;
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError(response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError((Exception)((Object)exception));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError(exception);
                stepLogger.writeDoneFailed();
            }
            return null;
        }
    }
}

