/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.vault.PowerAuthClientVault;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import io.getlime.security.powerauth.rest.api.model.base.PowerAuthApiRequest;
import io.getlime.security.powerauth.rest.api.model.base.PowerAuthApiResponse;
import io.getlime.security.powerauth.rest.api.model.request.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.response.ActivationCreateResponse;
import java.io.Console;
import java.io.FileWriter;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import org.json.simple.JSONObject;

public class PrepareActivationStep
implements BaseStep {
    private static final PowerAuthClientActivation activation = new PowerAuthClientActivation();
    private static final CryptoProviderUtil keyConversion = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
    private static final PowerAuthClientKeyFactory keyFactory = new PowerAuthClientKeyFactory();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientVault vault = new PowerAuthClientVault();
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        String activationName = (String)context.get("ACTIVATION_NAME");
        String applicationKey = (String)context.get("APPLICATION_KEY");
        String applicationSecret = (String)context.get("APPLICATION_SECRET");
        String uriString = (String)context.get("URI_STRING");
        PublicKey masterPublicKey = (PublicKey)context.get("MASTER_PUBLIC_KEY");
        String activationCode = ((String)context.get("ACTIVATION_CODE")).toUpperCase();
        JSONObject resultStatusObject = (JSONObject)context.get("STATUS_OBJECT");
        String statusFileName = (String)context.get("STATUS_FILENAME");
        String passwordProvided = (String)context.get("PASSWORD");
        if (stepLogger != null) {
            stepLogger.writeItem("Activation Started", null, "OK", null);
        }
        String uri = uriString + "/pa/activation/create";
        Pattern p = Pattern.compile("^[A-Z2-7]{5}-[A-Z2-7]{5}-[A-Z2-7]{5}-[A-Z2-7]{5}(#.*)?$");
        Matcher m = p.matcher(activationCode);
        if (!m.find() && stepLogger != null) {
            stepLogger.writeError("Activation failed", "Activation code has invalid format");
            stepLogger.writeDoneFailed();
            return null;
        }
        String activationIdShort = activationCode.substring(0, 11);
        String activationOTP = activationCode.substring(12, 23);
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("activationCode", activationCode);
        objectMap.put("activationIdShort", activationIdShort);
        objectMap.put("activationOtp", activationOTP);
        if (stepLogger != null) {
            stepLogger.writeItem("Activation code", "Parsing activation code to short activation ID and activation OTP", "OK", objectMap);
        }
        KeyPair clientEphemeralKeyPair = keyGenerator.generateKeyPair();
        KeyPair deviceKeyPair = activation.generateDeviceKeyPair();
        byte[] nonceDeviceBytes = activation.generateActivationNonce();
        byte[] cDevicePublicKeyBytes = activation.encryptDevicePublicKey(deviceKeyPair.getPublic(), clientEphemeralKeyPair.getPrivate(), masterPublicKey, activationOTP, activationIdShort, nonceDeviceBytes);
        byte[] signature = activation.computeApplicationSignature(activationIdShort, nonceDeviceBytes, cDevicePublicKeyBytes, BaseEncoding.base64().decode((CharSequence)applicationKey), BaseEncoding.base64().decode((CharSequence)applicationSecret));
        byte[] ephemeralPublicKeyBytes = keyConversion.convertPublicKeyToBytes(clientEphemeralKeyPair.getPublic());
        ActivationCreateRequest requestObject = new ActivationCreateRequest();
        requestObject.setActivationIdShort(activationIdShort);
        requestObject.setApplicationKey(applicationKey);
        requestObject.setActivationName(activationName);
        requestObject.setActivationNonce(BaseEncoding.base64().encode(nonceDeviceBytes));
        requestObject.setEphemeralPublicKey(BaseEncoding.base64().encode(ephemeralPublicKeyBytes));
        requestObject.setEncryptedDevicePublicKey(BaseEncoding.base64().encode(cDevicePublicKeyBytes));
        requestObject.setApplicationSignature(BaseEncoding.base64().encode(signature));
        PowerAuthApiRequest body = new PowerAuthApiRequest();
        body.setRequestObject((Object)requestObject);
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            if (stepLogger != null) {
                stepLogger.writeServerCall(uri, "POST", requestObject, headers);
            }
            HttpResponse response = Unirest.post((String)uri).headers(headers).body((Object)body).asString();
            TypeReference<PowerAuthApiResponse<ActivationCreateResponse>> typeReference = new TypeReference<PowerAuthApiResponse<ActivationCreateResponse>>(){};
            PowerAuthApiResponse responseWrapper = (PowerAuthApiResponse)RestClientConfiguration.defaultMapper().readValue(response.getRawBody(), (TypeReference)typeReference);
            if (response.getStatus() == 200) {
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK(responseWrapper, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                }
                ActivationCreateResponse responseObject = (ActivationCreateResponse)responseWrapper.getResponseObject();
                String activationId = responseObject.getActivationId();
                byte[] nonceServerBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getActivationNonce());
                byte[] cServerPubKeyBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedServerPublicKey());
                byte[] cServerPubKeySignatureBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedServerPublicKeySignature());
                byte[] ephemeralKeyBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEphemeralPublicKey());
                PublicKey ephemeralPublicKey = keyConversion.convertBytesToPublicKey(ephemeralKeyBytes);
                boolean isDataSignatureValid = activation.verifyServerDataSignature(activationId, cServerPubKeyBytes, cServerPubKeySignatureBytes, masterPublicKey);
                if (isDataSignatureValid) {
                    char[] password;
                    PublicKey serverPublicKey = activation.decryptServerPublicKey(cServerPubKeyBytes, deviceKeyPair.getPrivate(), ephemeralPublicKey, activationOTP, activationIdShort, nonceServerBytes);
                    SecretKey masterSecretKey = keyFactory.generateClientMasterSecretKey(deviceKeyPair.getPrivate(), serverPublicKey);
                    SecretKey signaturePossessionSecretKey = keyFactory.generateClientSignaturePossessionKey(masterSecretKey);
                    SecretKey signatureKnoweldgeSecretKey = keyFactory.generateClientSignatureKnowledgeKey(masterSecretKey);
                    SecretKey signatureBiometrySecretKey = keyFactory.generateClientSignatureBiometryKey(masterSecretKey);
                    SecretKey transportMasterKey = keyFactory.generateServerTransportKey(masterSecretKey);
                    SecretKey vaultUnlockMasterKey = keyFactory.generateServerEncryptedVaultKey(masterSecretKey);
                    byte[] encryptedDevicePrivateKey = vault.encryptDevicePrivateKey(deviceKeyPair.getPrivate(), vaultUnlockMasterKey);
                    if (passwordProvided == null) {
                        Console console = System.console();
                        password = console.readPassword("Select a password to encrypt the knowledge related key: ", new Object[0]);
                    } else {
                        password = passwordProvided.toCharArray();
                    }
                    byte[] salt = keyGenerator.generateRandomBytes(16);
                    byte[] cSignatureKnoweldgeSecretKey = EncryptedStorageUtil.storeSignatureKnowledgeKey(password, signatureKnoweldgeSecretKey, salt, keyGenerator);
                    resultStatusObject.put((Object)"activationId", (Object)activationId);
                    resultStatusObject.put((Object)"serverPublicKey", (Object)BaseEncoding.base64().encode(keyConversion.convertPublicKeyToBytes(serverPublicKey)));
                    resultStatusObject.put((Object)"encryptedDevicePrivateKey", (Object)BaseEncoding.base64().encode(encryptedDevicePrivateKey));
                    resultStatusObject.put((Object)"signaturePossessionKey", (Object)BaseEncoding.base64().encode(keyConversion.convertSharedSecretKeyToBytes(signaturePossessionSecretKey)));
                    resultStatusObject.put((Object)"signatureKnowledgeKeyEncrypted", (Object)BaseEncoding.base64().encode(cSignatureKnoweldgeSecretKey));
                    resultStatusObject.put((Object)"signatureKnowledgeKeySalt", (Object)BaseEncoding.base64().encode(salt));
                    resultStatusObject.put((Object)"signatureBiometryKey", (Object)BaseEncoding.base64().encode(keyConversion.convertSharedSecretKeyToBytes(signatureBiometrySecretKey)));
                    resultStatusObject.put((Object)"transportMasterKey", (Object)BaseEncoding.base64().encode(keyConversion.convertSharedSecretKeyToBytes(transportMasterKey)));
                    resultStatusObject.put((Object)"counter", (Object)0);
                    String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)resultStatusObject);
                    try (FileWriter file = new FileWriter(statusFileName);){
                        file.write(formatted);
                    }
                    objectMap = new HashMap();
                    objectMap.put("activationId", activationId);
                    objectMap.put("activationStatusFile", statusFileName);
                    objectMap.put("activationStatusFileContent", resultStatusObject);
                    objectMap.put("deviceKeyFingerprint", activation.computeDevicePublicKeyFingerprint(deviceKeyPair.getPublic()));
                    if (stepLogger != null) {
                        stepLogger.writeItem("Activation Done", "Public key exchange was successfully completed, commit the activation on server", "OK", objectMap);
                        stepLogger.writeDoneOK();
                    }
                    return resultStatusObject;
                }
                if (stepLogger != null) {
                    String message = "Activation data signature does not match. Either someone tried to spoof your connection, or your device master key is invalid.";
                    stepLogger.writeError(message);
                    stepLogger.writeDoneFailed();
                }
                return null;
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError(response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError((Exception)((Object)exception));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError(exception);
                stepLogger.writeDoneFailed();
            }
            return null;
        }
    }
}

