/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.security.powerauth.crypto.client.signature.PowerAuthClientSignature;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import io.getlime.security.powerauth.rest.api.model.base.PowerAuthApiResponse;
import io.getlime.security.powerauth.rest.api.model.response.ActivationRemoveResponse;
import java.io.Console;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.json.simple.JSONObject;

public class RemoveStep
implements BaseStep {
    private static final CryptoProviderUtil keyConversion = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientSignature signature = new PowerAuthClientSignature();
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        char[] password;
        String uriString = (String)context.get("URI_STRING");
        JSONObject resultStatusObject = (JSONObject)context.get("STATUS_OBJECT");
        String statusFileName = (String)context.get("STATUS_FILENAME");
        String applicationKey = (String)context.get("APPLICATION_KEY");
        String applicationSecret = (String)context.get("APPLICATION_SECRET");
        String passwordProvided = (String)context.get("PASSWORD");
        if (stepLogger != null) {
            stepLogger.writeItem("Activation Removal Started", null, "OK", null);
        }
        String uri = uriString + "/pa/activation/remove";
        String activationId = (String)resultStatusObject.get((Object)"activationId");
        long counter = (Long)resultStatusObject.get((Object)"counter");
        byte[] signaturePossessionKeyBytes = BaseEncoding.base64().decode((CharSequence)((String)resultStatusObject.get((Object)"signaturePossessionKey")));
        byte[] signatureKnowledgeKeySalt = BaseEncoding.base64().decode((CharSequence)((String)resultStatusObject.get((Object)"signatureKnowledgeKeySalt")));
        byte[] signatureKnowledgeKeyEncryptedBytes = BaseEncoding.base64().decode((CharSequence)((String)resultStatusObject.get((Object)"signatureKnowledgeKeyEncrypted")));
        if (passwordProvided == null) {
            Console console = System.console();
            password = console.readPassword("Enter your password to unlock the knowledge related key: ", new Object[0]);
        } else {
            password = passwordProvided.toCharArray();
        }
        SecretKey signaturePossessionKey = keyConversion.convertBytesToSharedSecretKey(signaturePossessionKeyBytes);
        SecretKey signatureKnowledgeKey = EncryptedStorageUtil.getSignatureKnowledgeKey(password, signatureKnowledgeKeyEncryptedBytes, signatureKnowledgeKeySalt, keyGenerator);
        byte[] pa_nonce = keyGenerator.generateRandomBytes(16);
        String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/activation/remove", (byte[])pa_nonce, null) + "&" + applicationSecret;
        String pa_signature = signature.signatureForData(signatureBaseString.getBytes("UTF-8"), Arrays.asList(signaturePossessionKey, signatureKnowledgeKey), counter);
        String httpAuhtorizationHeader = PowerAuthHttpHeader.getPowerAuthSignatureHTTPHeader((String)activationId, (String)applicationKey, (String)BaseEncoding.base64().encode(pa_nonce), (String)PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE.toString(), (String)pa_signature, (String)"2.0");
        resultStatusObject.put((Object)"counter", (Object)(++counter));
        String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)resultStatusObject);
        try (FileWriter file = new FileWriter(statusFileName);){
            file.write(formatted);
        }
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Authorization", httpAuhtorizationHeader);
            if (stepLogger != null) {
                stepLogger.writeServerCall(uri, "POST", null, headers);
            }
            HttpResponse response = Unirest.post((String)uri).headers(headers).asString();
            TypeReference<PowerAuthApiResponse<ActivationRemoveResponse>> typeReference = new TypeReference<PowerAuthApiResponse<ActivationRemoveResponse>>(){};
            PowerAuthApiResponse responseWrapper = (PowerAuthApiResponse)RestClientConfiguration.defaultMapper().readValue(response.getRawBody(), (TypeReference)typeReference);
            if (response.getStatus() == 200) {
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK(responseWrapper, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                }
                HashMap<String, String> objectMap = new HashMap<String, String>();
                objectMap.put("activationId", activationId);
                if (stepLogger != null) {
                    stepLogger.writeItem("Activation Removed", "Activation was successfully removed from the server", "OK", objectMap);
                    stepLogger.writeDoneOK();
                }
                return resultStatusObject;
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError(response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError((Exception)((Object)exception));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError(exception);
                stepLogger.writeDoneFailed();
            }
            return null;
        }
    }
}

