/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.signature.PowerAuthClientSignature;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthRequestCanonizationUtils;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.JsonStepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.VerifySignatureStepModel;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import java.io.Console;
import java.io.FileWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.json.simple.JSONObject;

public class VerifySignatureStep
implements BaseStep {
    private static final CryptoProviderUtil keyConversion = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientSignature signature = new PowerAuthClientSignature();
    private static final PowerAuthClientKeyFactory keyFactory = new PowerAuthClientKeyFactory();
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public JSONObject execute(JsonStepLogger stepLogger, Map<String, Object> context) throws Exception {
        byte[] dataFileBytes;
        char[] password;
        VerifySignatureStepModel model = new VerifySignatureStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("Signature Validation Started", null, "OK", null);
        }
        String activationId = (String)model.getResultStatusObject().get((Object)"activationId");
        long counter = (Long)model.getResultStatusObject().get((Object)"counter");
        byte[] signaturePossessionKeyBytes = BaseEncoding.base64().decode((CharSequence)((String)model.getResultStatusObject().get((Object)"signaturePossessionKey")));
        byte[] signatureBiometryKeyBytes = BaseEncoding.base64().decode((CharSequence)((String)model.getResultStatusObject().get((Object)"signatureBiometryKey")));
        byte[] signatureKnowledgeKeySalt = BaseEncoding.base64().decode((CharSequence)((String)model.getResultStatusObject().get((Object)"signatureKnowledgeKeySalt")));
        byte[] signatureKnowledgeKeyEncryptedBytes = BaseEncoding.base64().decode((CharSequence)((String)model.getResultStatusObject().get((Object)"signatureKnowledgeKeyEncrypted")));
        if (model.getPassword() == null) {
            Console console = System.console();
            password = console.readPassword("Enter your password to unlock the knowledge related key: ", new Object[0]);
        } else {
            password = model.getPassword().toCharArray();
        }
        SecretKey signaturePossessionKey = keyConversion.convertBytesToSharedSecretKey(signaturePossessionKeyBytes);
        SecretKey signatureKnowledgeKey = EncryptedStorageUtil.getSignatureKnowledgeKey(password, signatureKnowledgeKeyEncryptedBytes, signatureKnowledgeKeySalt, keyGenerator);
        SecretKey signatureBiometryKey = keyConversion.convertBytesToSharedSecretKey(signatureBiometryKeyBytes);
        byte[] pa_nonce = keyGenerator.generateRandomBytes(16);
        if ("GET".equals(model.getHttpMethod().toUpperCase())) {
            String query = new URI(model.getUriString()).getRawQuery();
            String canonizedQuery = PowerAuthRequestCanonizationUtils.canonizeGetParameters((String)query);
            if (canonizedQuery != null) {
                dataFileBytes = canonizedQuery.getBytes("UTF-8");
            } else {
                dataFileBytes = new byte[]{};
                if (stepLogger != null) {
                    stepLogger.writeItem("Empty data", "No GET query parameters found in provided URL, signature will contain no data", "WARNING", null);
                }
            }
        } else if (model.getDataFileName() != null && Files.exists(Paths.get(model.getDataFileName(), new String[0]), new LinkOption[0])) {
            dataFileBytes = Files.readAllBytes(Paths.get(model.getDataFileName(), new String[0]));
        } else {
            dataFileBytes = new byte[]{};
            if (stepLogger != null) {
                stepLogger.writeItem("Empty data", "Data file was not found, signature will contain no data", "WARNING", null);
            }
        }
        String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)model.getHttpMethod().toUpperCase(), (String)model.getResourceId(), (byte[])pa_nonce, (byte[])dataFileBytes) + "&" + model.getApplicationSecret();
        String pa_signature = signature.signatureForData(signatureBaseString.getBytes("UTF-8"), keyFactory.keysForSignatureType(model.getSignatureType(), signaturePossessionKey, signatureKnowledgeKey, signatureBiometryKey), counter);
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader(activationId, model.getApplicationKey(), pa_signature, model.getSignatureType().toString(), BaseEncoding.base64().encode(pa_nonce), "2.0");
        String httpAuhtorizationHeader = header.buildHttpHeader();
        model.getResultStatusObject().put((Object)"counter", (Object)(++counter));
        String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatusObject());
        try (FileWriter file = new FileWriter(model.getStatusFileName());){
            file.write(formatted);
        }
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Authorization", httpAuhtorizationHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall(model.getUriString(), model.getHttpMethod().toUpperCase(), new String(dataFileBytes, "UTF-8"), headers);
            }
            HttpResponse response = "GET".equals(model.getHttpMethod().toUpperCase()) ? Unirest.get((String)model.getUriString()).headers(headers).asString() : Unirest.post((String)model.getUriString()).headers(headers).body(dataFileBytes).asString();
            TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>(){};
            Map responseWrapper = (Map)RestClientConfiguration.defaultMapper().readValue(response.getRawBody(), (TypeReference)typeReference);
            if (response.getStatus() == 200) {
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK(responseWrapper, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                    stepLogger.writeItem("Signature verified", "Activation signature was verified successfully", "OK", null);
                    stepLogger.writeDoneOK();
                }
                return model.getResultStatusObject();
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError(response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError((Exception)((Object)exception));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError(exception);
                stepLogger.writeDoneFailed();
            }
            return null;
        }
    }
}

