/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.util;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.lib.cmd.logging.JsonStepLogger;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import org.json.simple.JSONObject;

public class ConfigurationUtils {
    private static final String expectedApplicationKey = "MTIzNDU2Nzg5MGFiY2RlZg==";
    private static final String expectedApplicationSecret = "c2VjcmV0MDAwMDAwMDAwMA==";
    private static final String expectedApplicationName = "PowerAuth 2.0 Reference Client";

    public static String getApplicationKey(JSONObject clientConfigObject) {
        if (clientConfigObject.get((Object)"applicationKey") != null) {
            return (String)clientConfigObject.get((Object)"applicationKey");
        }
        return expectedApplicationKey;
    }

    public static String getApplicationSecret(JSONObject clientConfigObject) {
        if (clientConfigObject.get((Object)"applicationSecret") != null) {
            return (String)clientConfigObject.get((Object)"applicationSecret");
        }
        return expectedApplicationSecret;
    }

    public static String getApplicationName(JSONObject clientConfigObject) {
        if (clientConfigObject.get((Object)"applicationName") != null) {
            return (String)clientConfigObject.get((Object)"applicationName");
        }
        return expectedApplicationName;
    }

    public static PublicKey getMasterKey(JSONObject clientConfigObject, JsonStepLogger stepLogger) {
        if (clientConfigObject != null && clientConfigObject.get((Object)"masterPublicKey") != null) {
            try {
                byte[] masterKeyBytes = BaseEncoding.base64().decode((CharSequence)((String)clientConfigObject.get((Object)"masterPublicKey")));
                return PowerAuthConfiguration.INSTANCE.getKeyConvertor().convertBytesToPublicKey(masterKeyBytes);
            }
            catch (IllegalArgumentException e) {
                stepLogger.writeError("Invalid Master Server Public Key", "Master Server Public Key must be stored in a valid Base64 encoding", e);
                stepLogger.writeDoneFailed();
                System.exit(1);
            }
            catch (InvalidKeySpecException e) {
                stepLogger.writeError("Invalid Master Server Public Key", "Master Server Public Key was stored in an incorrect format", e);
                stepLogger.writeDoneFailed();
                System.exit(1);
            }
        } else {
            stepLogger.writeError("Invalid Master Server Public Key", "Master Server Public Key not found in the config file");
            stepLogger.writeDoneFailed();
            System.exit(1);
        }
        return null;
    }
}

