/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.client.signature.PowerAuthClientSignature;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.BasicEciesEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesPayload;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.JsonStepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.CreateTokenStepModel;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import io.getlime.security.powerauth.rest.api.model.entity.TokenResponsePayload;
import io.getlime.security.powerauth.rest.api.model.request.TokenCreateRequest;
import io.getlime.security.powerauth.rest.api.model.response.TokenCreateResponse;
import java.io.Console;
import java.io.FileWriter;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.json.simple.JSONObject;

public class CreateTokenStep
implements BaseStep {
    private static final CryptoProviderUtil keyConversion = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientSignature signature = new PowerAuthClientSignature();
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public JSONObject execute(JsonStepLogger stepLogger, Map<String, Object> context) throws Exception {
        char[] password;
        CreateTokenStepModel model = new CreateTokenStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("Token Create Started", null, "OK", null);
        }
        String uri = model.getUriString() + "/pa/token/create";
        String activationId = (String)model.getResultStatusObject().get((Object)"activationId");
        long counter = (Long)model.getResultStatusObject().get((Object)"counter");
        byte[] signaturePossessionKeyBytes = BaseEncoding.base64().decode((CharSequence)((String)model.getResultStatusObject().get((Object)"signaturePossessionKey")));
        byte[] signatureKnowledgeKeySalt = BaseEncoding.base64().decode((CharSequence)((String)model.getResultStatusObject().get((Object)"signatureKnowledgeKeySalt")));
        byte[] signatureKnowledgeKeyEncryptedBytes = BaseEncoding.base64().decode((CharSequence)((String)model.getResultStatusObject().get((Object)"signatureKnowledgeKeyEncrypted")));
        if (model.getPassword() == null) {
            Console console = System.console();
            password = console.readPassword("Enter your password to unlock the knowledge related key: ", new Object[0]);
        } else {
            password = model.getPassword().toCharArray();
        }
        SecretKey signaturePossessionKey = keyConversion.convertBytesToSharedSecretKey(signaturePossessionKeyBytes);
        SecretKey signatureKnowledgeKey = EncryptedStorageUtil.getSignatureKnowledgeKey(password, signatureKnowledgeKeyEncryptedBytes, signatureKnowledgeKeySalt, keyGenerator);
        byte[] pa_nonce = keyGenerator.generateRandomBytes(16);
        BasicEciesEncryptor encryptor = new BasicEciesEncryptor((ECPublicKey)model.getMasterPublicKey());
        PublicKey ephemeralPublicKey = encryptor.getEphemeralPublicKey();
        byte[] ephemeralPublicKeyBytes = keyConversion.convertPublicKeyToBytes(ephemeralPublicKey);
        EciesPayload eciesPayload = encryptor.encrypt(new byte[0], ephemeralPublicKeyBytes);
        TokenCreateRequest requestObject = new TokenCreateRequest();
        String ephemeralPublicKeyBase64 = BaseEncoding.base64().encode(ephemeralPublicKeyBytes);
        requestObject.setEphemeralPublicKey(ephemeralPublicKeyBase64);
        ObjectRequest request = new ObjectRequest((Object)requestObject);
        byte[] requestBytes = RestClientConfiguration.defaultMapper().writeValueAsBytes((Object)request);
        String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/token/create", (byte[])pa_nonce, (byte[])requestBytes) + "&" + model.getApplicationSecret();
        String pa_signature = signature.signatureForData(signatureBaseString.getBytes("UTF-8"), Arrays.asList(signaturePossessionKey, signatureKnowledgeKey), counter);
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader(activationId, model.getApplicationKey(), pa_signature, model.getSignatureType().toString(), BaseEncoding.base64().encode(pa_nonce), "2.1");
        String httpAuhtorizationHeader = header.buildHttpHeader();
        model.getResultStatusObject().put((Object)"counter", (Object)(++counter));
        String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatusObject());
        try (FileWriter file = new FileWriter(model.getStatusFileName());){
            file.write(formatted);
        }
        try {
            HttpResponse response;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Authorization", httpAuhtorizationHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall(uri, "POST", requestObject, headers);
            }
            if ((response = Unirest.post((String)uri).headers(headers).body(requestBytes).asString()).getStatus() == 200) {
                TypeReference<ObjectResponse<TokenCreateResponse>> typeReference = new TypeReference<ObjectResponse<TokenCreateResponse>>(){};
                ObjectResponse responseWrapper = (ObjectResponse)RestClientConfiguration.defaultMapper().readValue(response.getRawBody(), (TypeReference)typeReference);
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK(responseWrapper, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                }
                TokenCreateResponse responseObject = (TokenCreateResponse)responseWrapper.getResponseObject();
                byte[] mac = BaseEncoding.base64().decode((CharSequence)responseObject.getMac());
                byte[] encryptedBody = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedData());
                EciesPayload eciesResponsePayload = new EciesPayload(eciesPayload.getEphemeralPublicKey(), mac, encryptedBody);
                byte[] decryptedBytes = encryptor.decrypt(eciesResponsePayload);
                TokenResponsePayload tokenResponsePayload = (TokenResponsePayload)RestClientConfiguration.defaultMapper().readValue(decryptedBytes, TokenResponsePayload.class);
                HashMap<String, String> objectMap = new HashMap<String, String>();
                objectMap.put("tokenId", tokenResponsePayload.getTokenId());
                objectMap.put("tokenSecret", tokenResponsePayload.getTokenSecret());
                if (stepLogger != null) {
                    stepLogger.writeItem("Token successfully obtained", "Token was successfully generated and decrypted", "OK", objectMap);
                    stepLogger.writeDoneOK();
                }
                return model.getResultStatusObject();
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError(response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError((Exception)((Object)exception));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError(exception);
                stepLogger.writeDoneFailed();
            }
            return null;
        }
    }
}

