/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.io.BaseEncoding;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.security.powerauth.crypto.client.token.ClientTokenGenerator;
import io.getlime.security.powerauth.http.PowerAuthTokenHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.JsonStepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.VerifyTokenStepModel;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;

public class VerifyTokenStep
implements BaseStep {
    @Override
    public JSONObject execute(JsonStepLogger stepLogger, Map<String, Object> context) throws Exception {
        VerifyTokenStepModel model = new VerifyTokenStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("TOKEN_ID", model.getTokenId());
            map.put("TOKEN_SECRET", model.getTokenSecret());
            stepLogger.writeItem("Token Digest Validation Started", null, "OK", map);
        }
        String tokenId = model.getTokenId();
        byte[] tokenSecret = BaseEncoding.base64().decode((CharSequence)model.getTokenSecret());
        ClientTokenGenerator tokenGenerator = new ClientTokenGenerator();
        byte[] tokenNonce = tokenGenerator.generateTokenNonce();
        byte[] tokenTimestamp = tokenGenerator.generateTokenTimestamp();
        byte[] tokenDigest = tokenGenerator.computeTokenDigest(tokenNonce, tokenTimestamp, tokenSecret);
        String tokenHeader = new PowerAuthTokenHttpHeader(tokenId, BaseEncoding.base64().encode(tokenDigest), BaseEncoding.base64().encode(tokenNonce), new String(tokenTimestamp, "UTF-8"), "2.1").buildHttpHeader();
        byte[] dataFileBytes = null;
        if (!"GET".equals(model.getHttpMethod().toUpperCase())) {
            if (model.getDataFileName() != null && Files.exists(Paths.get(model.getDataFileName(), new String[0]), new LinkOption[0])) {
                dataFileBytes = Files.readAllBytes(Paths.get(model.getDataFileName(), new String[0]));
            } else {
                dataFileBytes = new byte[]{};
                if (stepLogger != null) {
                    stepLogger.writeItem("Empty data", "Data file was not found, signature will contain no data", "WARNING", null);
                }
            }
        }
        try {
            HttpResponse response;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Token", tokenHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall(model.getUriString(), model.getHttpMethod().toUpperCase(), dataFileBytes != null ? new String(dataFileBytes, "UTF-8") : null, headers);
            }
            if ((response = "GET".equals(model.getHttpMethod().toUpperCase()) ? Unirest.get((String)model.getUriString()).headers(headers).asString() : Unirest.post((String)model.getUriString()).headers(headers).body(dataFileBytes).asString()).getStatus() == 200) {
                TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>(){};
                Map responseWrapper = (Map)RestClientConfiguration.defaultMapper().readValue(response.getRawBody(), (TypeReference)typeReference);
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK(responseWrapper, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                    stepLogger.writeItem("Token digest verified", "Token based authentication was successful", "OK", null);
                    stepLogger.writeDoneOK();
                }
                return model.getResultStatusObject();
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError(response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError((Exception)((Object)exception));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError(exception);
                stepLogger.writeDoneFailed();
            }
            return null;
        }
    }
}

