/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.crypto.client.signature.PowerAuthClientSignature;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.StartUpgradeStepModel;
import io.getlime.security.powerauth.lib.cmd.util.CounterUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.JsonUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.json.simple.JSONObject;

public class CommitUpgradeStep
implements BaseStep {
    private static final CryptoProviderUtil keyConversion = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientSignature signature = new PowerAuthClientSignature();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) {
        StartUpgradeStepModel model = new StartUpgradeStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("Upgrade Commit Started", null, "OK", null);
        }
        String uri = model.getUriString() + "/pa/v3/upgrade/commit";
        String activationId = JsonUtil.stringValue(model.getResultStatusObject(), "activationId");
        byte[] signaturePossessionKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signaturePossessionKey"));
        SecretKey signaturePossessionKey = keyConversion.convertBytesToSharedSecretKey(signaturePossessionKeyBytes);
        byte[] pa_nonce = keyGenerator.generateRandomBytes(16);
        String request = "{}";
        byte[] requestBytes = "{}".getBytes(StandardCharsets.UTF_8);
        model.getResultStatusObject().put((Object)"version", (Object)3L);
        try {
            HttpResponse response;
            String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/upgrade/commit", (byte[])pa_nonce, (byte[])requestBytes) + "&" + model.getApplicationSecret();
            byte[] ctrData = CounterUtil.getCtrData(model, stepLogger);
            String pa_signature = signature.signatureForData(signatureBaseString.getBytes(StandardCharsets.UTF_8), Collections.singletonList(signaturePossessionKey), ctrData);
            PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader(activationId, model.getApplicationKey(), pa_signature, PowerAuthSignatureTypes.POSSESSION.toString(), BaseEncoding.base64().encode(pa_nonce), model.getVersion());
            String httpAuthorizationHeader = header.buildHttpHeader();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Authorization", httpAuthorizationHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall(uri, "POST", "{}", headers);
            }
            if ((response = Unirest.post((String)uri).headers(headers).body(requestBytes).asString()).getStatus() == 200) {
                Response commitResponse = (Response)mapper.readValue(response.getRawBody(), Response.class);
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK(commitResponse, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                }
                CounterUtil.incrementCounter(model);
                String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatusObject());
                try (FileWriter file = new FileWriter(model.getStatusFileName());){
                    file.write(formatted);
                }
                if (stepLogger != null) {
                    stepLogger.writeItem("Upgrade commit successfully completed", "Upgrade commit was successfully completed", "OK", null);
                    stepLogger.writeDoneOK();
                }
                return model.getResultStatusObject();
            }
            model.getResultStatusObject().put((Object)"version", (Object)2L);
            if (stepLogger != null) {
                stepLogger.writeServerCallError(response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError((Exception)((Object)exception));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError(exception);
                stepLogger.writeDoneFailed();
            }
            return null;
        }
    }
}

