/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import com.google.common.io.BaseEncoding;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesSharedInfo1;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.EncryptStepModel;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.JsonUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECPublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.json.simple.JSONObject;

public class EncryptStep
implements BaseStep {
    private static final CryptoProviderUtil keyConversion = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
    private static final EciesFactory eciesFactory = new EciesFactory();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        PowerAuthEncryptionHttpHeader header;
        EciesEncryptor encryptor;
        EncryptStepModel model = new EncryptStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("Encrypt Request Started", null, "OK", null);
        }
        String uri = model.getUriString();
        File dataFile = new File(model.getDataFileName());
        if (!dataFile.exists()) {
            if (stepLogger != null) {
                stepLogger.writeError("Encrypt Request Failed", "File not found: " + model.getDataFileName());
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        Scanner scanner = new Scanner(dataFile, "UTF-8");
        scanner.useDelimiter("\\Z");
        String requestData = "";
        if (scanner.hasNext()) {
            requestData = scanner.next();
        }
        scanner.close();
        if (stepLogger != null) {
            stepLogger.writeItem("Preparing Request Data", "Following data will be encrypted", "OK", requestData);
        }
        byte[] applicationSecret = model.getApplicationSecret().getBytes(StandardCharsets.UTF_8);
        switch (model.getScope()) {
            case "application": {
                encryptor = eciesFactory.getEciesEncryptorForApplication((ECPublicKey)model.getMasterPublicKey(), applicationSecret, EciesSharedInfo1.APPLICATION_SCOPE_GENERIC);
                header = new PowerAuthEncryptionHttpHeader(model.getApplicationKey(), model.getVersion());
                break;
            }
            case "activation": {
                byte[] transportMasterKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "transportMasterKey"));
                byte[] serverPublicKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "serverPublicKey"));
                ECPublicKey serverPublicKey = (ECPublicKey)keyConversion.convertBytesToPublicKey(serverPublicKeyBytes);
                String activationId = JsonUtil.stringValue(model.getResultStatusObject(), "activationId");
                encryptor = eciesFactory.getEciesEncryptorForActivation(serverPublicKey, applicationSecret, transportMasterKeyBytes, EciesSharedInfo1.ACTIVATION_SCOPE_GENERIC);
                header = new PowerAuthEncryptionHttpHeader(model.getApplicationKey(), activationId, model.getVersion());
                break;
            }
            default: {
                if (stepLogger != null) {
                    stepLogger.writeError("Encrypt Request Failed", "Unsupported encryption scope: " + model.getScope());
                    stepLogger.writeDoneFailed();
                }
                return null;
            }
        }
        String httpEncryptionHeader = header.buildHttpHeader();
        byte[] requestDataBytes = requestData.getBytes(StandardCharsets.UTF_8);
        EciesCryptogram eciesCryptogram = encryptor.encryptRequest(requestDataBytes);
        EciesEncryptedRequest request = new EciesEncryptedRequest();
        String ephemeralPublicKeyBase64 = BaseEncoding.base64().encode(eciesCryptogram.getEphemeralPublicKey());
        String encryptedData = BaseEncoding.base64().encode(eciesCryptogram.getEncryptedData());
        String mac = BaseEncoding.base64().encode(eciesCryptogram.getMac());
        request.setEphemeralPublicKey(ephemeralPublicKeyBase64);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        byte[] requestBytes = RestClientConfiguration.defaultMapper().writeValueAsBytes((Object)request);
        if (stepLogger != null) {
            stepLogger.writeItem("Encrypting Request Data", "Following data is sent to intermediate server", "OK", request);
        }
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Encryption", httpEncryptionHeader);
            headers.putAll(model.getHeaders());
            HttpResponse response = Unirest.post((String)uri).headers(headers).body(requestBytes).asString();
            if (response.getStatus() == 200) {
                EciesEncryptedResponse encryptedResponse = (EciesEncryptedResponse)RestClientConfiguration.defaultMapper().readValue(response.getRawBody(), EciesEncryptedResponse.class);
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK(encryptedResponse, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                }
                byte[] macResponse = BaseEncoding.base64().decode((CharSequence)encryptedResponse.getMac());
                byte[] encryptedDataResponse = BaseEncoding.base64().decode((CharSequence)encryptedResponse.getEncryptedData());
                EciesCryptogram eciesCryptogramResponse = new EciesCryptogram(macResponse, encryptedDataResponse);
                byte[] decryptedBytes = encryptor.decryptResponse(eciesCryptogramResponse);
                String decryptedMessage = new String(decryptedBytes, StandardCharsets.UTF_8);
                model.getResultStatusObject().put((Object)"responseData", (Object)decryptedMessage);
                if (stepLogger != null) {
                    stepLogger.writeItem("Decrypted Response", "Following data were decrypted", "OK", decryptedMessage);
                    stepLogger.writeDoneOK();
                }
                return model.getResultStatusObject();
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError(response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError((Exception)((Object)exception));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError(exception);
                stepLogger.writeDoneFailed();
            }
            return null;
        }
    }
}

