/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.util;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.generator.HashBasedCounter;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.model.BaseStepModel;
import io.getlime.security.powerauth.lib.cmd.util.JsonUtil;
import java.nio.ByteBuffer;

public class CounterUtil {
    public static byte[] getCtrData(BaseStepModel model, StepLogger stepLogger) {
        byte[] ctrData = new byte[16];
        long counter = JsonUtil.longValue(model.getResultStatusObject(), "counter");
        int version = JsonUtil.intValue(model.getResultStatusObject(), "version");
        switch (version) {
            case 2: {
                ctrData = ByteBuffer.allocate(16).putLong(8, counter).array();
                break;
            }
            case 3: {
                String ctrDataBase64 = JsonUtil.stringValue(model.getResultStatusObject(), "ctrData");
                if (ctrDataBase64.isEmpty()) break;
                ctrData = BaseEncoding.base64().decode((CharSequence)ctrDataBase64);
                break;
            }
            default: {
                if (stepLogger == null) break;
                stepLogger.writeItem("Unsupported version", "The version you specified is not supported", "ERROR", null);
            }
        }
        return ctrData;
    }

    public static void incrementCounter(BaseStepModel model) {
        String ctrDataBase64;
        long counter = JsonUtil.longValue(model.getResultStatusObject(), "counter");
        model.getResultStatusObject().put((Object)"counter", (Object)(++counter));
        int version = JsonUtil.intValue(model.getResultStatusObject(), "version");
        if (version == 3 && !(ctrDataBase64 = JsonUtil.stringValue(model.getResultStatusObject(), "ctrData")).isEmpty()) {
            byte[] ctrData = BaseEncoding.base64().decode((CharSequence)ctrDataBase64);
            ctrData = new HashBasedCounter().next(ctrData);
            model.getResultStatusObject().put((Object)"ctrData", (Object)BaseEncoding.base64().encode(ctrData));
        }
    }
}

