/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.logging;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class JsonStepLogger
implements StepLogger {
    private JsonGenerator generator;
    private OutputStream outputStream;

    public JsonStepLogger(OutputStream outputStream) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter();
        pp.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        pp.indentObjectsWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        mapper.setDefaultPrettyPrinter((PrettyPrinter)pp);
        try {
            this.generator = mapper.getFactory().createGenerator(outputStream);
            this.generator.setPrettyPrinter((PrettyPrinter)pp);
            this.outputStream = outputStream;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void flush() {
        try {
            this.generator.flush();
            this.outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start() {
        try {
            this.generator.writeStartObject();
            this.generator.writeFieldName("steps");
            this.generator.writeStartArray();
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeItem(String name, String description, String status, Object object) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", name);
            map.put("description", description);
            map.put("status", status);
            map.put("object", object);
            this.generator.writeObject(map);
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeServerCall(String uri, String method, Object requestObject, Map<String, ?> headers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("url", uri);
        map.put("method", method);
        map.put("requestObject", requestObject);
        map.put("requestHeaders", headers);
        String name = "Sending Request";
        String desc = "Calling PowerAuth Standard RESTful API endpoint";
        String status = "OK";
        this.writeItem(name, desc, status, map);
    }

    @Override
    public void writeServerCallOK(Object responseObject, Map<String, ?> headers) {
        String name = "Response 200 - OK";
        String desc = "Endpoint was called successfully";
        String status = "OK";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("responseObject", responseObject);
        map.put("responseHeaders", headers);
        this.writeItem(name, desc, status, map);
    }

    @Override
    public void writeServerCallError(int statusCode, Object responseObject, Map<String, ?> headers) {
        String name = "Response " + statusCode + " - ERROR";
        String desc = "Endpoint was called with an error";
        String status = "ERROR";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("responseObject", responseObject);
        map.put("responseHeaders", headers);
        this.writeItem(name, desc, status, map);
    }

    @Override
    public void close() {
        try {
            this.generator.writeEndArray();
            this.generator.writeEndObject();
            this.flush();
            this.generator.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeServerCallConnectionError(Exception e) {
        String name = "Connection Error";
        this.writeError(name, e.getMessage(), e);
    }

    @Override
    public void writeError(String errorMessage) {
        this.writeError(null, errorMessage, null);
    }

    @Override
    public void writeError(Exception exception) {
        this.writeError(null, exception.getMessage(), exception);
    }

    @Override
    public void writeError(String name, String errorMessage) {
        this.writeError(name, errorMessage, null);
    }

    @Override
    public void writeError(String name, String errorMessage, Exception exception) {
        String status = "ERROR";
        this.writeItem(name, errorMessage, status, exception);
    }

    @Override
    public void writeDoneOK() {
        String name = "Done";
        String desc = "Execution has successfully finished";
        String status = "DONE";
        this.writeItem(name, desc, status, null);
    }

    @Override
    public void writeDoneFailed() {
        String name = "Done";
        String desc = "Execution has failed";
        String status = "FAILED";
        this.writeItem(name, desc, status, null);
    }
}

