/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.logging;

import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.model.StepError;
import io.getlime.security.powerauth.lib.cmd.logging.model.StepItem;
import io.getlime.security.powerauth.lib.cmd.logging.model.StepRequest;
import io.getlime.security.powerauth.lib.cmd.logging.model.StepResponse;
import io.getlime.security.powerauth.lib.cmd.logging.model.StepResult;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectStepLogger
implements StepLogger {
    private final List<StepItem> items;
    private final List<StepError> errors;
    private StepRequest request;
    private StepResponse response;
    private StepResult result;
    private OutputStream out;

    public ObjectStepLogger() {
        this(null);
    }

    public ObjectStepLogger(OutputStream out) {
        this.out = out;
        this.items = new ArrayList<StepItem>();
        this.errors = new ArrayList<StepError>();
    }

    @Override
    public void start() {
    }

    @Override
    public void writeItem(String name, String description, String status, Object object) {
        this.items.add(new StepItem(name, description, status, object));
        if (this.out != null) {
            String output = status + ": " + name + (description == null ? "" : " - " + description) + "\n";
            try {
                this.out.write(output.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeServerCall(String uri, String method, Object requestObject, Map<String, ?> headers) {
        if (this.request != null) {
            throw new IllegalStateException("Only one request per step is supported");
        }
        this.request = new StepRequest(uri, method, requestObject, headers);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("url", uri);
        map.put("method", method);
        map.put("requestObject", requestObject);
        map.put("requestHeaders", headers);
        String name = "Sending Request";
        String desc = "Calling PowerAuth Standard RESTful API endpoint";
        String status = "OK";
        this.writeItem(name, desc, status, map);
    }

    @Override
    public void writeServerCallOK(Object responseObject, Map<String, ?> headers) {
        if (this.response != null) {
            throw new IllegalStateException("Only one response per step is supported");
        }
        this.response = new StepResponse(200, responseObject, headers);
        String name = "Response 200 - OK";
        String desc = "Endpoint was called successfully";
        String status = "OK";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("responseObject", responseObject);
        map.put("responseHeaders", headers);
        this.writeItem(name, desc, status, map);
    }

    @Override
    public void writeServerCallError(int statusCode, Object responseObject, Map<String, ?> headers) {
        if (this.response != null) {
            throw new IllegalStateException("Only one response per step is supported");
        }
        this.response = new StepResponse(statusCode, responseObject, headers);
        String name = "Response " + statusCode + " - ERROR";
        String desc = "Endpoint was called with an error";
        String status = "ERROR";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("responseObject", responseObject);
        map.put("responseHeaders", headers);
        this.writeItem(name, desc, status, map);
    }

    @Override
    public void close() {
    }

    @Override
    public void writeServerCallConnectionError(Exception e) {
        this.writeError("Connection Error", e.getMessage(), e);
    }

    @Override
    public void writeError(String errorMessage) {
        this.writeError(null, errorMessage, null);
    }

    @Override
    public void writeError(Exception exception) {
        this.writeError(null, exception.getMessage(), exception);
    }

    @Override
    public void writeError(String name, String errorMessage) {
        this.writeError(name, errorMessage, null);
    }

    @Override
    public void writeError(String name, String errorMessage, Exception exception) {
        this.errors.add(new StepError(name, errorMessage, exception));
        String status = "ERROR";
        this.writeItem(name, errorMessage, status, exception);
    }

    @Override
    public void writeDoneOK() {
        if (this.result != null) {
            throw new IllegalStateException("Only one result per step is supported");
        }
        if (!this.errors.isEmpty()) {
            this.writeDoneFailed();
            return;
        }
        this.result = new StepResult(true);
        String name = "Done";
        String desc = "Execution has successfully finished";
        String status = "DONE";
        this.writeItem(name, desc, status, null);
    }

    @Override
    public void writeDoneFailed() {
        if (this.result != null) {
            throw new IllegalStateException("Only one result per step is supported");
        }
        this.result = new StepResult(false);
        String name = "Done";
        String desc = "Execution has failed";
        String status = "FAILED";
        this.writeItem(name, desc, status, null);
    }

    public List<StepItem> getItems() {
        return this.items;
    }

    public List<StepError> getErrors() {
        return this.errors;
    }

    public StepRequest getRequest() {
        return this.request;
    }

    public StepResponse getResponse() {
        return this.response;
    }

    public StepResult getResult() {
        return this.result;
    }
}

