/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.client.encryptor.ClientNonPersonalizedEncryptor;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.vault.PowerAuthClientVault;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.NonPersonalizedEncryptedMessage;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.http.PowerAuthRequestCanonizationUtils;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.CreateActivationStepModel;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import io.getlime.security.powerauth.rest.api.model.entity.NonPersonalizedEncryptedPayloadModel;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationCreateCustomRequest;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.ActivationCreateResponse;
import java.io.Console;
import java.io.FileWriter;
import java.net.URLEncoder;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.json.simple.JSONObject;

public class CreateActivationStep
implements BaseStep {
    private static final PowerAuthClientActivation activation = new PowerAuthClientActivation();
    private static final CryptoProviderUtil keyConversion = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
    private static final PowerAuthClientKeyFactory keyFactory = new PowerAuthClientKeyFactory();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientVault vault = new PowerAuthClientVault();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        String message;
        CreateActivationStepModel model = new CreateActivationStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("Activation With Custom Attributes Started", null, "OK", null);
        }
        String uri = model.getUriString();
        Map<String, String> identityAttributes = model.getIdentityAttributes();
        if (stepLogger != null) {
            stepLogger.writeItem("Identity Attributes", "Following attributes are used to authenticate user", "OK", identityAttributes);
        }
        Map<String, Object> customAttributes = model.getCustomAttributes();
        if (stepLogger != null) {
            stepLogger.writeItem("Custom Attributes", "Following attributes are used as custom attributes for the request", "OK", customAttributes);
        }
        String activationOTP = "00000-00000";
        if (model.getActivationOtp() != null) {
            activationOTP = model.getActivationOtp();
        }
        if (stepLogger != null) {
            stepLogger.writeItem("Using activation OTP", "Following string is used as activation OTP ('00000-00000' is used by default)'", "OK", activationOTP);
        }
        String activationIdShort = null;
        for (String key : identityAttributes.keySet()) {
            String value = identityAttributes.get(key);
            String pair = URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
            if (activationIdShort == null) {
                activationIdShort = pair;
                continue;
            }
            activationIdShort = activationIdShort + "&" + pair;
        }
        if (activationIdShort != null) {
            if ((activationIdShort = PowerAuthRequestCanonizationUtils.canonizeGetParameters(activationIdShort)) == null) {
                if (stepLogger != null) {
                    message = "Failed to extract parameters from query string - exiting.";
                    stepLogger.writeError(message);
                    stepLogger.writeDoneFailed();
                }
                return null;
            }
        } else {
            if (stepLogger != null) {
                message = "No identity attributes were provided - exiting.";
                stepLogger.writeError(message);
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        if (stepLogger != null) {
            stepLogger.writeItem("Building identity string", "Using following normalized identity string", "OK", activationIdShort);
        }
        KeyPair clientEphemeralKeyPair = keyGenerator.generateKeyPair();
        KeyPair deviceKeyPair = activation.generateDeviceKeyPair();
        byte[] nonceDeviceBytes = activation.generateActivationNonce();
        byte[] cDevicePublicKeyBytes = activation.encryptDevicePublicKey(deviceKeyPair.getPublic(), clientEphemeralKeyPair.getPrivate(), model.getMasterPublicKey(), activationOTP, activationIdShort, nonceDeviceBytes);
        byte[] signature = activation.computeApplicationSignature(activationIdShort, nonceDeviceBytes, cDevicePublicKeyBytes, BaseEncoding.base64().decode((CharSequence)model.getApplicationKey()), BaseEncoding.base64().decode((CharSequence)model.getApplicationSecret()));
        byte[] ephemeralPublicKeyBytes = keyConversion.convertPublicKeyToBytes(clientEphemeralKeyPair.getPublic());
        ActivationCreateRequest powerauth = new ActivationCreateRequest();
        powerauth.setActivationIdShort(activationIdShort);
        powerauth.setApplicationKey(model.getApplicationKey());
        powerauth.setActivationName(model.getActivationName());
        powerauth.setActivationNonce(BaseEncoding.base64().encode(nonceDeviceBytes));
        powerauth.setEphemeralPublicKey(BaseEncoding.base64().encode(ephemeralPublicKeyBytes));
        powerauth.setEncryptedDevicePublicKey(BaseEncoding.base64().encode(cDevicePublicKeyBytes));
        powerauth.setApplicationSignature(BaseEncoding.base64().encode(signature));
        ActivationCreateCustomRequest requestObject = new ActivationCreateCustomRequest();
        requestObject.setIdentity(identityAttributes);
        requestObject.setCustomAttributes(customAttributes);
        requestObject.setPowerauth(powerauth);
        if (stepLogger != null) {
            stepLogger.writeItem("Building activation request object", "Following activation attributes will be encrypted and sent to the server", "OK", requestObject);
        }
        byte[] requestObjectBytes = mapper.writeValueAsBytes((Object)requestObject);
        ClientNonPersonalizedEncryptor encryptor = new ClientNonPersonalizedEncryptor(BaseEncoding.base64().decode((CharSequence)model.getApplicationKey()), model.getMasterPublicKey());
        NonPersonalizedEncryptedMessage encryptedMessage = encryptor.encrypt(requestObjectBytes);
        NonPersonalizedEncryptedPayloadModel encryptedRequestObject = new NonPersonalizedEncryptedPayloadModel();
        encryptedRequestObject.setAdHocIndex(BaseEncoding.base64().encode(encryptedMessage.getAdHocIndex()));
        encryptedRequestObject.setApplicationKey(BaseEncoding.base64().encode(encryptedMessage.getApplicationKey()));
        encryptedRequestObject.setEncryptedData(BaseEncoding.base64().encode(encryptedMessage.getEncryptedData()));
        encryptedRequestObject.setEphemeralPublicKey(BaseEncoding.base64().encode(encryptedMessage.getEphemeralPublicKey()));
        encryptedRequestObject.setMac(BaseEncoding.base64().encode(encryptedMessage.getMac()));
        encryptedRequestObject.setMacIndex(BaseEncoding.base64().encode(encryptedMessage.getMacIndex()));
        encryptedRequestObject.setNonce(BaseEncoding.base64().encode(encryptedMessage.getNonce()));
        encryptedRequestObject.setSessionIndex(BaseEncoding.base64().encode(encryptedMessage.getSessionIndex()));
        ObjectRequest body = new ObjectRequest();
        body.setRequestObject((Object)encryptedRequestObject);
        if (stepLogger != null) {
            stepLogger.writeItem("Encrypting request object", "Following encrypted object is used for activation", "OK", body);
        }
        try {
            HttpResponse response;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall(uri, "POST", requestObject, headers);
            }
            if ((response = Unirest.post((String)uri).headers(headers).body((Object)body).asString()).getStatus() == 200) {
                TypeReference<ObjectResponse<NonPersonalizedEncryptedPayloadModel>> typeReference = new TypeReference<ObjectResponse<NonPersonalizedEncryptedPayloadModel>>(){};
                ObjectResponse responseWrapper = (ObjectResponse)RestClientConfiguration.defaultMapper().readValue(response.getRawBody(), (TypeReference)typeReference);
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK(responseWrapper, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                }
                NonPersonalizedEncryptedPayloadModel encryptedResponseObject = (NonPersonalizedEncryptedPayloadModel)responseWrapper.getResponseObject();
                encryptedMessage.setApplicationKey(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getApplicationKey()));
                encryptedMessage.setAdHocIndex(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getAdHocIndex()));
                encryptedMessage.setEphemeralPublicKey(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getEphemeralPublicKey()));
                encryptedMessage.setEncryptedData(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getEncryptedData()));
                encryptedMessage.setMac(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getMac()));
                encryptedMessage.setMacIndex(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getMacIndex()));
                encryptedMessage.setNonce(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getNonce()));
                encryptedMessage.setSessionIndex(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getSessionIndex()));
                byte[] originalResponseObjectBytes = encryptor.decrypt(encryptedMessage);
                ActivationCreateResponse responseObject = (ActivationCreateResponse)mapper.readValue(originalResponseObjectBytes, ActivationCreateResponse.class);
                if (stepLogger != null) {
                    stepLogger.writeItem("Decrypted response", "Following activation data were decrypted", "OK", responseObject);
                }
                String activationId = responseObject.getActivationId();
                byte[] nonceServerBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getActivationNonce());
                byte[] cServerPubKeyBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedServerPublicKey());
                byte[] cServerPubKeySignatureBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedServerPublicKeySignature());
                byte[] ephemeralKeyBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEphemeralPublicKey());
                PublicKey ephemeralPublicKey = keyConversion.convertBytesToPublicKey(ephemeralKeyBytes);
                boolean isDataSignatureValid = activation.verifyServerDataSignature(activationId, cServerPubKeyBytes, cServerPubKeySignatureBytes, model.getMasterPublicKey());
                if (isDataSignatureValid) {
                    char[] password;
                    PublicKey serverPublicKey = activation.decryptServerPublicKey(cServerPubKeyBytes, deviceKeyPair.getPrivate(), ephemeralPublicKey, activationOTP, activationIdShort, nonceServerBytes);
                    SecretKey masterSecretKey = keyFactory.generateClientMasterSecretKey(deviceKeyPair.getPrivate(), serverPublicKey);
                    SecretKey signaturePossessionSecretKey = keyFactory.generateClientSignaturePossessionKey(masterSecretKey);
                    SecretKey signatureKnowledgeSecretKey = keyFactory.generateClientSignatureKnowledgeKey(masterSecretKey);
                    SecretKey signatureBiometrySecretKey = keyFactory.generateClientSignatureBiometryKey(masterSecretKey);
                    SecretKey transportMasterKey = keyFactory.generateServerTransportKey(masterSecretKey);
                    SecretKey vaultUnlockMasterKey = keyFactory.generateServerEncryptedVaultKey(masterSecretKey);
                    byte[] encryptedDevicePrivateKey = vault.encryptDevicePrivateKey(deviceKeyPair.getPrivate(), vaultUnlockMasterKey);
                    if (model.getPassword() == null) {
                        Console console = System.console();
                        password = console.readPassword("Select a password to encrypt the knowledge related key: ", new Object[0]);
                    } else {
                        password = model.getPassword().toCharArray();
                    }
                    byte[] salt = keyGenerator.generateRandomBytes(16);
                    byte[] cSignatureKnowledgeSecretKey = EncryptedStorageUtil.storeSignatureKnowledgeKey(password, signatureKnowledgeSecretKey, salt, keyGenerator);
                    model.getResultStatusObject().put((Object)"activationId", (Object)activationId);
                    model.getResultStatusObject().put((Object)"serverPublicKey", (Object)BaseEncoding.base64().encode(keyConversion.convertPublicKeyToBytes(serverPublicKey)));
                    model.getResultStatusObject().put((Object)"encryptedDevicePrivateKey", (Object)BaseEncoding.base64().encode(encryptedDevicePrivateKey));
                    model.getResultStatusObject().put((Object)"signaturePossessionKey", (Object)BaseEncoding.base64().encode(keyConversion.convertSharedSecretKeyToBytes(signaturePossessionSecretKey)));
                    model.getResultStatusObject().put((Object)"signatureKnowledgeKeyEncrypted", (Object)BaseEncoding.base64().encode(cSignatureKnowledgeSecretKey));
                    model.getResultStatusObject().put((Object)"signatureKnowledgeKeySalt", (Object)BaseEncoding.base64().encode(salt));
                    model.getResultStatusObject().put((Object)"signatureBiometryKey", (Object)BaseEncoding.base64().encode(keyConversion.convertSharedSecretKeyToBytes(signatureBiometrySecretKey)));
                    model.getResultStatusObject().put((Object)"transportMasterKey", (Object)BaseEncoding.base64().encode(keyConversion.convertSharedSecretKeyToBytes(transportMasterKey)));
                    model.getResultStatusObject().put((Object)"counter", (Object)0L);
                    model.getResultStatusObject().put((Object)"ctrData", null);
                    model.getResultStatusObject().put((Object)"version", (Object)2L);
                    String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatusObject());
                    try (FileWriter file = new FileWriter(model.getStatusFileName());){
                        file.write(formatted);
                    }
                    HashMap<String, String> objectMap = new HashMap<String, String>();
                    objectMap.put("activationId", activationId);
                    objectMap.put("activationStatusFile", model.getStatusFileName());
                    objectMap.put("activationStatusFileContent", (String)model.getResultStatusObject());
                    objectMap.put("deviceKeyFingerprint", activation.computeActivationFingerprint(deviceKeyPair.getPublic()));
                    if (stepLogger != null) {
                        stepLogger.writeItem("Activation Done", "Public key exchange was successfully completed, commit the activation on server if required", "OK", objectMap);
                        stepLogger.writeDoneOK();
                    }
                    return model.getResultStatusObject();
                }
                if (stepLogger != null) {
                    String message2 = "Activation data signature does not match. Either someone tried to spoof your connection, or your device master key is invalid.";
                    stepLogger.writeError(message2);
                    stepLogger.writeDoneFailed();
                }
                return null;
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError(response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError((Exception)((Object)exception));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError(exception);
                stepLogger.writeDoneFailed();
            }
            return null;
        }
    }
}

