/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.vault.PowerAuthClientVault;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesSharedInfo1;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.ActivationRecoveryStepModel;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import io.getlime.security.powerauth.rest.api.model.entity.ActivationType;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationLayer1Request;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationLayer2Request;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationLayer1Response;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationLayer2Response;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.FileWriter;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.json.simple.JSONObject;

public class ActivationRecoveryStep
implements BaseStep {
    private static final PowerAuthClientActivation activation = new PowerAuthClientActivation();
    private static final CryptoProviderUtil keyConversion = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
    private static final PowerAuthClientKeyFactory keyFactory = new PowerAuthClientKeyFactory();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientVault vault = new PowerAuthClientVault();
    private final EciesFactory eciesFactory = new EciesFactory();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        ActivationRecoveryStepModel model = new ActivationRecoveryStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("Activation With Recovery Code Started", null, "OK", null);
        }
        String uri = model.getUriString() + "/pa/v3/activation/create";
        Map<String, String> identityAttributes = model.getIdentityAttributes();
        if (stepLogger != null) {
            stepLogger.writeItem("Identity Attributes", "Following attributes are used to authenticate user", "OK", identityAttributes);
        }
        Map<String, Object> customAttributes = model.getCustomAttributes();
        if (stepLogger != null) {
            stepLogger.writeItem("Custom Attributes", "Following attributes are used as custom attributes for the request", "OK", customAttributes);
        }
        String applicationKey = model.getApplicationKey();
        byte[] applicationSecret = model.getApplicationSecret().getBytes(StandardCharsets.UTF_8);
        KeyPair deviceKeyPair = activation.generateDeviceKeyPair();
        byte[] devicePublicKeyBytes = keyConversion.convertPublicKeyToBytes(deviceKeyPair.getPublic());
        String devicePublicKeyBase64 = BaseEncoding.base64().encode(devicePublicKeyBytes);
        ActivationLayer2Request requestL2 = new ActivationLayer2Request();
        requestL2.setActivationName(model.getActivationName());
        requestL2.setDevicePublicKey(devicePublicKeyBase64);
        boolean useIv = !"3.0".equals(model.getVersion());
        EciesEncryptor eciesEncryptorL2 = this.eciesFactory.getEciesEncryptorForApplication((ECPublicKey)model.getMasterPublicKey(), applicationSecret, EciesSharedInfo1.ACTIVATION_LAYER_2);
        ByteArrayOutputStream baosL2 = new ByteArrayOutputStream();
        mapper.writeValue((OutputStream)baosL2, (Object)requestL2);
        EciesCryptogram eciesCryptogramL2 = eciesEncryptorL2.encryptRequest(baosL2.toByteArray(), useIv);
        EciesEncryptedRequest encryptedRequestL2 = new EciesEncryptedRequest();
        encryptedRequestL2.setEphemeralPublicKey(BaseEncoding.base64().encode(eciesCryptogramL2.getEphemeralPublicKey()));
        encryptedRequestL2.setEncryptedData(BaseEncoding.base64().encode(eciesCryptogramL2.getEncryptedData()));
        encryptedRequestL2.setMac(BaseEncoding.base64().encode(eciesCryptogramL2.getMac()));
        encryptedRequestL2.setNonce(useIv ? BaseEncoding.base64().encode(eciesCryptogramL2.getNonce()) : null);
        ActivationLayer1Request requestL1 = new ActivationLayer1Request();
        requestL1.setType(ActivationType.RECOVERY);
        requestL1.setActivationData(encryptedRequestL2);
        requestL1.setIdentityAttributes(identityAttributes);
        requestL1.setCustomAttributes(customAttributes);
        if (stepLogger != null) {
            stepLogger.writeItem("Building activation request object", "Following activation attributes will be encrypted and sent to the server", "OK", requestL1);
        }
        EciesEncryptor eciesEncryptorL1 = this.eciesFactory.getEciesEncryptorForApplication((ECPublicKey)model.getMasterPublicKey(), applicationSecret, EciesSharedInfo1.APPLICATION_SCOPE_GENERIC);
        ByteArrayOutputStream baosL1 = new ByteArrayOutputStream();
        mapper.writeValue((OutputStream)baosL1, (Object)requestL1);
        EciesCryptogram eciesCryptogramL1 = eciesEncryptorL1.encryptRequest(baosL1.toByteArray(), useIv);
        EciesEncryptedRequest encryptedRequestL1 = new EciesEncryptedRequest();
        encryptedRequestL1.setEphemeralPublicKey(BaseEncoding.base64().encode(eciesCryptogramL1.getEphemeralPublicKey()));
        encryptedRequestL1.setEncryptedData(BaseEncoding.base64().encode(eciesCryptogramL1.getEncryptedData()));
        encryptedRequestL1.setMac(BaseEncoding.base64().encode(eciesCryptogramL1.getMac()));
        encryptedRequestL1.setNonce(useIv ? BaseEncoding.base64().encode(eciesCryptogramL1.getNonce()) : null);
        PowerAuthEncryptionHttpHeader header = new PowerAuthEncryptionHttpHeader(applicationKey, model.getVersion());
        String httpEncryptionHeader = header.buildHttpHeader();
        try {
            HttpResponse response;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Encryption", httpEncryptionHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall(uri, "POST", encryptedRequestL1, headers);
            }
            if ((response = Unirest.post((String)uri).headers(headers).body((Object)encryptedRequestL1).asString()).getStatus() == 200) {
                char[] password;
                EciesEncryptedResponse encryptedResponseL1 = (EciesEncryptedResponse)mapper.readValue(response.getRawBody(), EciesEncryptedResponse.class);
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK(encryptedResponseL1, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                }
                byte[] macL1 = BaseEncoding.base64().decode((CharSequence)encryptedResponseL1.getMac());
                byte[] encryptedDataL1 = BaseEncoding.base64().decode((CharSequence)encryptedResponseL1.getEncryptedData());
                EciesCryptogram responseCryptogramL1 = new EciesCryptogram(macL1, encryptedDataL1);
                byte[] decryptedDataL1 = eciesEncryptorL1.decryptResponse(responseCryptogramL1);
                ActivationLayer1Response responseL1 = (ActivationLayer1Response)mapper.readValue(decryptedDataL1, ActivationLayer1Response.class);
                if (stepLogger != null) {
                    stepLogger.writeItem("Decrypted Layer 1 Response", "Following layer 1 activation data were decrypted", "OK", responseL1);
                }
                byte[] macL2 = BaseEncoding.base64().decode((CharSequence)responseL1.getActivationData().getMac());
                byte[] encryptedDataL2 = BaseEncoding.base64().decode((CharSequence)responseL1.getActivationData().getEncryptedData());
                EciesCryptogram responseCryptogramL2 = new EciesCryptogram(macL2, encryptedDataL2);
                byte[] decryptedDataL2 = eciesEncryptorL2.decryptResponse(responseCryptogramL2);
                ActivationLayer2Response responseL2 = (ActivationLayer2Response)mapper.readValue(decryptedDataL2, ActivationLayer2Response.class);
                if (stepLogger != null) {
                    stepLogger.writeItem("Decrypted Layer 2 Response", "Following layer 2 activation data were decrypted", "OK", responseL2);
                }
                String activationId = responseL2.getActivationId();
                String ctrDataBase64 = responseL2.getCtrData();
                String serverPublicKeyBase64 = responseL2.getServerPublicKey();
                PublicKey serverPublicKey = keyConversion.convertBytesToPublicKey(BaseEncoding.base64().decode((CharSequence)serverPublicKeyBase64));
                SecretKey masterSecretKey = keyFactory.generateClientMasterSecretKey(deviceKeyPair.getPrivate(), serverPublicKey);
                SecretKey signaturePossessionSecretKey = keyFactory.generateClientSignaturePossessionKey(masterSecretKey);
                SecretKey signatureKnowledgeSecretKey = keyFactory.generateClientSignatureKnowledgeKey(masterSecretKey);
                SecretKey signatureBiometrySecretKey = keyFactory.generateClientSignatureBiometryKey(masterSecretKey);
                SecretKey transportMasterKey = keyFactory.generateServerTransportKey(masterSecretKey);
                SecretKey vaultUnlockMasterKey = keyFactory.generateServerEncryptedVaultKey(masterSecretKey);
                byte[] encryptedDevicePrivateKey = vault.encryptDevicePrivateKey(deviceKeyPair.getPrivate(), vaultUnlockMasterKey);
                if (model.getPassword() == null) {
                    Console console = System.console();
                    password = console.readPassword("Select a password to encrypt the knowledge related key: ", new Object[0]);
                } else {
                    password = model.getPassword().toCharArray();
                }
                byte[] salt = keyGenerator.generateRandomBytes(16);
                byte[] cSignatureKnowledgeSecretKey = EncryptedStorageUtil.storeSignatureKnowledgeKey(password, signatureKnowledgeSecretKey, salt, keyGenerator);
                model.getResultStatusObject().put((Object)"activationId", (Object)activationId);
                model.getResultStatusObject().put((Object)"serverPublicKey", (Object)BaseEncoding.base64().encode(keyConversion.convertPublicKeyToBytes(serverPublicKey)));
                model.getResultStatusObject().put((Object)"encryptedDevicePrivateKey", (Object)BaseEncoding.base64().encode(encryptedDevicePrivateKey));
                model.getResultStatusObject().put((Object)"signaturePossessionKey", (Object)BaseEncoding.base64().encode(keyConversion.convertSharedSecretKeyToBytes(signaturePossessionSecretKey)));
                model.getResultStatusObject().put((Object)"signatureKnowledgeKeyEncrypted", (Object)BaseEncoding.base64().encode(cSignatureKnowledgeSecretKey));
                model.getResultStatusObject().put((Object)"signatureKnowledgeKeySalt", (Object)BaseEncoding.base64().encode(salt));
                model.getResultStatusObject().put((Object)"signatureBiometryKey", (Object)BaseEncoding.base64().encode(keyConversion.convertSharedSecretKeyToBytes(signatureBiometrySecretKey)));
                model.getResultStatusObject().put((Object)"transportMasterKey", (Object)BaseEncoding.base64().encode(keyConversion.convertSharedSecretKeyToBytes(transportMasterKey)));
                model.getResultStatusObject().put((Object)"counter", (Object)0L);
                model.getResultStatusObject().put((Object)"ctrData", (Object)ctrDataBase64);
                model.getResultStatusObject().put((Object)"version", (Object)3L);
                String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatusObject());
                try (FileWriter file = new FileWriter(model.getStatusFileName());){
                    file.write(formatted);
                }
                HashMap<String, String> objectMap = new HashMap<String, String>();
                objectMap.put("activationId", activationId);
                objectMap.put("activationStatusFile", model.getStatusFileName());
                objectMap.put("activationStatusFileContent", (String)model.getResultStatusObject());
                objectMap.put("deviceKeyFingerprint", activation.computeActivationFingerprint(deviceKeyPair.getPublic(), serverPublicKey, activationId));
                if (stepLogger != null) {
                    stepLogger.writeItem("Activation Done", "Public key exchange was successfully completed, commit the activation on server if required", "OK", objectMap);
                    stepLogger.writeDoneOK();
                }
                return model.getResultStatusObject();
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError(response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError((Exception)((Object)exception));
                stepLogger.writeDoneFailed();
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError(exception);
                stepLogger.writeDoneFailed();
            }
            return null;
        }
    }
}

