/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.util;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.http.PowerAuthRequestCanonizationUtils;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.model.VerifySignatureStepModel;
import java.io.Console;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class VerifySignatureUtil {
    public static byte[] extractRequestDataBytes(VerifySignatureStepModel model, StepLogger stepLogger) throws URISyntaxException, IOException {
        byte[] dataFileBytes;
        if ("GET".equals(model.getHttpMethod().toUpperCase())) {
            String query = new URI(model.getUriString()).getRawQuery();
            String canonizedQuery = PowerAuthRequestCanonizationUtils.canonizeGetParameters((String)query);
            if (canonizedQuery != null) {
                dataFileBytes = canonizedQuery.getBytes(StandardCharsets.UTF_8);
                if (stepLogger != null) {
                    stepLogger.writeItem("Normalized GET data", "GET query data were normalized into the canonical string.", "OK", canonizedQuery);
                }
            } else {
                dataFileBytes = new byte[]{};
                if (stepLogger != null) {
                    stepLogger.writeItem("Empty data", "No GET query parameters found in provided URL, signature will contain no data", "WARNING", null);
                }
            }
        } else if (model.getDataFileName() != null && Files.exists(Paths.get(model.getDataFileName(), new String[0]), new LinkOption[0])) {
            dataFileBytes = Files.readAllBytes(Paths.get(model.getDataFileName(), new String[0]));
            if (stepLogger != null) {
                stepLogger.writeItem("Request payload", "Data from the request payload file, used as the POST / DELETE / ... method body, encoded as Base64.", "OK", BaseEncoding.base64().encode(dataFileBytes));
            }
        } else {
            dataFileBytes = new byte[]{};
            if (stepLogger != null) {
                stepLogger.writeItem("Empty data", "Data file was not found, signature will contain no data", "WARNING", null);
            }
        }
        return dataFileBytes;
    }

    public static char[] getKnowledgeKeyPassword(VerifySignatureStepModel model) {
        char[] password;
        if (model.getPassword() == null) {
            Console console = System.console();
            password = console.readPassword("Enter your password to unlock the knowledge related key: ", new Object[0]);
        } else {
            password = model.getPassword().toCharArray();
        }
        return password;
    }
}

