/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.signature.PowerAuthClientSignature;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureFormat;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.VerifySignatureStepModel;
import io.getlime.security.powerauth.lib.cmd.util.CounterUtil;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.JsonUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.VerifySignatureUtil;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.json.simple.JSONObject;

public class VerifySignatureStep
implements BaseStep {
    private static final KeyConvertor keyConvertor = new KeyConvertor();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientSignature signature = new PowerAuthClientSignature();
    private static final PowerAuthClientKeyFactory keyFactory = new PowerAuthClientKeyFactory();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        VerifySignatureStepModel model = new VerifySignatureStepModel();
        model.fromMap(context);
        this.logStart(stepLogger);
        String activationId = JsonUtil.stringValue(model.getResultStatusObject(), "activationId");
        long counter = JsonUtil.longValue(model.getResultStatusObject(), "counter");
        byte[] signaturePossessionKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signaturePossessionKey"));
        byte[] signatureBiometryKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signatureBiometryKey"));
        byte[] signatureKnowledgeKeySalt = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signatureKnowledgeKeySalt"));
        byte[] signatureKnowledgeKeyEncryptedBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signatureKnowledgeKeyEncrypted"));
        char[] password = VerifySignatureUtil.getKnowledgeKeyPassword(model);
        SecretKey signaturePossessionKey = keyConvertor.convertBytesToSharedSecretKey(signaturePossessionKeyBytes);
        SecretKey signatureKnowledgeKey = EncryptedStorageUtil.getSignatureKnowledgeKey(password, signatureKnowledgeKeyEncryptedBytes, signatureKnowledgeKeySalt, keyGenerator);
        SecretKey signatureBiometryKey = keyConvertor.convertBytesToSharedSecretKey(signatureBiometryKeyBytes);
        byte[] nonceBytes = keyGenerator.generateRandomBytes(16);
        byte[] dataFileBytes = VerifySignatureUtil.extractRequestDataBytes(model, stepLogger);
        String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)model.getHttpMethod().toUpperCase(), (String)model.getResourceId(), (byte[])nonceBytes, (byte[])dataFileBytes) + "&" + model.getApplicationSecret();
        byte[] ctrData = CounterUtil.getCtrData(model, stepLogger);
        PowerAuthSignatureFormat signatureFormat = PowerAuthSignatureFormat.getFormatForSignatureVersion((String)model.getVersion());
        String signatureValue = signature.signatureForData(signatureBaseString.getBytes(StandardCharsets.UTF_8), keyFactory.keysForSignatureType(model.getSignatureType(), signaturePossessionKey, signatureKnowledgeKey, signatureBiometryKey), ctrData, signatureFormat);
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader(activationId, model.getApplicationKey(), signatureValue, model.getSignatureType().toString(), BaseEncoding.base64().encode(nonceBytes), model.getVersion());
        String httpAuthorizationHeader = header.buildHttpHeader();
        if (stepLogger != null) {
            HashMap<String, String> lowLevelData = new HashMap<String, String>();
            lowLevelData.put("counter", String.valueOf(counter));
            int version = JsonUtil.intValue(model.getResultStatusObject(), "version");
            if (version == 3) {
                lowLevelData.put("ctrData", BaseEncoding.base64().encode(ctrData));
            }
            lowLevelData.put("signatureBaseString", signatureBaseString);
            lowLevelData.put("resourceId", model.getResourceId());
            lowLevelData.put("nonce", BaseEncoding.base64().encode(nonceBytes));
            lowLevelData.put("applicationSecret", model.getApplicationSecret());
            stepLogger.writeItem("signature-verify-prepare-request", "Signature Calculation Parameters", "Low level cryptographic inputs required to compute signature - mainly a signature base string and a counter value.", "OK", lowLevelData);
        }
        CounterUtil.incrementCounter(model);
        String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatusObject());
        try (FileWriter file = new FileWriter(model.getStatusFileName());){
            file.write(formatted);
        }
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Authorization", httpAuthorizationHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall("signature-verify-request-sent", model.getUriString(), model.getHttpMethod().toUpperCase(), new String(dataFileBytes, StandardCharsets.UTF_8), headers);
            }
            if (!model.isDryRun()) {
                boolean success = this.executeRequest(model.getHttpMethod().toUpperCase(), headers, model.getUriString(), dataFileBytes, stepLogger);
                if (success) {
                    return model.getResultStatusObject();
                }
                return null;
            }
            this.logSignatureComputed(stepLogger);
            return model.getResultStatusObject();
        }
        catch (UnirestException exception) {
            this.logException("signature-verify-error-connection", (Exception)((Object)exception), stepLogger);
            return null;
        }
        catch (Exception exception) {
            this.logException("signature-verify-error-generic", exception, stepLogger);
            return null;
        }
    }

    private void logStart(StepLogger stepLogger) {
        if (stepLogger != null) {
            stepLogger.writeItem("signature-verify-start", "Signature Validation Started", null, "OK", null);
        }
    }

    private void logException(String id, Exception exception, StepLogger stepLogger) {
        if (stepLogger != null) {
            stepLogger.writeError(id, exception);
            stepLogger.writeDoneFailed("signature-verify-failed");
        }
    }

    private void logSignatureComputed(StepLogger stepLogger) {
        if (stepLogger != null) {
            stepLogger.writeItem("signature-verify-signature-computed", "Signature computed", "Activation signature header was computed successfully", "OK", null);
            stepLogger.writeDoneOK("signature-verify-success");
        }
    }

    private boolean executeRequest(String method, Map<String, String> headers, String uri, byte[] data, StepLogger stepLogger) throws JsonProcessingException {
        HttpResponse response = "GET".equals(method) ? ((GetRequest)Unirest.get((String)uri).headers(headers)).asString() : ((HttpRequestWithBody)Unirest.post((String)uri).headers(headers)).body(data).asString();
        if (response.getStatus() == 200) {
            TypeReference<ObjectResponse<Map<String, Object>>> typeReference = new TypeReference<ObjectResponse<Map<String, Object>>>(){};
            Response responseWrapper = (Response)RestClientConfiguration.defaultMapper().readValue((String)response.getBody(), (TypeReference)typeReference);
            if (stepLogger != null) {
                stepLogger.writeServerCallOK("signature-verify-response-received", responseWrapper, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeItem("signature-verify-signature-verified", "Signature verified", "Activation signature was verified successfully", "OK", null);
                stepLogger.writeDoneOK("signature-verify-success");
            }
            return true;
        }
        if (stepLogger != null) {
            stepLogger.writeServerCallError("signature-verify-error-server-call", response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
            stepLogger.writeDoneFailed("signature-verify-failed");
        }
        return false;
    }
}

