/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.client.token.ClientTokenGenerator;
import io.getlime.security.powerauth.http.PowerAuthTokenHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.VerifyTokenStepModel;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.json.simple.JSONObject;

public class VerifyTokenStep
implements BaseStep {
    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        VerifyTokenStepModel model = new VerifyTokenStepModel();
        model.fromMap(context);
        this.logTokenVerificationStart(model.getTokenId(), model.getTokenSecret(), stepLogger);
        String tokenId = model.getTokenId();
        byte[] tokenSecret = BaseEncoding.base64().decode((CharSequence)model.getTokenSecret());
        ClientTokenGenerator tokenGenerator = new ClientTokenGenerator();
        byte[] tokenNonce = tokenGenerator.generateTokenNonce();
        byte[] tokenTimestamp = tokenGenerator.generateTokenTimestamp();
        byte[] tokenDigest = tokenGenerator.computeTokenDigest(tokenNonce, tokenTimestamp, tokenSecret);
        String tokenHeader = new PowerAuthTokenHttpHeader(tokenId, BaseEncoding.base64().encode(tokenDigest), BaseEncoding.base64().encode(tokenNonce), new String(tokenTimestamp, StandardCharsets.UTF_8), model.getVersion()).buildHttpHeader();
        if (model.getHttpMethod() == null) {
            if (stepLogger != null) {
                stepLogger.writeError("token-validate-error-http-method", "HTTP method not specified", "Specify HTTP method to use for sending request");
                stepLogger.writeDoneFailed("token-validate-failed");
            }
            return null;
        }
        byte[] requestDataBytes = null;
        if (!("GET".equals(model.getHttpMethod().toUpperCase()) || (requestDataBytes = model.getData()) != null && requestDataBytes.length != 0)) {
            requestDataBytes = new byte[]{};
            if (stepLogger != null) {
                stepLogger.writeItem("token-validate-warning-empty-data", "Empty data", "Data file was not found, signature will contain no data", "WARNING", null);
            }
        }
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Token", tokenHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall("token-validate-request-sent", model.getUriString(), model.getHttpMethod().toUpperCase(), requestDataBytes != null ? new String(requestDataBytes, StandardCharsets.UTF_8) : null, headers);
            }
            if (!model.isDryRun()) {
                boolean success = this.executeRequest(model.getHttpMethod().toUpperCase(), headers, model.getUriString(), requestDataBytes, stepLogger);
                if (success) {
                    return model.getResultStatusObject();
                }
                return null;
            }
            this.logTokenValueComputed(stepLogger);
            return model.getResultStatusObject();
        }
        catch (UnirestException exception) {
            this.logException("token-validate-error-server-call", (Exception)((Object)exception), stepLogger);
            return null;
        }
        catch (Exception exception) {
            this.logException("token-validate-generic", exception, stepLogger);
            return null;
        }
    }

    private void logTokenVerificationStart(String tokenId, String tokenSecret, StepLogger stepLogger) {
        if (stepLogger != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("TOKEN_ID", tokenId);
            map.put("TOKEN_SECRET", tokenSecret);
            stepLogger.writeItem("token-validate-start", "Token Digest Validation Started", null, "OK", map);
        }
    }

    private void logException(String id, Exception exception, StepLogger stepLogger) {
        if (stepLogger != null) {
            stepLogger.writeError(id, exception);
            stepLogger.writeDoneFailed("token-validate-failed");
        }
    }

    private void logTokenValueComputed(StepLogger stepLogger) {
        if (stepLogger != null) {
            stepLogger.writeItem("token-validate-token-computed", "Token value computed", "Token value header was computed successfully", "OK", null);
            stepLogger.writeDoneOK("token-validate-success");
        }
    }

    private boolean executeRequest(String method, Map<String, String> headers, String uri, byte[] data, StepLogger stepLogger) throws JsonProcessingException {
        HttpResponse response = "GET".equals(method) ? ((GetRequest)Unirest.get((String)uri).headers(headers)).asString() : ((HttpRequestWithBody)Unirest.post((String)uri).headers(headers)).body(data).asString();
        if (response.getStatus() == 200) {
            TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>(){};
            Map responseWrapper = (Map)RestClientConfiguration.defaultMapper().readValue((String)response.getBody(), (TypeReference)typeReference);
            if (stepLogger != null) {
                stepLogger.writeServerCallOK("token-validate-response-received", responseWrapper, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeItem("token-validate-digest-verified", "Token digest verified", "Token based authentication was successful", "OK", null);
                stepLogger.writeDoneOK("token-validate-success");
            }
            return true;
        }
        if (stepLogger != null) {
            stepLogger.writeServerCallError("token-validate-error-server-call", response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
            stepLogger.writeDoneFailed("token-validate-failed");
        }
        return false;
    }
}

