/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.io.BaseEncoding;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.client.encryptor.ClientNonPersonalizedEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.NonPersonalizedEncryptedMessage;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.EncryptStepModel;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.rest.api.model.entity.NonPersonalizedEncryptedPayloadModel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.json.simple.JSONObject;

public class EncryptStep
implements BaseStep {
    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        EncryptStepModel model = new EncryptStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("encrypt-start", "Encrypt Request Started", null, "OK", null);
        }
        String uri = model.getUriString();
        byte[] requestDataBytes = model.getData();
        if (requestDataBytes == null) {
            if (stepLogger != null) {
                stepLogger.writeError("encrypt-error-data-file", "Encrypt Request Failed", "Request data for encryption was null.");
                stepLogger.writeDoneFailed("encrypt-failed");
            }
            return null;
        }
        ClientNonPersonalizedEncryptor encryptor = new ClientNonPersonalizedEncryptor(BaseEncoding.base64().decode((CharSequence)model.getApplicationKey()), model.getMasterPublicKey());
        NonPersonalizedEncryptedMessage encryptedMessage = encryptor.encrypt(requestDataBytes);
        if (encryptedMessage == null) {
            if (stepLogger != null) {
                stepLogger.writeError("encrypt-error-missing-message", "Encryption failed", "Encrypted message is not available");
                stepLogger.writeDoneFailed("encrypt-failed");
            }
            return null;
        }
        NonPersonalizedEncryptedPayloadModel encryptedRequestObject = new NonPersonalizedEncryptedPayloadModel();
        encryptedRequestObject.setAdHocIndex(BaseEncoding.base64().encode(encryptedMessage.getAdHocIndex()));
        encryptedRequestObject.setApplicationKey(BaseEncoding.base64().encode(encryptedMessage.getApplicationKey()));
        encryptedRequestObject.setEncryptedData(BaseEncoding.base64().encode(encryptedMessage.getEncryptedData()));
        encryptedRequestObject.setEphemeralPublicKey(BaseEncoding.base64().encode(encryptedMessage.getEphemeralPublicKey()));
        encryptedRequestObject.setMac(BaseEncoding.base64().encode(encryptedMessage.getMac()));
        encryptedRequestObject.setMacIndex(BaseEncoding.base64().encode(encryptedMessage.getMacIndex()));
        encryptedRequestObject.setNonce(BaseEncoding.base64().encode(encryptedMessage.getNonce()));
        encryptedRequestObject.setSessionIndex(BaseEncoding.base64().encode(encryptedMessage.getSessionIndex()));
        ObjectRequest body = new ObjectRequest();
        body.setRequestObject((Object)encryptedRequestObject);
        if (stepLogger != null) {
            stepLogger.writeItem("encrypt-request-encrypt", "Encrypting request data", "Following data is sent to intermediate server", "OK", body);
        }
        try {
            HttpResponse response;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall("encrypt-request-sent", uri, "POST", body, headers);
            }
            if ((response = ((HttpRequestWithBody)Unirest.post((String)uri).headers(headers)).body((Object)body).asString()).getStatus() == 200) {
                TypeReference<ObjectResponse<NonPersonalizedEncryptedPayloadModel>> typeReference = new TypeReference<ObjectResponse<NonPersonalizedEncryptedPayloadModel>>(){};
                ObjectResponse responseWrapper = (ObjectResponse)RestClientConfiguration.defaultMapper().readValue((String)response.getBody(), (TypeReference)typeReference);
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK("encrypt-response-received", responseWrapper, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                }
                NonPersonalizedEncryptedPayloadModel encryptedResponseObject = (NonPersonalizedEncryptedPayloadModel)responseWrapper.getResponseObject();
                encryptedMessage.setApplicationKey(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getApplicationKey()));
                encryptedMessage.setAdHocIndex(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getAdHocIndex()));
                encryptedMessage.setEphemeralPublicKey(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getEphemeralPublicKey()));
                encryptedMessage.setEncryptedData(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getEncryptedData()));
                encryptedMessage.setMac(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getMac()));
                encryptedMessage.setMacIndex(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getMacIndex()));
                encryptedMessage.setNonce(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getNonce()));
                encryptedMessage.setSessionIndex(BaseEncoding.base64().decode((CharSequence)encryptedResponseObject.getSessionIndex()));
                byte[] decryptedMessageBytes = encryptor.decrypt(encryptedMessage);
                if (decryptedMessageBytes == null) {
                    if (stepLogger != null) {
                        stepLogger.writeError("encrypt-error-decrypt", "Decryption failed", "Decrypted message is not available");
                        stepLogger.writeDoneFailed("encrypt-failed");
                    }
                    return null;
                }
                String decryptedMessage = new String(decryptedMessageBytes, StandardCharsets.UTF_8);
                model.getResultStatusObject().put((Object)"responseData", (Object)decryptedMessage);
                if (stepLogger != null) {
                    stepLogger.writeItem("encrypt-response-decrypt", "Decrypted response", "Following data were decrypted", "OK", decryptedMessage);
                    stepLogger.writeDoneOK("encrypt-success");
                }
                return model.getResultStatusObject();
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError("encrypt-error-server-call", response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed("encrypt-failed");
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError("encrypt-error-connection", (Exception)((Object)exception));
                stepLogger.writeDoneFailed("encrypt-failed");
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError("encrypt-error-generic", exception);
                stepLogger.writeDoneFailed("encrypt-failed");
            }
            return null;
        }
    }
}

