/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.client.signature.PowerAuthClientSignature;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesSharedInfo1;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureFormat;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.ConfirmRecoveryCodeStepModel;
import io.getlime.security.powerauth.lib.cmd.util.CounterUtil;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.JsonUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.rest.api.model.request.v3.ConfirmRecoveryRequestPayload;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.ConfirmRecoveryResponsePayload;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.io.Console;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.json.simple.JSONObject;

public class ConfirmRecoveryCodeStep
implements BaseStep {
    private static final KeyConvertor keyConversion = new KeyConvertor();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientSignature signature = new PowerAuthClientSignature();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();
    private static final EciesFactory eciesFactory = new EciesFactory();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        char[] password;
        ConfirmRecoveryCodeStepModel model = new ConfirmRecoveryCodeStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("recovery-confirm", "Confirm Recovery Code Started", null, "OK", null);
        }
        String activationId = JsonUtil.stringValue(model.getResultStatusObject(), "activationId");
        byte[] signaturePossessionKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signaturePossessionKey"));
        byte[] signatureKnowledgeKeySalt = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signatureKnowledgeKeySalt"));
        byte[] signatureKnowledgeKeyEncryptedBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signatureKnowledgeKeyEncrypted"));
        if (model.getPassword() == null) {
            Console console = System.console();
            password = console.readPassword("Enter your password to unlock the knowledge related key: ", new Object[0]);
        } else {
            password = model.getPassword().toCharArray();
        }
        SecretKey signaturePossessionKey = keyConversion.convertBytesToSharedSecretKey(signaturePossessionKeyBytes);
        SecretKey signatureKnowledgeKey = EncryptedStorageUtil.getSignatureKnowledgeKey(password, signatureKnowledgeKeyEncryptedBytes, signatureKnowledgeKeySalt, keyGenerator);
        byte[] nonceBytes = keyGenerator.generateRandomBytes(16);
        String uri = model.getUriString() + "/pa/v3/recovery/confirm";
        boolean useIv = !"3.0".equals(model.getVersion());
        byte[] applicationSecret = model.getApplicationSecret().getBytes(StandardCharsets.UTF_8);
        byte[] transportMasterKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "transportMasterKey"));
        byte[] serverPublicKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "serverPublicKey"));
        ECPublicKey serverPublicKey = (ECPublicKey)keyConversion.convertBytesToPublicKey(serverPublicKeyBytes);
        EciesEncryptor encryptor = eciesFactory.getEciesEncryptorForActivation(serverPublicKey, applicationSecret, transportMasterKeyBytes, EciesSharedInfo1.CONFIRM_RECOVERY_CODE);
        ConfirmRecoveryRequestPayload confirmRequestPayload = new ConfirmRecoveryRequestPayload();
        confirmRequestPayload.setRecoveryCode(model.getRecoveryCode());
        byte[] requestBytesPayload = RestClientConfiguration.defaultMapper().writeValueAsBytes((Object)confirmRequestPayload);
        EciesCryptogram eciesCryptogram = encryptor.encryptRequest(requestBytesPayload, useIv);
        EciesEncryptedRequest request = new EciesEncryptedRequest();
        String ephemeralPublicKeyBase64 = BaseEncoding.base64().encode(eciesCryptogram.getEphemeralPublicKey());
        String encryptedData = BaseEncoding.base64().encode(eciesCryptogram.getEncryptedData());
        String mac = BaseEncoding.base64().encode(eciesCryptogram.getMac());
        String nonce = useIv ? BaseEncoding.base64().encode(eciesCryptogram.getNonce()) : null;
        request.setEphemeralPublicKey(ephemeralPublicKeyBase64);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        byte[] requestBytes = RestClientConfiguration.defaultMapper().writeValueAsBytes((Object)request);
        String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/recovery/confirm", (byte[])nonceBytes, (byte[])requestBytes) + "&" + model.getApplicationSecret();
        byte[] ctrData = CounterUtil.getCtrData(model, stepLogger);
        PowerAuthSignatureFormat signatureFormat = PowerAuthSignatureFormat.getFormatForSignatureVersion((String)model.getVersion());
        String signatureValue = signature.signatureForData(signatureBaseString.getBytes(StandardCharsets.UTF_8), Arrays.asList(signaturePossessionKey, signatureKnowledgeKey), ctrData, signatureFormat);
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader(activationId, model.getApplicationKey(), signatureValue, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE.toString(), BaseEncoding.base64().encode(nonceBytes), model.getVersion());
        String httpAuthorizationHeader = header.buildHttpHeader();
        CounterUtil.incrementCounter(model);
        String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatusObject());
        try (FileWriter file = new FileWriter(model.getStatusFileName());){
            file.write(formatted);
        }
        try {
            HttpResponse response;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Authorization", httpAuthorizationHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall("recovery-confirm-request-sent", uri, "POST", request, headers);
            }
            if ((response = ((HttpRequestWithBody)Unirest.post((String)uri).headers(headers)).body(requestBytes).asString()).getStatus() == 200) {
                EciesEncryptedResponse encryptedResponse = (EciesEncryptedResponse)RestClientConfiguration.defaultMapper().readValue((String)response.getBody(), EciesEncryptedResponse.class);
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK("recovery-confirm-response-received", encryptedResponse, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                }
                byte[] macResponse = BaseEncoding.base64().decode((CharSequence)encryptedResponse.getMac());
                byte[] encryptedDataResponse = BaseEncoding.base64().decode((CharSequence)encryptedResponse.getEncryptedData());
                EciesCryptogram eciesCryptogramResponse = new EciesCryptogram(macResponse, encryptedDataResponse);
                byte[] decryptedBytes = encryptor.decryptResponse(eciesCryptogramResponse);
                ConfirmRecoveryResponsePayload confirmResponsePayload = (ConfirmRecoveryResponsePayload)RestClientConfiguration.defaultMapper().readValue(decryptedBytes, ConfirmRecoveryResponsePayload.class);
                HashMap<String, Boolean> objectMap = new HashMap<String, Boolean>();
                objectMap.put("alreadyConfirmed", confirmResponsePayload.getAlreadyConfirmed());
                if (stepLogger != null) {
                    stepLogger.writeItem("recovery-confirm-confirmation-done", "Recovery Code Confirmed", "Recovery code was successfully confirmed", "OK", objectMap);
                    stepLogger.writeDoneOK("recovery-confirm-success");
                }
                return model.getResultStatusObject();
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError("recovery-confirm-error-server-call", response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed("recovery-confirm-failed");
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError("recovery-confirm-error-connection", (Exception)((Object)exception));
                stepLogger.writeDoneFailed("recovery-confirm-failed");
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError("recovery-confirm-error-generic", exception);
                stepLogger.writeDoneFailed("recovery-confirm-failed");
            }
            return null;
        }
    }
}

