/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.signature.PowerAuthClientSignature;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureFormat;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.RemoveTokenStepModel;
import io.getlime.security.powerauth.lib.cmd.util.CounterUtil;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.JsonUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.rest.api.model.request.v3.TokenRemoveRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.TokenRemoveResponse;
import java.io.Console;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.json.simple.JSONObject;

public class RemoveTokenStep
implements BaseStep {
    private static final KeyConvertor keyConvertor = new KeyConvertor();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientSignature signature = new PowerAuthClientSignature();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();
    private static final PowerAuthClientKeyFactory keyFactory = new PowerAuthClientKeyFactory();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        char[] password;
        RemoveTokenStepModel model = new RemoveTokenStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("token-remove-start", "Token Remove Started", null, "OK", null);
        }
        String activationId = JsonUtil.stringValue(model.getResultStatusObject(), "activationId");
        byte[] signaturePossessionKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signaturePossessionKey"));
        byte[] signatureKnowledgeKeySalt = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signatureKnowledgeKeySalt"));
        byte[] signatureKnowledgeKeyEncryptedBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signatureKnowledgeKeyEncrypted"));
        byte[] signatureBiometryKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signatureBiometryKey"));
        if (model.getPassword() == null) {
            Console console = System.console();
            password = console.readPassword("Enter your password to unlock the knowledge related key: ", new Object[0]);
        } else {
            password = model.getPassword().toCharArray();
        }
        SecretKey signaturePossessionKey = keyConvertor.convertBytesToSharedSecretKey(signaturePossessionKeyBytes);
        SecretKey signatureKnowledgeKey = EncryptedStorageUtil.getSignatureKnowledgeKey(password, signatureKnowledgeKeyEncryptedBytes, signatureKnowledgeKeySalt, keyGenerator);
        SecretKey signatureBiometryKey = keyConvertor.convertBytesToSharedSecretKey(signatureBiometryKeyBytes);
        byte[] nonceBytes = keyGenerator.generateRandomBytes(16);
        String uri = model.getUriString() + "/pa/v3/token/remove";
        TokenRemoveRequest request = new TokenRemoveRequest();
        request.setTokenId(model.getTokenId());
        ObjectRequest objectRequest = new ObjectRequest((Object)request);
        byte[] requestBytes = RestClientConfiguration.defaultMapper().writeValueAsBytes((Object)objectRequest);
        String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/token/remove", (byte[])nonceBytes, (byte[])requestBytes) + "&" + model.getApplicationSecret();
        byte[] ctrData = CounterUtil.getCtrData(model, stepLogger);
        PowerAuthSignatureFormat signatureFormat = PowerAuthSignatureFormat.getFormatForSignatureVersion((String)model.getVersion());
        String signatureValue = signature.signatureForData(signatureBaseString.getBytes(StandardCharsets.UTF_8), keyFactory.keysForSignatureType(model.getSignatureType(), signaturePossessionKey, signatureKnowledgeKey, signatureBiometryKey), ctrData, signatureFormat);
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader(activationId, model.getApplicationKey(), signatureValue, model.getSignatureType().toString(), BaseEncoding.base64().encode(nonceBytes), model.getVersion());
        String httpAuthorizationHeader = header.buildHttpHeader();
        CounterUtil.incrementCounter(model);
        String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatusObject());
        try (FileWriter file = new FileWriter(model.getStatusFileName());){
            file.write(formatted);
        }
        try {
            HttpResponse response;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Authorization", httpAuthorizationHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall("token-remove-request-sent", uri, "POST", request, headers);
            }
            if ((response = ((HttpRequestWithBody)Unirest.post((String)uri).headers(headers)).body(requestBytes).asString()).getStatus() == 200) {
                TypeReference<ObjectResponse<TokenRemoveResponse>> typeReference = new TypeReference<ObjectResponse<TokenRemoveResponse>>(){};
                ObjectResponse responseWrapper = (ObjectResponse)RestClientConfiguration.defaultMapper().readValue((String)response.getBody(), (TypeReference)typeReference);
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK("token-remove-response-received", responseWrapper, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                }
                if (stepLogger != null) {
                    stepLogger.writeItem("token-remove-token-removed", "Token successfully removed", "Token was successfully removed", "OK", ((TokenRemoveResponse)responseWrapper.getResponseObject()).getTokenId());
                    stepLogger.writeDoneOK("token-remove-success");
                }
                return model.getResultStatusObject();
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError("token-remove-error-server-call", response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed("token-remove-failed");
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError("token-remove-error-connection", (Exception)((Object)exception));
                stepLogger.writeDoneFailed("token-remove-failed");
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError("token-remove-error-generic", exception);
                stepLogger.writeDoneFailed("token-remove-failed");
            }
            return null;
        }
    }
}

