/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesSharedInfo1;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.StartUpgradeStepModel;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.JsonUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.UpgradeResponsePayload;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECPublicKey;
import java.util.HashMap;
import java.util.Map;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.json.simple.JSONObject;

public class StartUpgradeStep
implements BaseStep {
    private static final KeyConvertor keyConvertor = new KeyConvertor();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();
    private static final EciesFactory eciesFactory = new EciesFactory();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        StartUpgradeStepModel model = new StartUpgradeStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("upgrade-start-started", "Upgrade Started", null, "OK", null);
        }
        String uri = model.getUriString() + "/pa/v3/upgrade/start";
        String applicationKey = model.getApplicationKey();
        String activationId = JsonUtil.stringValue(model.getResultStatusObject(), "activationId");
        boolean useIv = !"3.0".equals(model.getVersion());
        byte[] applicationSecret = model.getApplicationSecret().getBytes(StandardCharsets.UTF_8);
        byte[] transportMasterKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "transportMasterKey"));
        byte[] serverPublicKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "serverPublicKey"));
        ECPublicKey serverPublicKey = (ECPublicKey)keyConvertor.convertBytesToPublicKey(serverPublicKeyBytes);
        EciesEncryptor encryptor = eciesFactory.getEciesEncryptorForActivation(serverPublicKey, applicationSecret, transportMasterKeyBytes, EciesSharedInfo1.UPGRADE);
        EciesCryptogram eciesCryptogram = encryptor.encryptRequest("{}".getBytes(StandardCharsets.UTF_8), useIv);
        EciesEncryptedRequest request = new EciesEncryptedRequest();
        String ephemeralPublicKeyBase64 = BaseEncoding.base64().encode(eciesCryptogram.getEphemeralPublicKey());
        String encryptedData = BaseEncoding.base64().encode(eciesCryptogram.getEncryptedData());
        String mac = BaseEncoding.base64().encode(eciesCryptogram.getMac());
        String nonce = useIv ? BaseEncoding.base64().encode(eciesCryptogram.getNonce()) : null;
        request.setEphemeralPublicKey(ephemeralPublicKeyBase64);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        byte[] requestBytes = mapper.writeValueAsBytes((Object)request);
        PowerAuthEncryptionHttpHeader header = new PowerAuthEncryptionHttpHeader(applicationKey, activationId, model.getVersion());
        String httpEncryptionHeader = header.buildHttpHeader();
        try {
            HttpResponse response;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Encryption", httpEncryptionHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall("upgrade-start-request-sent", uri, "POST", request, headers);
            }
            if ((response = ((HttpRequestWithBody)Unirest.post((String)uri).headers(headers)).body(requestBytes).asString()).getStatus() == 200) {
                EciesEncryptedResponse encryptedResponse = (EciesEncryptedResponse)mapper.readValue((String)response.getBody(), EciesEncryptedResponse.class);
                if (stepLogger != null) {
                    stepLogger.writeServerCallOK("upgrade-start-response-received", encryptedResponse, HttpUtil.flattenHttpHeaders(response.getHeaders()));
                }
                byte[] macResponse = BaseEncoding.base64().decode((CharSequence)encryptedResponse.getMac());
                byte[] encryptedDataResponse = BaseEncoding.base64().decode((CharSequence)encryptedResponse.getEncryptedData());
                EciesCryptogram eciesCryptogramResponse = new EciesCryptogram(macResponse, encryptedDataResponse);
                byte[] decryptedBytes = encryptor.decryptResponse(eciesCryptogramResponse);
                UpgradeResponsePayload upgradeResponsePayload = (UpgradeResponsePayload)mapper.readValue(decryptedBytes, UpgradeResponsePayload.class);
                model.getResultStatusObject().put((Object)"ctrData", (Object)upgradeResponsePayload.getCtrData());
                String statusFormatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatusObject());
                try (FileWriter file = new FileWriter(model.getStatusFileName());){
                    file.write(statusFormatted);
                }
                HashMap<String, String> objectMap = new HashMap<String, String>();
                objectMap.put("ctrData", upgradeResponsePayload.getCtrData());
                if (stepLogger != null) {
                    stepLogger.writeItem("upgrade-start-completed", "Upgrade start step successfully completed", "Upgrade start step was successfully completed", "OK", objectMap);
                    stepLogger.writeDoneOK("upgrade-start-success");
                }
                return model.getResultStatusObject();
            }
            if (stepLogger != null) {
                stepLogger.writeServerCallError("upgrade-start-error-server-call", response.getStatus(), response.getBody(), HttpUtil.flattenHttpHeaders(response.getHeaders()));
                stepLogger.writeDoneFailed("upgrade-start-failed");
            }
            return null;
        }
        catch (UnirestException exception) {
            if (stepLogger != null) {
                stepLogger.writeServerCallConnectionError("upgrade-start-error-connection", (Exception)((Object)exception));
                stepLogger.writeDoneFailed("upgrade-start-failed");
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError("upgrade-start-error-generic", exception);
                stepLogger.writeDoneFailed("upgrade-start-failed");
            }
            return null;
        }
    }
}

