/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import com.google.common.io.BaseEncoding;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesSharedInfo1;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.EncryptStepModel;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.JsonUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECPublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.simple.JSONObject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;

public class EncryptStep
implements BaseStep {
    private static final KeyConvertor keyConvertor = new KeyConvertor();
    private static final EciesFactory eciesFactory = new EciesFactory();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        PowerAuthEncryptionHttpHeader header;
        EciesEncryptor encryptor;
        EncryptStepModel model = new EncryptStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("encrypt-started", "Encrypt Request Started", null, "OK", null);
        }
        String uri = model.getUriString();
        byte[] requestDataBytes = model.getData();
        if (requestDataBytes == null) {
            if (stepLogger != null) {
                stepLogger.writeError("encrypt-error-file", "Encrypt Request Failed", "Request data for encryption was null.");
                stepLogger.writeDoneFailed("encrypt-failed");
            }
            return null;
        }
        if (stepLogger != null) {
            stepLogger.writeItem("encrypt-request-encrypt", "Preparing Request Data", "Following data will be encrypted", "OK", requestDataBytes);
        }
        byte[] applicationSecret = model.getApplicationSecret().getBytes(StandardCharsets.UTF_8);
        switch (model.getScope()) {
            case "application": {
                encryptor = eciesFactory.getEciesEncryptorForApplication((ECPublicKey)model.getMasterPublicKey(), applicationSecret, EciesSharedInfo1.APPLICATION_SCOPE_GENERIC);
                header = new PowerAuthEncryptionHttpHeader(model.getApplicationKey(), model.getVersion());
                break;
            }
            case "activation": {
                byte[] transportMasterKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "transportMasterKey"));
                byte[] serverPublicKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "serverPublicKey"));
                ECPublicKey serverPublicKey = (ECPublicKey)keyConvertor.convertBytesToPublicKey(serverPublicKeyBytes);
                String activationId = JsonUtil.stringValue(model.getResultStatusObject(), "activationId");
                encryptor = eciesFactory.getEciesEncryptorForActivation(serverPublicKey, applicationSecret, transportMasterKeyBytes, EciesSharedInfo1.ACTIVATION_SCOPE_GENERIC);
                header = new PowerAuthEncryptionHttpHeader(model.getApplicationKey(), activationId, model.getVersion());
                break;
            }
            default: {
                if (stepLogger != null) {
                    stepLogger.writeError("encrypt-error-scope", "Encrypt Request Failed", "Unsupported encryption scope: " + model.getScope());
                    stepLogger.writeDoneFailed("encrypt-failed");
                }
                return null;
            }
        }
        String httpEncryptionHeader = header.buildHttpHeader();
        boolean useIv = !"3.0".equals(model.getVersion());
        EciesCryptogram eciesCryptogram = encryptor.encryptRequest(requestDataBytes, useIv);
        EciesEncryptedRequest request = new EciesEncryptedRequest();
        String ephemeralPublicKeyBase64 = BaseEncoding.base64().encode(eciesCryptogram.getEphemeralPublicKey());
        String encryptedData = BaseEncoding.base64().encode(eciesCryptogram.getEncryptedData());
        String mac = BaseEncoding.base64().encode(eciesCryptogram.getMac());
        String nonce = useIv ? BaseEncoding.base64().encode(eciesCryptogram.getNonce()) : null;
        request.setEphemeralPublicKey(ephemeralPublicKeyBase64);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        byte[] requestBytes = RestClientConfiguration.defaultMapper().writeValueAsBytes((Object)request);
        if (stepLogger != null) {
            stepLogger.writeItem("encrypt-request-encrypt", "Encrypting Request Data", "Following data is sent to intermediate server", "OK", request);
        }
        try {
            ResponseEntity responseEntity;
            RestClient restClient;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Encryption", httpEncryptionHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall("encrypt-request-sent", uri, "POST", request, headers);
            }
            if ((restClient = RestClientFactory.getRestClient()) == null) {
                return null;
            }
            ParameterizedTypeReference<EciesEncryptedResponse> typeReference = new ParameterizedTypeReference<EciesEncryptedResponse>(){};
            try {
                responseEntity = restClient.post(uri, (Object)requestBytes, null, MapUtil.toMultiValueMap(headers), (ParameterizedTypeReference)typeReference);
            }
            catch (RestClientException ex) {
                if (stepLogger != null) {
                    stepLogger.writeServerCallError("encrypt-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
                    stepLogger.writeDoneFailed("encrypt-failed");
                }
                return null;
            }
            EciesEncryptedResponse encryptedResponse = Objects.requireNonNull((EciesEncryptedResponse)responseEntity.getBody());
            if (stepLogger != null) {
                stepLogger.writeServerCallOK("encrypt-response-received", encryptedResponse, HttpUtil.flattenHttpHeaders(responseEntity.getHeaders()));
            }
            byte[] macResponse = BaseEncoding.base64().decode((CharSequence)encryptedResponse.getMac());
            byte[] encryptedDataResponse = BaseEncoding.base64().decode((CharSequence)encryptedResponse.getEncryptedData());
            EciesCryptogram eciesCryptogramResponse = new EciesCryptogram(macResponse, encryptedDataResponse);
            byte[] decryptedBytes = encryptor.decryptResponse(eciesCryptogramResponse);
            String decryptedMessage = new String(decryptedBytes, StandardCharsets.UTF_8);
            model.getResultStatusObject().put((Object)"responseData", (Object)decryptedMessage);
            if (stepLogger != null) {
                stepLogger.writeItem("encrypt-response-decrypt", "Decrypted Response", "Following data were decrypted", "OK", decryptedMessage);
                stepLogger.writeDoneOK("encrypt-success");
            }
            return model.getResultStatusObject();
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError("encrypt-error-generic", exception);
                stepLogger.writeDoneFailed("encrypt-failed");
            }
            return null;
        }
    }
}

