/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v2;

import com.google.common.io.BaseEncoding;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.lib.model.ActivationStatusBlobInfo;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.model.ExtendedActivationStatusBlobInfo;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.GetStatusStepModel;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.JsonUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.ActivationStatusResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.json.simple.JSONObject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;

public class GetStatusStep
implements BaseStep {
    private static final PowerAuthClientActivation activation = new PowerAuthClientActivation();
    private static final KeyConvertor keyConvertor = new KeyConvertor();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) {
        GetStatusStepModel model = new GetStatusStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("activation-status-start", "Activation Status Check Started", null, "OK", null);
        }
        String uri = model.getUriString() + "/pa/activation/status";
        String activationId = JsonUtil.stringValue(model.getResultStatusObject(), "activationId");
        String transportMasterKeyBase64 = JsonUtil.stringValue(model.getResultStatusObject(), "transportMasterKey");
        SecretKey transportMasterKey = keyConvertor.convertBytesToSharedSecretKey(BaseEncoding.base64().decode((CharSequence)transportMasterKeyBase64));
        ActivationStatusRequest requestObject = new ActivationStatusRequest();
        requestObject.setActivationId(activationId);
        ObjectRequest body = new ObjectRequest();
        body.setRequestObject((Object)requestObject);
        try {
            ResponseEntity responseEntity;
            RestClient restClient;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall("activation-status-request-sent", uri, "POST", requestObject, headers);
            }
            if ((restClient = RestClientFactory.getRestClient()) == null) {
                return null;
            }
            ParameterizedTypeReference<ObjectResponse<ActivationStatusResponse>> typeReference = new ParameterizedTypeReference<ObjectResponse<ActivationStatusResponse>>(){};
            try {
                responseEntity = restClient.post(uri, (Object)body, null, MapUtil.toMultiValueMap(headers), (ParameterizedTypeReference)typeReference);
            }
            catch (RestClientException ex) {
                if (stepLogger != null) {
                    stepLogger.writeServerCallError("activation-status-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
                    stepLogger.writeDoneFailed("activation-status-failed");
                }
                return null;
            }
            ObjectResponse responseWrapper = Objects.requireNonNull((ObjectResponse)responseEntity.getBody());
            if (stepLogger != null) {
                stepLogger.writeServerCallOK("activation-status-response-received", responseWrapper, HttpUtil.flattenHttpHeaders(responseEntity.getHeaders()));
            }
            ActivationStatusResponse responseObject = (ActivationStatusResponse)responseWrapper.getResponseObject();
            byte[] cStatusBlob = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedStatusBlob());
            ActivationStatusBlobInfo statusBlobRaw = activation.getStatusFromEncryptedBlob(cStatusBlob, null, null, transportMasterKey);
            ExtendedActivationStatusBlobInfo statusBlob = ExtendedActivationStatusBlobInfo.copy(statusBlobRaw);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("activationId", activationId);
            objectMap.put("statusBlob", (Object)statusBlob);
            if (stepLogger != null) {
                stepLogger.writeItem("activation-status-obtained", "Activation Status", "Activation status successfully obtained", "OK", objectMap);
                stepLogger.writeDoneOK("activation-status-success");
            }
            return model.getResultStatusObject();
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError("activation-status-error-generic", exception);
                stepLogger.writeDoneFailed("activation-status-failed");
            }
            return null;
        }
    }
}

