/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.vault.PowerAuthClientVault;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.PrepareActivationStepModel;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.ActivationCreateResponse;
import java.io.Console;
import java.io.FileWriter;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import org.json.simple.JSONObject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;

public class PrepareActivationStep
implements BaseStep {
    private static final PowerAuthClientActivation activation = new PowerAuthClientActivation();
    private static final KeyConvertor keyConversion = new KeyConvertor();
    private static final PowerAuthClientKeyFactory keyFactory = new PowerAuthClientKeyFactory();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientVault vault = new PowerAuthClientVault();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        PrepareActivationStepModel model = new PrepareActivationStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("activation-create-start", "Activation Started", null, "OK", null);
        }
        String uri = model.getUriString() + "/pa/activation/create";
        Pattern p = Pattern.compile("^[A-Z2-7]{5}-[A-Z2-7]{5}-[A-Z2-7]{5}-[A-Z2-7]{5}(#.*)?$");
        Matcher m = p.matcher(model.getActivationCode());
        if (!m.find() && stepLogger != null) {
            stepLogger.writeError("activation-create-error-activation-code", "Activation failed", "Activation code has invalid format");
            stepLogger.writeDoneFailed("activation-create-failed");
            return null;
        }
        String activationIdShort = model.getActivationCode().substring(0, 11);
        String activationOTP = model.getActivationCode().substring(12, 23);
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("activationCode", model.getActivationCode());
        objectMap.put("activationIdShort", activationIdShort);
        objectMap.put("activationOtp", activationOTP);
        if (stepLogger != null) {
            stepLogger.writeItem("activation-create-activation-code-parsed", "Activation code", "Parsing activation code to short activation ID and activation OTP", "OK", objectMap);
        }
        KeyPair clientEphemeralKeyPair = keyGenerator.generateKeyPair();
        KeyPair deviceKeyPair = activation.generateDeviceKeyPair();
        byte[] nonceDeviceBytes = activation.generateActivationNonce();
        byte[] cDevicePublicKeyBytes = activation.encryptDevicePublicKey(deviceKeyPair.getPublic(), clientEphemeralKeyPair.getPrivate(), model.getMasterPublicKey(), activationOTP, activationIdShort, nonceDeviceBytes);
        byte[] signature = activation.computeApplicationSignature(activationIdShort, nonceDeviceBytes, cDevicePublicKeyBytes, BaseEncoding.base64().decode((CharSequence)model.getApplicationKey()), BaseEncoding.base64().decode((CharSequence)model.getApplicationSecret()));
        byte[] ephemeralPublicKeyBytes = keyConversion.convertPublicKeyToBytes(clientEphemeralKeyPair.getPublic());
        ActivationCreateRequest requestObject = new ActivationCreateRequest();
        requestObject.setActivationIdShort(activationIdShort);
        requestObject.setApplicationKey(model.getApplicationKey());
        requestObject.setActivationName(model.getActivationName());
        requestObject.setActivationNonce(BaseEncoding.base64().encode(nonceDeviceBytes));
        requestObject.setEphemeralPublicKey(BaseEncoding.base64().encode(ephemeralPublicKeyBytes));
        requestObject.setEncryptedDevicePublicKey(BaseEncoding.base64().encode(cDevicePublicKeyBytes));
        requestObject.setApplicationSignature(BaseEncoding.base64().encode(signature));
        ObjectRequest body = new ObjectRequest();
        body.setRequestObject((Object)requestObject);
        try {
            ResponseEntity responseEntity;
            RestClient restClient;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall("activation-create-request-sent", uri, "POST", requestObject, headers);
            }
            if ((restClient = RestClientFactory.getRestClient()) == null) {
                return null;
            }
            ParameterizedTypeReference<ObjectResponse<ActivationCreateResponse>> typeReference = new ParameterizedTypeReference<ObjectResponse<ActivationCreateResponse>>(){};
            try {
                responseEntity = restClient.post(uri, (Object)body, null, MapUtil.toMultiValueMap(headers), (ParameterizedTypeReference)typeReference);
            }
            catch (RestClientException ex) {
                if (stepLogger != null) {
                    stepLogger.writeServerCallError("activation-create-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
                    stepLogger.writeDoneFailed("activation-create-failed");
                }
                return null;
            }
            ObjectResponse responseWrapper = Objects.requireNonNull((ObjectResponse)responseEntity.getBody());
            if (stepLogger != null) {
                stepLogger.writeServerCallOK("activation-create-response-received", responseWrapper, HttpUtil.flattenHttpHeaders(responseEntity.getHeaders()));
            }
            ActivationCreateResponse responseObject = (ActivationCreateResponse)responseWrapper.getResponseObject();
            String activationId = responseObject.getActivationId();
            byte[] nonceServerBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getActivationNonce());
            byte[] cServerPubKeyBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedServerPublicKey());
            byte[] cServerPubKeySignatureBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedServerPublicKeySignature());
            byte[] ephemeralKeyBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEphemeralPublicKey());
            PublicKey ephemeralPublicKey = keyConversion.convertBytesToPublicKey(ephemeralKeyBytes);
            boolean isDataSignatureValid = activation.verifyServerDataSignature(activationId, cServerPubKeyBytes, cServerPubKeySignatureBytes, model.getMasterPublicKey());
            if (isDataSignatureValid) {
                char[] password;
                PublicKey serverPublicKey = activation.decryptServerPublicKey(cServerPubKeyBytes, deviceKeyPair.getPrivate(), ephemeralPublicKey, activationOTP, activationIdShort, nonceServerBytes);
                SecretKey masterSecretKey = keyFactory.generateClientMasterSecretKey(deviceKeyPair.getPrivate(), serverPublicKey);
                SecretKey signaturePossessionSecretKey = keyFactory.generateClientSignaturePossessionKey(masterSecretKey);
                SecretKey signatureKnowledgeSecretKey = keyFactory.generateClientSignatureKnowledgeKey(masterSecretKey);
                SecretKey signatureBiometrySecretKey = keyFactory.generateClientSignatureBiometryKey(masterSecretKey);
                SecretKey transportMasterKey = keyFactory.generateServerTransportKey(masterSecretKey);
                SecretKey vaultUnlockMasterKey = keyFactory.generateServerEncryptedVaultKey(masterSecretKey);
                byte[] encryptedDevicePrivateKey = vault.encryptDevicePrivateKey(deviceKeyPair.getPrivate(), vaultUnlockMasterKey);
                if (model.getPassword() == null) {
                    Console console = System.console();
                    password = console.readPassword("Select a password to encrypt the knowledge related key: ", new Object[0]);
                } else {
                    password = model.getPassword().toCharArray();
                }
                byte[] salt = keyGenerator.generateRandomBytes(16);
                byte[] cSignatureKnowledgeSecretKey = EncryptedStorageUtil.storeSignatureKnowledgeKey(password, signatureKnowledgeSecretKey, salt, keyGenerator);
                model.getResultStatusObject().put((Object)"activationId", (Object)activationId);
                model.getResultStatusObject().put((Object)"serverPublicKey", (Object)BaseEncoding.base64().encode(keyConversion.convertPublicKeyToBytes(serverPublicKey)));
                model.getResultStatusObject().put((Object)"encryptedDevicePrivateKey", (Object)BaseEncoding.base64().encode(encryptedDevicePrivateKey));
                model.getResultStatusObject().put((Object)"signaturePossessionKey", (Object)BaseEncoding.base64().encode(keyConversion.convertSharedSecretKeyToBytes(signaturePossessionSecretKey)));
                model.getResultStatusObject().put((Object)"signatureKnowledgeKeyEncrypted", (Object)BaseEncoding.base64().encode(cSignatureKnowledgeSecretKey));
                model.getResultStatusObject().put((Object)"signatureKnowledgeKeySalt", (Object)BaseEncoding.base64().encode(salt));
                model.getResultStatusObject().put((Object)"signatureBiometryKey", (Object)BaseEncoding.base64().encode(keyConversion.convertSharedSecretKeyToBytes(signatureBiometrySecretKey)));
                model.getResultStatusObject().put((Object)"transportMasterKey", (Object)BaseEncoding.base64().encode(keyConversion.convertSharedSecretKeyToBytes(transportMasterKey)));
                model.getResultStatusObject().put((Object)"counter", (Object)0L);
                model.getResultStatusObject().put((Object)"ctrData", null);
                model.getResultStatusObject().put((Object)"version", (Object)2L);
                String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatusObject());
                try (FileWriter file = new FileWriter(model.getStatusFileName());){
                    file.write(formatted);
                }
                objectMap = new HashMap();
                objectMap.put("activationId", activationId);
                objectMap.put("activationStatusFile", model.getStatusFileName());
                objectMap.put("activationStatusFileContent", (String)model.getResultStatusObject());
                objectMap.put("deviceKeyFingerprint", activation.computeActivationFingerprint(deviceKeyPair.getPublic()));
                if (stepLogger != null) {
                    stepLogger.writeItem("activation-create-activation-done", "Activation Done", "Public key exchange was successfully completed, commit the activation on server", "OK", objectMap);
                    stepLogger.writeDoneOK("activation-create-success");
                }
                return model.getResultStatusObject();
            }
            if (stepLogger != null) {
                String message = "Activation data signature does not match. Either someone tried to spoof your connection, or your device master key is invalid.";
                stepLogger.writeError("activation-create-activation-signature-mismatch", message);
                stepLogger.writeDoneFailed("activation-create-failed");
            }
            return null;
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError("activation-create-error-generic", exception);
                stepLogger.writeDoneFailed("activation-create-failed");
            }
            return null;
        }
    }
}

