/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.crypto.client.signature.PowerAuthClientSignature;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureFormat;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.StartUpgradeStepModel;
import io.getlime.security.powerauth.lib.cmd.util.CounterUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.JsonUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.json.simple.JSONObject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;

public class CommitUpgradeStep
implements BaseStep {
    private static final KeyConvertor keyConversion = new KeyConvertor();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientSignature signature = new PowerAuthClientSignature();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) {
        StartUpgradeStepModel model = new StartUpgradeStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("upgrade-commit-start", "Upgrade Commit Started", null, "OK", null);
        }
        String uri = model.getUriString() + "/pa/v3/upgrade/commit";
        String activationId = JsonUtil.stringValue(model.getResultStatusObject(), "activationId");
        byte[] signaturePossessionKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signaturePossessionKey"));
        SecretKey signaturePossessionKey = keyConversion.convertBytesToSharedSecretKey(signaturePossessionKeyBytes);
        try {
            ResponseEntity responseEntity;
            RestClient restClient;
            byte[] nonceBytes = keyGenerator.generateRandomBytes(16);
            String request = "{}";
            byte[] requestBytes = "{}".getBytes(StandardCharsets.UTF_8);
            model.getResultStatusObject().put((Object)"version", (Object)3L);
            String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/upgrade/commit", (byte[])nonceBytes, (byte[])requestBytes) + "&" + model.getApplicationSecret();
            byte[] ctrData = CounterUtil.getCtrData(model, stepLogger);
            PowerAuthSignatureFormat signatureFormat = PowerAuthSignatureFormat.getFormatForSignatureVersion((String)model.getVersion());
            String signatureValue = signature.signatureForData(signatureBaseString.getBytes(StandardCharsets.UTF_8), Collections.singletonList(signaturePossessionKey), ctrData, signatureFormat);
            PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader(activationId, model.getApplicationKey(), signatureValue, PowerAuthSignatureTypes.POSSESSION.toString(), BaseEncoding.base64().encode(nonceBytes), model.getVersion());
            String httpAuthorizationHeader = header.buildHttpHeader();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Authorization", httpAuthorizationHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall("upgrade-commit-request-sent", uri, "POST", "{}", headers);
            }
            if ((restClient = RestClientFactory.getRestClient()) == null) {
                return null;
            }
            ParameterizedTypeReference<Response> typeReference = new ParameterizedTypeReference<Response>(){};
            try {
                responseEntity = restClient.post(uri, (Object)requestBytes, null, MapUtil.toMultiValueMap(headers), (ParameterizedTypeReference)typeReference);
            }
            catch (RestClientException ex) {
                if (stepLogger != null) {
                    stepLogger.writeServerCallError("upgrade-commit-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
                    stepLogger.writeDoneFailed("upgrade-commit-failed");
                }
                return null;
            }
            Response commitResponse = Objects.requireNonNull((Response)responseEntity.getBody());
            if (stepLogger != null) {
                stepLogger.writeServerCallOK("upgrade-commit-response-received", commitResponse, HttpUtil.flattenHttpHeaders(responseEntity.getHeaders()));
            }
            CounterUtil.incrementCounter(model);
            String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatusObject());
            try (FileWriter file = new FileWriter(model.getStatusFileName());){
                file.write(formatted);
            }
            if (stepLogger != null) {
                stepLogger.writeItem("upgrade-commit-upgrade-done", "Upgrade commit successfully completed", "Upgrade commit was successfully completed", "OK", null);
                stepLogger.writeDoneOK("upgrade-commit-success");
            }
            return model.getResultStatusObject();
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError("upgrade-commit-error-generic", exception);
                stepLogger.writeDoneFailed("upgrade-commit-failed");
            }
            return null;
        }
    }
}

