/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.signature.PowerAuthClientSignature;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesSharedInfo1;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureFormat;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.model.VerifySignatureStepModel;
import io.getlime.security.powerauth.lib.cmd.util.CounterUtil;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.JsonUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import io.getlime.security.powerauth.lib.cmd.util.VerifySignatureUtil;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECPublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.json.simple.JSONObject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;

public class SignAndEncryptStep
implements BaseStep {
    private static final KeyConvertor keyConvertor = new KeyConvertor();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientSignature signature = new PowerAuthClientSignature();
    private static final PowerAuthClientKeyFactory keyFactory = new PowerAuthClientKeyFactory();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();
    private static final EciesFactory eciesFactory = new EciesFactory();

    @Override
    public JSONObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        VerifySignatureStepModel model = new VerifySignatureStepModel();
        model.fromMap(context);
        if (stepLogger != null) {
            stepLogger.writeItem("sign-encrypt-start", "Sign and Encrypt Request Started", null, "OK", null);
        }
        if (model.getHttpMethod() == null) {
            if (stepLogger != null) {
                stepLogger.writeError("sign-encrypt-error-http-method", "HTTP method not specified", "Specify HTTP method to use for sending request");
                stepLogger.writeDoneFailed("sign-encrypt-failed");
            }
            return null;
        }
        if (!"POST".equals(model.getHttpMethod().toUpperCase())) {
            if (stepLogger != null) {
                stepLogger.writeError("sign-encrypt-error-http-method-invalid", "Sign and Encrypt Request Failed", "Unsupported HTTP method: " + model.getHttpMethod().toUpperCase());
                stepLogger.writeDoneFailed("sign-encrypt-failed");
            }
            return null;
        }
        String uri = model.getUriString();
        byte[] requestDataBytes = model.getData();
        if (requestDataBytes == null) {
            if (stepLogger != null) {
                stepLogger.writeError("sign-encrypt-error-file", "Sign and Encrypt Request Failed", "Request data for encryption and signing is null.");
                stepLogger.writeDoneFailed("sign-encrypt-failed");
            }
            return null;
        }
        if (stepLogger != null) {
            stepLogger.writeItem("sign-encrypt-request-prepare", "Preparing Request Data", "Following data will be encrypted", "OK", requestDataBytes);
        }
        String activationId = JsonUtil.stringValue(model.getResultStatusObject(), "activationId");
        long counter = JsonUtil.longValue(model.getResultStatusObject(), "counter");
        byte[] signaturePossessionKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signaturePossessionKey"));
        byte[] signatureBiometryKeyBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signatureBiometryKey"));
        byte[] signatureKnowledgeKeySalt = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signatureKnowledgeKeySalt"));
        byte[] signatureKnowledgeKeyEncryptedBytes = BaseEncoding.base64().decode((CharSequence)JsonUtil.stringValue(model.getResultStatusObject(), "signatureKnowledgeKeyEncrypted"));
        char[] password = VerifySignatureUtil.getKnowledgeKeyPassword(model);
        SecretKey signaturePossessionKey = keyConvertor.convertBytesToSharedSecretKey(signaturePossessionKeyBytes);
        SecretKey signatureKnowledgeKey = EncryptedStorageUtil.getSignatureKnowledgeKey(password, signatureKnowledgeKeyEncryptedBytes, signatureKnowledgeKeySalt, keyGenerator);
        SecretKey signatureBiometryKey = keyConvertor.convertBytesToSharedSecretKey(signatureBiometryKeyBytes);
        byte[] nonceBytes = keyGenerator.generateRandomBytes(16);
        byte[] dataFileBytes = VerifySignatureUtil.extractRequestDataBytes(model, stepLogger);
        String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)model.getHttpMethod().toUpperCase(), (String)model.getResourceId(), (byte[])nonceBytes, (byte[])dataFileBytes) + "&" + model.getApplicationSecret();
        byte[] ctrData = CounterUtil.getCtrData(model, stepLogger);
        PowerAuthSignatureFormat signatureFormat = PowerAuthSignatureFormat.getFormatForSignatureVersion((String)model.getVersion());
        String signatureValue = signature.signatureForData(signatureBaseString.getBytes(StandardCharsets.UTF_8), keyFactory.keysForSignatureType(model.getSignatureType(), signaturePossessionKey, signatureKnowledgeKey, signatureBiometryKey), ctrData, signatureFormat);
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader(activationId, model.getApplicationKey(), signatureValue, model.getSignatureType().toString(), BaseEncoding.base64().encode(nonceBytes), model.getVersion());
        String httpAuthorizationHeader = header.buildHttpHeader();
        CounterUtil.incrementCounter(model);
        String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatusObject());
        try (FileWriter file = new FileWriter(model.getStatusFileName());){
            file.write(formatted);
        }
        String transportKeyBase64 = JsonUtil.stringValue(model.getResultStatusObject(), "transportMasterKey");
        String serverPublicKeyBase64 = JsonUtil.stringValue(model.getResultStatusObject(), "serverPublicKey");
        byte[] applicationSecret = model.getApplicationSecret().getBytes(StandardCharsets.UTF_8);
        byte[] transportMasterKeyBytes = BaseEncoding.base64().decode((CharSequence)transportKeyBase64);
        byte[] serverPublicKeyBytes = BaseEncoding.base64().decode((CharSequence)serverPublicKeyBase64);
        ECPublicKey serverPublicKey = (ECPublicKey)keyConvertor.convertBytesToPublicKey(serverPublicKeyBytes);
        EciesEncryptor encryptor = eciesFactory.getEciesEncryptorForActivation(serverPublicKey, applicationSecret, transportMasterKeyBytes, EciesSharedInfo1.ACTIVATION_SCOPE_GENERIC);
        if (stepLogger != null) {
            HashMap<String, String> lowLevelData = new HashMap<String, String>();
            lowLevelData.put("counter", String.valueOf(counter));
            int version = JsonUtil.intValue(model.getResultStatusObject(), "version");
            if (version == 3) {
                lowLevelData.put("ctrData", BaseEncoding.base64().encode(ctrData));
            }
            lowLevelData.put("signatureBaseString", signatureBaseString);
            lowLevelData.put("resourceId", model.getResourceId());
            lowLevelData.put("nonce", BaseEncoding.base64().encode(nonceBytes));
            lowLevelData.put("applicationKey", model.getApplicationKey());
            lowLevelData.put("applicationSecret", model.getApplicationSecret());
            lowLevelData.put("transportKey", transportKeyBase64);
            lowLevelData.put("serverPublicKey", serverPublicKeyBase64);
            lowLevelData.put("activationId", activationId);
            stepLogger.writeItem("sign-encrypt-signature-computed", "Signature Calculation Parameters", "Low level cryptographic inputs required to compute signature and keys used for data encryption.", "OK", lowLevelData);
        }
        boolean useIv = !"3.0".equals(model.getVersion());
        EciesCryptogram eciesCryptogram = encryptor.encryptRequest(requestDataBytes, useIv);
        EciesEncryptedRequest request = new EciesEncryptedRequest();
        String ephemeralPublicKeyBase64 = BaseEncoding.base64().encode(eciesCryptogram.getEphemeralPublicKey());
        String encryptedData = BaseEncoding.base64().encode(eciesCryptogram.getEncryptedData());
        String mac = BaseEncoding.base64().encode(eciesCryptogram.getMac());
        String nonce = useIv ? BaseEncoding.base64().encode(eciesCryptogram.getNonce()) : null;
        request.setEphemeralPublicKey(ephemeralPublicKeyBase64);
        request.setEncryptedData(encryptedData);
        request.setMac(mac);
        request.setNonce(nonce);
        byte[] requestBytes = RestClientConfiguration.defaultMapper().writeValueAsBytes((Object)request);
        if (stepLogger != null) {
            stepLogger.writeItem("sign-encrypt-request-encrypt", "Encrypting Request Data", "Following data is sent to intermediate server", "OK", request);
        }
        try {
            ResponseEntity responseEntity;
            RestClient restClient;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Authorization", httpAuthorizationHeader);
            headers.putAll(model.getHeaders());
            if (stepLogger != null) {
                stepLogger.writeServerCall("sign-encrypt-request-sent", model.getUriString(), model.getHttpMethod().toUpperCase(), new String(dataFileBytes, StandardCharsets.UTF_8), headers);
            }
            if ((restClient = RestClientFactory.getRestClient()) == null) {
                return null;
            }
            ParameterizedTypeReference<EciesEncryptedResponse> typeReference = new ParameterizedTypeReference<EciesEncryptedResponse>(){};
            try {
                responseEntity = restClient.post(uri, (Object)requestBytes, null, MapUtil.toMultiValueMap(headers), (ParameterizedTypeReference)typeReference);
            }
            catch (RestClientException ex) {
                if (stepLogger != null) {
                    stepLogger.writeServerCallError("sign-encrypt-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
                    stepLogger.writeDoneFailed("sign-encrypt-failed");
                }
                return null;
            }
            EciesEncryptedResponse encryptedResponse = Objects.requireNonNull((EciesEncryptedResponse)responseEntity.getBody());
            if (stepLogger != null) {
                stepLogger.writeServerCallOK("sign-encrypt-response-received", encryptedResponse, HttpUtil.flattenHttpHeaders(responseEntity.getHeaders()));
            }
            byte[] macResponse = BaseEncoding.base64().decode((CharSequence)encryptedResponse.getMac());
            byte[] encryptedDataResponse = BaseEncoding.base64().decode((CharSequence)encryptedResponse.getEncryptedData());
            EciesCryptogram eciesCryptogramResponse = new EciesCryptogram(macResponse, encryptedDataResponse);
            byte[] decryptedBytes = encryptor.decryptResponse(eciesCryptogramResponse);
            String decryptedMessage = new String(decryptedBytes, StandardCharsets.UTF_8);
            model.getResultStatusObject().put((Object)"responseData", (Object)decryptedMessage);
            if (stepLogger != null) {
                stepLogger.writeItem("sign-encrypt-response-decrypted", "Decrypted Response", "Following data were decrypted", "OK", decryptedMessage);
                stepLogger.writeDoneOK("sign-encrypt-success");
            }
            return model.getResultStatusObject();
        }
        catch (Exception exception) {
            if (stepLogger != null) {
                stepLogger.writeError("sign-encrypt-error-generic", exception);
                stepLogger.writeDoneFailed("sign-encrypt-failed");
            }
            return null;
        }
    }
}

