/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.header;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.client.token.ClientTokenGenerator;
import io.getlime.security.powerauth.http.PowerAuthTokenHttpHeader;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderProvider;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.TokenHeaderData;
import java.nio.charset.StandardCharsets;

public class TokenHeaderProvider
implements PowerAuthHeaderProvider<TokenHeaderData> {
    @Override
    public void addHeader(StepContext<? extends TokenHeaderData, ?> stepContext) throws Exception {
        TokenHeaderData model = stepContext.getModel();
        RequestContext requestContext = stepContext.getRequestContext();
        String tokenId = model.getTokenId();
        byte[] tokenSecret = BaseEncoding.base64().decode((CharSequence)model.getTokenSecret());
        ClientTokenGenerator tokenGenerator = new ClientTokenGenerator();
        byte[] tokenNonce = tokenGenerator.generateTokenNonce();
        byte[] tokenTimestamp = tokenGenerator.generateTokenTimestamp();
        byte[] tokenDigest = tokenGenerator.computeTokenDigest(tokenNonce, tokenTimestamp, tokenSecret);
        PowerAuthTokenHttpHeader header = new PowerAuthTokenHttpHeader(tokenId, BaseEncoding.base64().encode(tokenDigest), BaseEncoding.base64().encode(tokenNonce), new String(tokenTimestamp, StandardCharsets.UTF_8), model.getVersion().value());
        String headerValue = header.buildHttpHeader();
        requestContext.setAuthorizationHeader(headerValue);
        requestContext.setAuthorizationHeaderName("X-PowerAuth-Token");
        requestContext.getHttpHeaders().put("X-PowerAuth-Token", headerValue);
    }
}

