/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.vault.PowerAuthClientVault;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesCryptogram;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesSharedInfo1;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.security.ActivationSecurityContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.PrepareActivationStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.ActivationData;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.SecurityUtil;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationLayer1Request;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationLayer2Request;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationLayer1Response;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationLayer2Response;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.io.Console;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.springframework.core.ParameterizedTypeReference;

public abstract class AbstractActivationStep<M extends ActivationData>
extends AbstractBaseStep<M, EciesEncryptedResponse> {
    private static final PowerAuthClientActivation ACTIVATION = new PowerAuthClientActivation();
    private static final EciesFactory ECIES_FACTORY = new EciesFactory();
    private static final KeyConvertor KEY_CONVERTOR = new KeyConvertor();
    private static final PowerAuthClientKeyFactory KEY_FACTORY = new PowerAuthClientKeyFactory();
    private static final KeyGenerator KEY_GENERATOR = new KeyGenerator();
    private static final PowerAuthClientVault VAULT = new PowerAuthClientVault();
    private static final ObjectMapper MAPPER = RestClientConfiguration.defaultMapper();

    public AbstractActivationStep(PowerAuthStep step, List<PowerAuthVersion> supportedVersions, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(step, supportedVersions, resultStatusService, stepLoggerFactory);
    }

    @Override
    public void processResponse(StepContext<M, EciesEncryptedResponse> stepContext) throws Exception {
        EciesEncryptedResponse encryptedResponseL1 = stepContext.getResponseContext().getResponseBodyObject();
        ActivationData model = (ActivationData)stepContext.getModel();
        ActivationSecurityContext securityContext = (ActivationSecurityContext)stepContext.getSecurityContext();
        ResultStatusObject resultStatusObject = this.processResponse(encryptedResponseL1, stepContext);
        model.setResultStatus(resultStatusObject);
        this.resultStatusService.save(model);
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("activationId", resultStatusObject.getActivationId());
        objectMap.put("activationStatusFile", model.getStatusFileName());
        objectMap.put("activationStatusFileContent", model.getResultStatus());
        objectMap.put("deviceKeyFingerprint", ACTIVATION.computeActivationFingerprint(securityContext.getDeviceKeyPair().getPublic(), resultStatusObject.getServerPublicKeyObject(), resultStatusObject.getActivationId()));
        stepContext.getStepLogger().writeItem(this.getStep().id() + "-custom-activation-done", "Activation Done", "Public key exchange was successfully completed, commit the activation on server if required", "OK", objectMap);
    }

    public ResultStatusObject processResponse(EciesEncryptedResponse encryptedResponseL1, StepContext<M, EciesEncryptedResponse> context) throws Exception {
        char[] password;
        ActivationData model = (ActivationData)context.getModel();
        ActivationSecurityContext securityContext = (ActivationSecurityContext)context.getSecurityContext();
        byte[] macL1 = BaseEncoding.base64().decode((CharSequence)encryptedResponseL1.getMac());
        byte[] encryptedDataL1 = BaseEncoding.base64().decode((CharSequence)encryptedResponseL1.getEncryptedData());
        EciesCryptogram responseCryptogramL1 = new EciesCryptogram(macL1, encryptedDataL1);
        byte[] decryptedDataL1 = securityContext.getEncryptorL1().decryptResponse(responseCryptogramL1);
        ActivationLayer1Response responseL1 = (ActivationLayer1Response)MAPPER.readValue(decryptedDataL1, ActivationLayer1Response.class);
        context.getStepLogger().writeItem(this.getStep().id() + "-response-decrypt", "Decrypted Layer 1 Response", "Following layer 1 activation data were decrypted", "OK", responseL1);
        byte[] macL2 = BaseEncoding.base64().decode((CharSequence)responseL1.getActivationData().getMac());
        byte[] encryptedDataL2 = BaseEncoding.base64().decode((CharSequence)responseL1.getActivationData().getEncryptedData());
        EciesCryptogram responseCryptogramL2 = new EciesCryptogram(macL2, encryptedDataL2);
        byte[] decryptedDataL2 = securityContext.getEncryptorL2().decryptResponse(responseCryptogramL2);
        ActivationLayer2Response responseL2 = (ActivationLayer2Response)MAPPER.readValue(decryptedDataL2, ActivationLayer2Response.class);
        context.getStepLogger().writeItem(this.getStep().id() + "-response-decrypt-inner", "Decrypted Layer 2 Response", "Following layer 2 activation data were decrypted", "OK", responseL2);
        String activationId = responseL2.getActivationId();
        String ctrDataBase64 = responseL2.getCtrData();
        String serverPublicKeyBase64 = responseL2.getServerPublicKey();
        PublicKey serverPublicKey = KEY_CONVERTOR.convertBytesToPublicKey(BaseEncoding.base64().decode((CharSequence)serverPublicKeyBase64));
        SecretKey masterSecretKey = KEY_FACTORY.generateClientMasterSecretKey(securityContext.getDeviceKeyPair().getPrivate(), serverPublicKey);
        SecretKey signaturePossessionSecretKey = KEY_FACTORY.generateClientSignaturePossessionKey(masterSecretKey);
        SecretKey signatureKnowledgeSecretKey = KEY_FACTORY.generateClientSignatureKnowledgeKey(masterSecretKey);
        SecretKey signatureBiometrySecretKey = KEY_FACTORY.generateClientSignatureBiometryKey(masterSecretKey);
        SecretKey transportMasterKey = KEY_FACTORY.generateServerTransportKey(masterSecretKey);
        SecretKey vaultUnlockMasterKey = KEY_FACTORY.generateServerEncryptedVaultKey(masterSecretKey);
        byte[] encryptedDevicePrivateKey = VAULT.encryptDevicePrivateKey(securityContext.getDeviceKeyPair().getPrivate(), vaultUnlockMasterKey);
        if (model.getPassword() == null) {
            Console console = System.console();
            password = console.readPassword("Select a password to encrypt the knowledge related key: ", new Object[0]);
        } else {
            password = model.getPassword().toCharArray();
        }
        byte[] salt = KEY_GENERATOR.generateRandomBytes(16);
        byte[] cSignatureKnowledgeSecretKey = EncryptedStorageUtil.storeSignatureKnowledgeKey(password, signatureKnowledgeSecretKey, salt, KEY_GENERATOR);
        ResultStatusObject resultStatusObject = model.getResultStatus();
        resultStatusObject.setActivationId(activationId);
        resultStatusObject.setCounter(0L);
        resultStatusObject.setCtrData(ctrDataBase64);
        resultStatusObject.setEncryptedDevicePrivateKeyBytes(encryptedDevicePrivateKey);
        resultStatusObject.setServerPublicKeyObject(serverPublicKey);
        resultStatusObject.setSignatureBiometryKeyObject(signatureBiometrySecretKey);
        resultStatusObject.setSignatureKnowledgeKeyEncryptedBytes(cSignatureKnowledgeSecretKey);
        resultStatusObject.setSignatureKnowledgeKeySaltBytes(salt);
        resultStatusObject.setSignaturePossessionKeyObject(signaturePossessionSecretKey);
        resultStatusObject.setTransportMasterKeyObject(transportMasterKey);
        resultStatusObject.setVersion(3L);
        return resultStatusObject;
    }

    protected abstract ActivationLayer1Request prepareLayer1Request(StepContext<M, EciesEncryptedResponse> var1, EciesEncryptedRequest var2);

    @Override
    protected ParameterizedTypeReference<EciesEncryptedResponse> getResponseTypeReference() {
        return PowerAuthConst.RESPONSE_TYPE_REFERENCE_V3;
    }

    protected void addEncryptedRequest(StepContext<M, EciesEncryptedResponse> stepContext) throws Exception {
        Map<String, Object> customAttributes;
        ActivationData model = (ActivationData)stepContext.getModel();
        byte[] applicationSecret = model.getApplicationSecret().getBytes(StandardCharsets.UTF_8);
        EciesEncryptor eciesEncryptorL1 = ECIES_FACTORY.getEciesEncryptorForApplication((ECPublicKey)model.getMasterPublicKey(), applicationSecret, EciesSharedInfo1.APPLICATION_SCOPE_GENERIC);
        EciesEncryptor eciesEncryptorL2 = ECIES_FACTORY.getEciesEncryptorForApplication((ECPublicKey)model.getMasterPublicKey(), applicationSecret, EciesSharedInfo1.ACTIVATION_LAYER_2);
        KeyPair deviceKeyPair = ACTIVATION.generateDeviceKeyPair();
        ActivationSecurityContext securityContext = ActivationSecurityContext.builder().encryptorL1(eciesEncryptorL1).encryptorL2(eciesEncryptorL2).deviceKeyPair(deviceKeyPair).build();
        stepContext.setSecurityContext(securityContext);
        Map<String, String> identityAttributes = model.getIdentityAttributes();
        if (identityAttributes != null && !identityAttributes.isEmpty()) {
            stepContext.getStepLogger().writeItem(this.getStep().id() + "-identity-attributes", "Identity Attributes", "Following attributes are used to authenticate user", "OK", identityAttributes);
        }
        if ((customAttributes = model.getCustomAttributes()) != null && !customAttributes.isEmpty()) {
            stepContext.getStepLogger().writeItem(this.getStep().id() + "-custom-attributes", "Custom Attributes", "Following attributes are used as custom attributes for the request", "OK", customAttributes);
        }
        byte[] devicePublicKeyBytes = KEY_CONVERTOR.convertPublicKeyToBytes(securityContext.getDeviceKeyPair().getPublic());
        String devicePublicKeyBase64 = BaseEncoding.base64().encode(devicePublicKeyBytes);
        ActivationLayer2Request requestL2 = new ActivationLayer2Request();
        requestL2.setActivationName(model.getActivationName());
        if (model instanceof PrepareActivationStepModel) {
            requestL2.setActivationOtp(((PrepareActivationStepModel)model).getAdditionalActivationOtp());
        }
        requestL2.setDevicePublicKey(devicePublicKeyBase64);
        requestL2.setPlatform(model.getPlatform());
        requestL2.setDeviceInfo(model.getDeviceInfo());
        boolean useIv = model.getVersion().useIv();
        EciesCryptogram eciesCryptogramL2 = SecurityUtil.encryptObject(securityContext.getEncryptorL2(), requestL2, useIv);
        EciesEncryptedRequest encryptedRequestL2 = SecurityUtil.createEncryptedRequest(eciesCryptogramL2, useIv);
        ActivationLayer1Request requestL1 = this.prepareLayer1Request(stepContext, encryptedRequestL2);
        stepContext.getStepLogger().writeItem(this.getStep().id() + "-request-encrypt", "Building activation request object", "Following activation attributes will be encrypted and sent to the server", "OK", requestL1);
        EciesCryptogram eciesCryptogramL1 = SecurityUtil.encryptObject(securityContext.getEncryptorL1(), requestL1, useIv);
        EciesEncryptedRequest encryptedRequestL1 = SecurityUtil.createEncryptedRequest(eciesCryptogramL1, useIv);
        stepContext.getRequestContext().setRequestObject(encryptedRequestL1);
    }
}

