/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.context.security;

import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.EciesEncryptor;
import io.getlime.security.powerauth.lib.cmd.steps.context.security.SecurityContext;
import java.security.KeyPair;

public class ActivationSecurityContext
implements SecurityContext {
    private EciesEncryptor encryptorL1;
    private EciesEncryptor encryptorL2;
    private KeyPair deviceKeyPair;

    ActivationSecurityContext(EciesEncryptor encryptorL1, EciesEncryptor encryptorL2, KeyPair deviceKeyPair) {
        this.encryptorL1 = encryptorL1;
        this.encryptorL2 = encryptorL2;
        this.deviceKeyPair = deviceKeyPair;
    }

    public static ActivationSecurityContextBuilder builder() {
        return new ActivationSecurityContextBuilder();
    }

    public EciesEncryptor getEncryptorL1() {
        return this.encryptorL1;
    }

    public EciesEncryptor getEncryptorL2() {
        return this.encryptorL2;
    }

    public KeyPair getDeviceKeyPair() {
        return this.deviceKeyPair;
    }

    public void setEncryptorL1(EciesEncryptor encryptorL1) {
        this.encryptorL1 = encryptorL1;
    }

    public void setEncryptorL2(EciesEncryptor encryptorL2) {
        this.encryptorL2 = encryptorL2;
    }

    public void setDeviceKeyPair(KeyPair deviceKeyPair) {
        this.deviceKeyPair = deviceKeyPair;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivationSecurityContext)) {
            return false;
        }
        ActivationSecurityContext other = (ActivationSecurityContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EciesEncryptor this$encryptorL1 = this.getEncryptorL1();
        EciesEncryptor other$encryptorL1 = other.getEncryptorL1();
        if (this$encryptorL1 == null ? other$encryptorL1 != null : !this$encryptorL1.equals(other$encryptorL1)) {
            return false;
        }
        EciesEncryptor this$encryptorL2 = this.getEncryptorL2();
        EciesEncryptor other$encryptorL2 = other.getEncryptorL2();
        if (this$encryptorL2 == null ? other$encryptorL2 != null : !this$encryptorL2.equals(other$encryptorL2)) {
            return false;
        }
        KeyPair this$deviceKeyPair = this.getDeviceKeyPair();
        KeyPair other$deviceKeyPair = other.getDeviceKeyPair();
        return !(this$deviceKeyPair == null ? other$deviceKeyPair != null : !this$deviceKeyPair.equals(other$deviceKeyPair));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivationSecurityContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EciesEncryptor $encryptorL1 = this.getEncryptorL1();
        result = result * 59 + ($encryptorL1 == null ? 43 : $encryptorL1.hashCode());
        EciesEncryptor $encryptorL2 = this.getEncryptorL2();
        result = result * 59 + ($encryptorL2 == null ? 43 : $encryptorL2.hashCode());
        KeyPair $deviceKeyPair = this.getDeviceKeyPair();
        result = result * 59 + ($deviceKeyPair == null ? 43 : $deviceKeyPair.hashCode());
        return result;
    }

    public String toString() {
        return "ActivationSecurityContext(encryptorL1=" + this.getEncryptorL1() + ", encryptorL2=" + this.getEncryptorL2() + ", deviceKeyPair=" + this.getDeviceKeyPair() + ")";
    }

    public static class ActivationSecurityContextBuilder {
        private EciesEncryptor encryptorL1;
        private EciesEncryptor encryptorL2;
        private KeyPair deviceKeyPair;

        ActivationSecurityContextBuilder() {
        }

        public ActivationSecurityContextBuilder encryptorL1(EciesEncryptor encryptorL1) {
            this.encryptorL1 = encryptorL1;
            return this;
        }

        public ActivationSecurityContextBuilder encryptorL2(EciesEncryptor encryptorL2) {
            this.encryptorL2 = encryptorL2;
            return this;
        }

        public ActivationSecurityContextBuilder deviceKeyPair(KeyPair deviceKeyPair) {
            this.deviceKeyPair = deviceKeyPair;
            return this;
        }

        public ActivationSecurityContext build() {
            return new ActivationSecurityContext(this.encryptorL1, this.encryptorL2, this.deviceKeyPair);
        }

        public String toString() {
            return "ActivationSecurityContext.ActivationSecurityContextBuilder(encryptorL1=" + this.encryptorL1 + ", encryptorL2=" + this.encryptorL2 + ", deviceKeyPair=" + this.deviceKeyPair + ")";
        }
    }
}

