/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.model;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.lib.cmd.steps.model.BaseStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.SignatureHeaderData;
import io.getlime.security.powerauth.lib.cmd.steps.model.feature.ResultStatusChangeable;
import java.security.PublicKey;
import java.util.Map;

public class CreateTokenStepModel
extends BaseStepModel
implements SignatureHeaderData,
ResultStatusChangeable {
    private String statusFileName;
    private String applicationKey;
    private String applicationSecret;
    private String password;
    private PowerAuthSignatureTypes signatureType;
    private PublicKey masterPublicKey;

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> context = super.toMap();
        context.put("STATUS_FILENAME", this.statusFileName);
        context.put("APPLICATION_KEY", this.applicationKey);
        context.put("APPLICATION_SECRET", this.applicationSecret);
        context.put("PASSWORD", this.password);
        context.put("SIGNATURE_TYPE", this.signatureType.toString());
        context.put("MASTER_PUBLIC_KEY", this.masterPublicKey);
        return context;
    }

    @Override
    public void fromMap(Map<String, Object> context) {
        super.fromMap(context);
        this.setStatusFileName((String)context.get("STATUS_FILENAME"));
        this.setApplicationKey((String)context.get("APPLICATION_KEY"));
        this.setApplicationSecret((String)context.get("APPLICATION_SECRET"));
        this.setPassword((String)context.get("PASSWORD"));
        this.setSignatureType(PowerAuthSignatureTypes.getEnumFromString((String)((String)context.get("SIGNATURE_TYPE"))));
        this.setMasterPublicKey((PublicKey)context.get("MASTER_PUBLIC_KEY"));
    }

    @Override
    public String getStatusFileName() {
        return this.statusFileName;
    }

    @Override
    public String getApplicationKey() {
        return this.applicationKey;
    }

    @Override
    public String getApplicationSecret() {
        return this.applicationSecret;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public PowerAuthSignatureTypes getSignatureType() {
        return this.signatureType;
    }

    public PublicKey getMasterPublicKey() {
        return this.masterPublicKey;
    }

    public void setStatusFileName(String statusFileName) {
        this.statusFileName = statusFileName;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public void setApplicationSecret(String applicationSecret) {
        this.applicationSecret = applicationSecret;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSignatureType(PowerAuthSignatureTypes signatureType) {
        this.signatureType = signatureType;
    }

    public void setMasterPublicKey(PublicKey masterPublicKey) {
        this.masterPublicKey = masterPublicKey;
    }

    @Override
    public String toString() {
        return "CreateTokenStepModel(statusFileName=" + this.getStatusFileName() + ", applicationKey=" + this.getApplicationKey() + ", applicationSecret=" + this.getApplicationSecret() + ", password=" + this.getPassword() + ", signatureType=" + this.getSignatureType() + ", masterPublicKey=" + this.getMasterPublicKey() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateTokenStepModel)) {
            return false;
        }
        CreateTokenStepModel other = (CreateTokenStepModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$statusFileName = this.getStatusFileName();
        String other$statusFileName = other.getStatusFileName();
        if (this$statusFileName == null ? other$statusFileName != null : !this$statusFileName.equals(other$statusFileName)) {
            return false;
        }
        String this$applicationKey = this.getApplicationKey();
        String other$applicationKey = other.getApplicationKey();
        if (this$applicationKey == null ? other$applicationKey != null : !this$applicationKey.equals(other$applicationKey)) {
            return false;
        }
        String this$applicationSecret = this.getApplicationSecret();
        String other$applicationSecret = other.getApplicationSecret();
        if (this$applicationSecret == null ? other$applicationSecret != null : !this$applicationSecret.equals(other$applicationSecret)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        PowerAuthSignatureTypes this$signatureType = this.getSignatureType();
        PowerAuthSignatureTypes other$signatureType = other.getSignatureType();
        if (this$signatureType == null ? other$signatureType != null : !this$signatureType.equals(other$signatureType)) {
            return false;
        }
        PublicKey this$masterPublicKey = this.getMasterPublicKey();
        PublicKey other$masterPublicKey = other.getMasterPublicKey();
        return !(this$masterPublicKey == null ? other$masterPublicKey != null : !this$masterPublicKey.equals(other$masterPublicKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CreateTokenStepModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $statusFileName = this.getStatusFileName();
        result = result * 59 + ($statusFileName == null ? 43 : $statusFileName.hashCode());
        String $applicationKey = this.getApplicationKey();
        result = result * 59 + ($applicationKey == null ? 43 : $applicationKey.hashCode());
        String $applicationSecret = this.getApplicationSecret();
        result = result * 59 + ($applicationSecret == null ? 43 : $applicationSecret.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        PowerAuthSignatureTypes $signatureType = this.getSignatureType();
        result = result * 59 + ($signatureType == null ? 43 : $signatureType.hashCode());
        PublicKey $masterPublicKey = this.getMasterPublicKey();
        result = result * 59 + ($masterPublicKey == null ? 43 : $masterPublicKey.hashCode());
        return result;
    }
}

