/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.model;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.lib.cmd.steps.model.BaseStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.SignatureHeaderData;
import io.getlime.security.powerauth.lib.cmd.steps.model.feature.DryRunCapable;
import io.getlime.security.powerauth.lib.cmd.steps.model.feature.ResultStatusChangeable;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifySignatureStepModel
extends BaseStepModel
implements ResultStatusChangeable,
DryRunCapable,
SignatureHeaderData {
    private static final Logger logger = LoggerFactory.getLogger(VerifySignatureStepModel.class);
    private String statusFileName;
    private String applicationKey;
    private String applicationSecret;
    private String httpMethod;
    private String resourceId;
    private PowerAuthSignatureTypes signatureType;
    private byte[] data;
    private String password;
    private boolean dryRun;

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> context = super.toMap();
        context.put("STATUS_FILENAME", this.statusFileName);
        context.put("APPLICATION_KEY", this.applicationKey);
        context.put("APPLICATION_SECRET", this.applicationSecret);
        context.put("HTTP_METHOD", this.httpMethod);
        context.put("RESOURCE_ID", this.resourceId);
        context.put("SIGNATURE_TYPE", this.signatureType.toString());
        context.put("DATA", this.data);
        context.put("PASSWORD", this.password);
        context.put("DRY_RUN", this.dryRun);
        return context;
    }

    @Override
    public void fromMap(Map<String, Object> context) {
        super.fromMap(context);
        this.setStatusFileName((String)context.get("STATUS_FILENAME"));
        this.setApplicationKey((String)context.get("APPLICATION_KEY"));
        this.setApplicationSecret((String)context.get("APPLICATION_SECRET"));
        this.setHttpMethod((String)context.get("HTTP_METHOD"));
        if (context.containsKey("ENDPOINT") && context.get("ENDPOINT") != null && (!context.containsKey("RESOURCE_ID") || context.get("RESOURCE_ID") == null)) {
            logger.warn("Usage of deprecated 'ENDPOINT' key in the context map of VerifySignatureStepModel, use the 'RESOURCE_ID' key instead.");
            context.put("RESOURCE_ID", context.get("ENDPOINT"));
        }
        this.setResourceId((String)context.get("RESOURCE_ID"));
        this.setSignatureType(PowerAuthSignatureTypes.getEnumFromString((String)((String)context.get("SIGNATURE_TYPE"))));
        this.setData((byte[])context.get("DATA"));
        this.setPassword((String)context.get("PASSWORD"));
        this.setDryRun((Boolean)context.get("DRY_RUN"));
    }

    @Override
    public String getStatusFileName() {
        return this.statusFileName;
    }

    @Override
    public String getApplicationKey() {
        return this.applicationKey;
    }

    @Override
    public String getApplicationSecret() {
        return this.applicationSecret;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public PowerAuthSignatureTypes getSignatureType() {
        return this.signatureType;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setStatusFileName(String statusFileName) {
        this.statusFileName = statusFileName;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public void setApplicationSecret(String applicationSecret) {
        this.applicationSecret = applicationSecret;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setSignatureType(PowerAuthSignatureTypes signatureType) {
        this.signatureType = signatureType;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Override
    public String toString() {
        return "VerifySignatureStepModel(statusFileName=" + this.getStatusFileName() + ", applicationKey=" + this.getApplicationKey() + ", applicationSecret=" + this.getApplicationSecret() + ", httpMethod=" + this.getHttpMethod() + ", resourceId=" + this.getResourceId() + ", signatureType=" + this.getSignatureType() + ", data=" + Arrays.toString(this.getData()) + ", password=" + this.getPassword() + ", dryRun=" + this.isDryRun() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerifySignatureStepModel)) {
            return false;
        }
        VerifySignatureStepModel other = (VerifySignatureStepModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDryRun() != other.isDryRun()) {
            return false;
        }
        String this$statusFileName = this.getStatusFileName();
        String other$statusFileName = other.getStatusFileName();
        if (this$statusFileName == null ? other$statusFileName != null : !this$statusFileName.equals(other$statusFileName)) {
            return false;
        }
        String this$applicationKey = this.getApplicationKey();
        String other$applicationKey = other.getApplicationKey();
        if (this$applicationKey == null ? other$applicationKey != null : !this$applicationKey.equals(other$applicationKey)) {
            return false;
        }
        String this$applicationSecret = this.getApplicationSecret();
        String other$applicationSecret = other.getApplicationSecret();
        if (this$applicationSecret == null ? other$applicationSecret != null : !this$applicationSecret.equals(other$applicationSecret)) {
            return false;
        }
        String this$httpMethod = this.getHttpMethod();
        String other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        PowerAuthSignatureTypes this$signatureType = this.getSignatureType();
        PowerAuthSignatureTypes other$signatureType = other.getSignatureType();
        if (this$signatureType == null ? other$signatureType != null : !this$signatureType.equals(other$signatureType)) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VerifySignatureStepModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDryRun() ? 79 : 97);
        String $statusFileName = this.getStatusFileName();
        result = result * 59 + ($statusFileName == null ? 43 : $statusFileName.hashCode());
        String $applicationKey = this.getApplicationKey();
        result = result * 59 + ($applicationKey == null ? 43 : $applicationKey.hashCode());
        String $applicationSecret = this.getApplicationSecret();
        result = result * 59 + ($applicationSecret == null ? 43 : $applicationSecret.hashCode());
        String $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        PowerAuthSignatureTypes $signatureType = this.getSignatureType();
        result = result * 59 + ($signatureType == null ? 43 : $signatureType.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }
}

