/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.vault.PowerAuthClientVault;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.model.PrepareActivationStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.steps.v2.AbstractBaseStepV2;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.ActivationCreateResponse;
import java.io.Console;
import java.io.FileWriter;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component(value="prepareActivationStepV2")
public class PrepareActivationStep
extends AbstractBaseStepV2 {
    private static final PowerAuthClientActivation activation = new PowerAuthClientActivation();
    private static final KeyConvertor keyConversion = new KeyConvertor();
    private static final PowerAuthClientKeyFactory keyFactory = new PowerAuthClientKeyFactory();
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientVault vault = new PowerAuthClientVault();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();

    @Autowired
    public PrepareActivationStep(StepLogger stepLogger) {
        super(PowerAuthStep.ACTIVATION_CREATE, (List<PowerAuthVersion>)PowerAuthVersion.VERSION_2, stepLogger);
    }

    public PrepareActivationStep() {
        this(DEFAULT_STEP_LOGGER);
    }

    @Override
    public ResultStatusObject execute(Map<String, Object> context) throws Exception {
        PrepareActivationStepModel model = new PrepareActivationStepModel();
        model.fromMap(context);
        String uri = model.getUriString() + "/pa/activation/create";
        Pattern p = Pattern.compile("^[A-Z2-7]{5}-[A-Z2-7]{5}-[A-Z2-7]{5}-[A-Z2-7]{5}(#.*)?$");
        Matcher m = p.matcher(model.getActivationCode());
        if (!m.find() && this.stepLogger != null) {
            this.stepLogger.writeError("activation-create-error-activation-code", "Activation failed", "Activation code has invalid format");
            this.stepLogger.writeDoneFailed("activation-create-failed");
            return null;
        }
        String activationIdShort = model.getActivationCode().substring(0, 11);
        String activationOTP = model.getActivationCode().substring(12, 23);
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("activationCode", model.getActivationCode());
        objectMap.put("activationIdShort", activationIdShort);
        objectMap.put("activationOtp", activationOTP);
        this.stepLogger.writeItem("activation-create-activation-code-parsed", "Activation code", "Parsing activation code to short activation ID and activation OTP", "OK", objectMap);
        KeyPair clientEphemeralKeyPair = keyGenerator.generateKeyPair();
        KeyPair deviceKeyPair = activation.generateDeviceKeyPair();
        byte[] nonceDeviceBytes = activation.generateActivationNonce();
        byte[] cDevicePublicKeyBytes = activation.encryptDevicePublicKey(deviceKeyPair.getPublic(), clientEphemeralKeyPair.getPrivate(), model.getMasterPublicKey(), activationOTP, activationIdShort, nonceDeviceBytes);
        byte[] signature = activation.computeApplicationSignature(activationIdShort, nonceDeviceBytes, cDevicePublicKeyBytes, BaseEncoding.base64().decode((CharSequence)model.getApplicationKey()), BaseEncoding.base64().decode((CharSequence)model.getApplicationSecret()));
        byte[] ephemeralPublicKeyBytes = keyConversion.convertPublicKeyToBytes(clientEphemeralKeyPair.getPublic());
        ActivationCreateRequest requestObject = new ActivationCreateRequest();
        requestObject.setActivationIdShort(activationIdShort);
        requestObject.setApplicationKey(model.getApplicationKey());
        requestObject.setActivationName(model.getActivationName());
        requestObject.setActivationNonce(BaseEncoding.base64().encode(nonceDeviceBytes));
        requestObject.setEphemeralPublicKey(BaseEncoding.base64().encode(ephemeralPublicKeyBytes));
        requestObject.setEncryptedDevicePublicKey(BaseEncoding.base64().encode(cDevicePublicKeyBytes));
        requestObject.setApplicationSignature(BaseEncoding.base64().encode(signature));
        ObjectRequest body = new ObjectRequest();
        body.setRequestObject((Object)requestObject);
        try {
            ResponseEntity responseEntity;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.putAll(model.getHeaders());
            this.stepLogger.writeServerCall("activation-create-request-sent", uri, "POST", requestObject, null, headers);
            RestClient restClient = RestClientFactory.getRestClient();
            if (restClient == null) {
                return null;
            }
            ParameterizedTypeReference<ObjectResponse<ActivationCreateResponse>> typeReference = new ParameterizedTypeReference<ObjectResponse<ActivationCreateResponse>>(){};
            try {
                responseEntity = restClient.post(uri, (Object)body, null, MapUtil.toMultiValueMap(headers), (ParameterizedTypeReference)typeReference);
            }
            catch (RestClientException ex) {
                this.stepLogger.writeServerCallError("activation-create-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
                this.stepLogger.writeDoneFailed("activation-create-failed");
                return null;
            }
            ObjectResponse responseWrapper = Objects.requireNonNull((ObjectResponse)responseEntity.getBody());
            this.stepLogger.writeServerCallOK("activation-create-response-received", responseWrapper, HttpUtil.flattenHttpHeaders(responseEntity.getHeaders()));
            ActivationCreateResponse responseObject = (ActivationCreateResponse)responseWrapper.getResponseObject();
            String activationId = responseObject.getActivationId();
            byte[] nonceServerBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getActivationNonce());
            byte[] cServerPubKeyBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedServerPublicKey());
            byte[] cServerPubKeySignatureBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEncryptedServerPublicKeySignature());
            byte[] ephemeralKeyBytes = BaseEncoding.base64().decode((CharSequence)responseObject.getEphemeralPublicKey());
            PublicKey ephemeralPublicKey = keyConversion.convertBytesToPublicKey(ephemeralKeyBytes);
            boolean isDataSignatureValid = activation.verifyServerDataSignature(activationId, cServerPubKeyBytes, cServerPubKeySignatureBytes, model.getMasterPublicKey());
            if (isDataSignatureValid) {
                char[] password;
                PublicKey serverPublicKey = activation.decryptServerPublicKey(cServerPubKeyBytes, deviceKeyPair.getPrivate(), ephemeralPublicKey, activationOTP, activationIdShort, nonceServerBytes);
                SecretKey masterSecretKey = keyFactory.generateClientMasterSecretKey(deviceKeyPair.getPrivate(), serverPublicKey);
                SecretKey signaturePossessionSecretKey = keyFactory.generateClientSignaturePossessionKey(masterSecretKey);
                SecretKey signatureKnowledgeSecretKey = keyFactory.generateClientSignatureKnowledgeKey(masterSecretKey);
                SecretKey signatureBiometrySecretKey = keyFactory.generateClientSignatureBiometryKey(masterSecretKey);
                SecretKey transportMasterKey = keyFactory.generateServerTransportKey(masterSecretKey);
                SecretKey vaultUnlockMasterKey = keyFactory.generateServerEncryptedVaultKey(masterSecretKey);
                byte[] encryptedDevicePrivateKey = vault.encryptDevicePrivateKey(deviceKeyPair.getPrivate(), vaultUnlockMasterKey);
                if (model.getPassword() == null) {
                    Console console = System.console();
                    password = console.readPassword("Select a password to encrypt the knowledge related key: ", new Object[0]);
                } else {
                    password = model.getPassword().toCharArray();
                }
                byte[] salt = keyGenerator.generateRandomBytes(16);
                byte[] cSignatureKnowledgeSecretKey = EncryptedStorageUtil.storeSignatureKnowledgeKey(password, signatureKnowledgeSecretKey, salt, keyGenerator);
                ResultStatusObject resultStatus = model.getResultStatus();
                resultStatus.setActivationId(activationId);
                resultStatus.setCounter(0L);
                resultStatus.setCtrData(null);
                resultStatus.setEncryptedDevicePrivateKeyBytes(encryptedDevicePrivateKey);
                resultStatus.setServerPublicKeyObject(serverPublicKey);
                resultStatus.setSignatureBiometryKeyObject(signatureBiometrySecretKey);
                resultStatus.setSignatureKnowledgeKeyEncryptedBytes(cSignatureKnowledgeSecretKey);
                resultStatus.setSignatureKnowledgeKeySaltBytes(salt);
                resultStatus.setSignaturePossessionKeyObject(signaturePossessionSecretKey);
                resultStatus.setTransportMasterKeyObject(transportMasterKey);
                resultStatus.setVersion(2L);
                String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatus());
                try (FileWriter file = new FileWriter(model.getStatusFileName());){
                    file.write(formatted);
                }
                objectMap = new HashMap();
                objectMap.put("activationId", activationId);
                objectMap.put("activationStatusFile", model.getStatusFileName());
                objectMap.put("activationStatusFileContent", model.getResultStatus());
                objectMap.put("deviceKeyFingerprint", activation.computeActivationFingerprint(deviceKeyPair.getPublic()));
                this.stepLogger.writeItem("activation-create-activation-done", "Activation Done", "Public key exchange was successfully completed, commit the activation on server", "OK", objectMap);
                this.stepLogger.writeDoneOK("activation-create-success");
                return model.getResultStatus();
            }
            String message = "Activation data signature does not match. Either someone tried to spoof your connection, or your device master key is invalid.";
            this.stepLogger.writeError("activation-create-activation-signature-mismatch", message);
            this.stepLogger.writeDoneFailed("activation-create-failed");
            return null;
        }
        catch (Exception exception) {
            this.stepLogger.writeError("activation-create-error-generic", exception);
            this.stepLogger.writeDoneFailed("activation-create-failed");
            return null;
        }
    }
}

