/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.client.signature.PowerAuthClientSignature;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureFormat;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.model.RemoveStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.steps.v2.AbstractBaseStepV2;
import io.getlime.security.powerauth.lib.cmd.util.CounterUtil;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import io.getlime.security.powerauth.rest.api.model.response.v2.ActivationRemoveResponse;
import java.io.Console;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component(value="removeStepV2")
public class RemoveStep
extends AbstractBaseStepV2 {
    private static final KeyGenerator keyGenerator = new KeyGenerator();
    private static final PowerAuthClientSignature signature = new PowerAuthClientSignature();
    private static final ObjectMapper mapper = RestClientConfiguration.defaultMapper();

    @Autowired
    public RemoveStep(StepLogger stepLogger) {
        super(PowerAuthStep.ACTIVATION_REMOVE, (List<PowerAuthVersion>)PowerAuthVersion.VERSION_2, stepLogger);
    }

    public RemoveStep() {
        this(DEFAULT_STEP_LOGGER);
    }

    @Override
    public ResultStatusObject execute(Map<String, Object> context) throws Exception {
        char[] password;
        RemoveStepModel model = new RemoveStepModel();
        model.fromMap(context);
        String uri = model.getUriString() + "/pa/activation/remove";
        ResultStatusObject resultStatusObject = model.getResultStatus();
        String activationId = resultStatusObject.getActivationId();
        byte[] signatureKnowledgeKeySalt = resultStatusObject.getSignatureKnowledgeKeySaltBytes();
        byte[] signatureKnowledgeKeyEncryptedBytes = resultStatusObject.getSignatureKnowledgeKeyEncryptedBytes();
        if (model.getPassword() == null) {
            Console console = System.console();
            password = console.readPassword("Enter your password to unlock the knowledge related key: ", new Object[0]);
        } else {
            password = model.getPassword().toCharArray();
        }
        SecretKey signaturePossessionKey = resultStatusObject.getSignaturePossessionKeyObject();
        SecretKey signatureKnowledgeKey = EncryptedStorageUtil.getSignatureKnowledgeKey(password, signatureKnowledgeKeyEncryptedBytes, signatureKnowledgeKeySalt, keyGenerator);
        byte[] nonceBytes = keyGenerator.generateRandomBytes(16);
        String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/activation/remove", (byte[])nonceBytes, null) + "&" + model.getApplicationSecret();
        byte[] ctrData = CounterUtil.getCtrData(model.getResultStatus(), this.stepLogger);
        PowerAuthSignatureFormat signatureFormat = PowerAuthSignatureFormat.getFormatForSignatureVersion((String)model.getVersion().value());
        String signatureValue = signature.signatureForData(signatureBaseString.getBytes(StandardCharsets.UTF_8), Arrays.asList(signaturePossessionKey, signatureKnowledgeKey), ctrData, signatureFormat);
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader(activationId, model.getApplicationKey(), signatureValue, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE.toString(), BaseEncoding.base64().encode(nonceBytes), model.getVersion().value());
        String httpAuthorizationHeader = header.buildHttpHeader();
        CounterUtil.incrementCounter(model);
        String formatted = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)model.getResultStatus());
        try (FileWriter file = new FileWriter(model.getStatusFileName());){
            file.write(formatted);
        }
        try {
            ResponseEntity responseEntity;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Content-Type", "application/json");
            headers.put("X-PowerAuth-Authorization", httpAuthorizationHeader);
            headers.putAll(model.getHeaders());
            this.stepLogger.writeServerCall("activation-remove-request-sent", uri, "POST", null, null, headers);
            RestClient restClient = RestClientFactory.getRestClient();
            if (restClient == null) {
                return null;
            }
            ParameterizedTypeReference<ObjectResponse<ActivationRemoveResponse>> typeReference = new ParameterizedTypeReference<ObjectResponse<ActivationRemoveResponse>>(){};
            try {
                responseEntity = restClient.post(uri, null, null, MapUtil.toMultiValueMap(headers), (ParameterizedTypeReference)typeReference);
            }
            catch (RestClientException ex) {
                this.stepLogger.writeServerCallError("activation-remove-error-server-callactivation-remove-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
                this.stepLogger.writeDoneFailed("activation-remove-failed");
                return null;
            }
            ObjectResponse responseWrapper = Objects.requireNonNull((ObjectResponse)responseEntity.getBody());
            this.stepLogger.writeServerCallOK("activation-remove-response-received", responseWrapper, HttpUtil.flattenHttpHeaders(responseEntity.getHeaders()));
            HashMap<String, String> objectMap = new HashMap<String, String>();
            objectMap.put("activationId", activationId);
            this.stepLogger.writeItem("activation-remove-finished", "Activation Removed", "Activation was successfully removed from the server", "OK", objectMap);
            this.stepLogger.writeDoneOK("activation-remove-success");
            return model.getResultStatus();
        }
        catch (Exception exception) {
            this.stepLogger.writeError("activation-remove-error-generic", exception);
            this.stepLogger.writeDoneFailed("activation-remove-failed");
            return null;
        }
    }
}

