/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderFactory;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractActivationStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.CreateActivationStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.EncryptionHeaderData;
import io.getlime.security.powerauth.rest.api.model.entity.ActivationType;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationLayer1Request;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="createActivationStepV3")
public class CreateActivationStep
extends AbstractActivationStep<CreateActivationStepModel> {
    private final PowerAuthHeaderFactory powerAuthHeaderFactory;

    @Autowired
    public CreateActivationStep(PowerAuthHeaderFactory powerAuthHeaderFactory, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.ACTIVATION_CREATE_CUSTOM, (List<PowerAuthVersion>)PowerAuthVersion.VERSION_3, resultStatusService, stepLoggerFactory);
        this.powerAuthHeaderFactory = powerAuthHeaderFactory;
    }

    public CreateActivationStep() {
        this(BackwardCompatibilityConst.POWER_AUTH_HEADER_FACTORY, BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    public StepContext<CreateActivationStepModel, EciesEncryptedResponse> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        CreateActivationStepModel model = new CreateActivationStepModel();
        model.fromMap(context);
        RequestContext requestContext = RequestContext.builder().uri(model.getUriString() + "/pa/v3/activation/create").build();
        StepContext<CreateActivationStepModel, EciesEncryptedResponse> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        this.powerAuthHeaderFactory.getHeaderProvider(model).addHeader((StepContext<? extends EncryptionHeaderData, ?>)stepContext);
        this.addEncryptedRequest(stepContext);
        return stepContext;
    }

    @Override
    protected ActivationLayer1Request prepareLayer1Request(StepContext<CreateActivationStepModel, EciesEncryptedResponse> stepContext, EciesEncryptedRequest encryptedRequestL2) {
        ActivationLayer1Request requestL1 = new ActivationLayer1Request();
        requestL1.setType(ActivationType.CUSTOM);
        requestL1.setActivationData(encryptedRequestL2);
        requestL1.setIdentityAttributes(stepContext.getModel().getIdentityAttributes());
        requestL1.setCustomAttributes(stepContext.getModel().getCustomAttributes());
        return requestL1;
    }
}

