/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderFactory;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.RemoveStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.SignatureHeaderData;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;

@Component(value="removeStepV3")
public class RemoveStep
extends AbstractBaseStep<RemoveStepModel, EciesEncryptedResponse> {
    private final PowerAuthHeaderFactory powerAuthHeaderFactory;

    @Autowired
    public RemoveStep(PowerAuthHeaderFactory powerAuthHeaderFactory, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.ACTIVATION_REMOVE, (List<PowerAuthVersion>)PowerAuthVersion.VERSION_3, resultStatusService, stepLoggerFactory);
        this.powerAuthHeaderFactory = powerAuthHeaderFactory;
    }

    public RemoveStep() {
        this(BackwardCompatibilityConst.POWER_AUTH_HEADER_FACTORY, BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    protected ParameterizedTypeReference<EciesEncryptedResponse> getResponseTypeReference() {
        return PowerAuthConst.RESPONSE_TYPE_REFERENCE_V3;
    }

    @Override
    public StepContext<RemoveStepModel, EciesEncryptedResponse> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        RemoveStepModel model = new RemoveStepModel();
        model.fromMap(context);
        RequestContext requestContext = RequestContext.builder().signatureHttpMethod("POST").signatureRequestUri("/pa/activation/remove").uri(model.getUriString() + "/pa/v3/activation/remove").build();
        StepContext<RemoveStepModel, EciesEncryptedResponse> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        this.powerAuthHeaderFactory.getHeaderProvider(model).addHeader((StepContext<? extends SignatureHeaderData, ?>)stepContext);
        this.incrementCounter(model);
        return stepContext;
    }

    @Override
    public void processResponse(StepContext<RemoveStepModel, EciesEncryptedResponse> stepContext) {
        String activationId = stepContext.getModel().getResultStatus().getActivationId();
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("activationId", activationId);
        stepContext.getStepLogger().writeItem(this.getStep().id() + "-removal-done", "Activation Removed", "Activation was successfully removed from the server", "OK", objectMap);
    }
}

