/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.util;

import io.getlime.security.powerauth.lib.cmd.exception.PowerAuthCmdException;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

public class FileUtil {
    public static byte[] readFileBytes(StepLogger stepLogger, @Nullable String filePath, String logFileId, String fileDescription) throws IOException, PowerAuthCmdException {
        if (filePath == null) {
            stepLogger.writeItem("generic-warning-" + logFileId + "-empty", "Empty " + fileDescription + " file", "File not provided, assuming empty data.", "WARNING", filePath);
            return new byte[0];
        }
        Path path = Paths.get(filePath, new String[0]);
        if (Files.isReadable(path)) {
            return Files.readAllBytes(path);
        }
        stepLogger.writeItem("generic-error-" + logFileId + "-file-invalid", "Invalid " + fileDescription + " file", String.format("Unable to read %s - did you specify the correct path?", fileDescription), "ERROR", null);
        throw new PowerAuthCmdException();
    }

    public static <T> T readDataFromFile(StepLogger stepLogger, String filePath, Class<T> cls, String logFileId, String fileDescription) throws Exception {
        Object data;
        byte[] fileBytes = FileUtil.readFileBytes(stepLogger, filePath, logFileId, fileDescription);
        try {
            data = RestClientConfiguration.defaultMapper().readValue(fileBytes, cls);
        }
        catch (Exception e) {
            stepLogger.writeItem("generic-error-" + logFileId + "-file-invalid", "Invalid " + fileDescription + " file", String.format("The %s must be in a correct JSON format", fileDescription), "ERROR", e);
            throw new PowerAuthCmdException();
        }
        return (T)data;
    }
}

