/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.consts;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;

public enum PowerAuthVersion {
    V2_0(2, "2.0"),
    V2_1(2, "2.1"),
    V3_0(3, "3.0"),
    V3_1(3, "3.1");

    public static final ImmutableList<PowerAuthVersion> ALL_VERSIONS;
    public static final PowerAuthVersion DEFAULT;
    public static final ImmutableList<PowerAuthVersion> VERSION_2;
    public static final ImmutableList<PowerAuthVersion> VERSION_3;
    int majorVersion;
    String value;

    private PowerAuthVersion(int majorVersion, String versionValue) {
        this.majorVersion = majorVersion;
        this.value = versionValue;
    }

    public boolean useIv() {
        return this.majorVersion >= 3 && !V3_0.equals((Object)this);
    }

    public String value() {
        return this.value;
    }

    public static PowerAuthVersion fromValue(String value) {
        return Arrays.stream(PowerAuthVersion.values()).filter(version -> version.value.equals(value)).findFirst().orElseThrow(() -> new IllegalStateException("Unsupported PowerAuth version: " + value));
    }

    static {
        ALL_VERSIONS = ImmutableList.copyOf((Object[])PowerAuthVersion.values());
        DEFAULT = V3_1;
        VERSION_2 = ImmutableList.of((Object)((Object)V2_0), (Object)((Object)V2_1));
        VERSION_3 = ImmutableList.of((Object)((Object)V3_0), (Object)((Object)V3_1));
    }
}

