/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.header;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.signature.PowerAuthClientSignature;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureFormat;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderProvider;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.VerifySignatureStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.SignatureHeaderData;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.util.CounterUtil;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import java.io.Console;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.crypto.SecretKey;

public class SignatureHeaderProvider
implements PowerAuthHeaderProvider<SignatureHeaderData> {
    private static final PowerAuthClientKeyFactory KEY_FACTORY = new PowerAuthClientKeyFactory();
    private static final KeyGenerator KEY_GENERATOR = new KeyGenerator();
    private static final PowerAuthClientSignature SIGNATURE = new PowerAuthClientSignature();

    @Override
    public void addHeader(StepContext<? extends SignatureHeaderData, ?> stepContext) throws Exception {
        SecretKey signatureKnowledgeKey;
        List<SecretKey> signatureSecretKeys;
        SignatureHeaderData model = stepContext.getModel();
        RequestContext requestContext = stepContext.getRequestContext();
        ResultStatusObject resultStatusObject = model.getResultStatus();
        SecretKey signaturePossessionKey = resultStatusObject.getSignaturePossessionKeyObject();
        SecretKey signatureBiometryKey = resultStatusObject.getSignatureBiometryKeyObject();
        byte[] nonceBytes = KEY_GENERATOR.generateRandomBytes(16);
        byte[] requestBytes = HttpUtil.toRequestBytes(requestContext.getRequestObject());
        String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)requestContext.getSignatureHttpMethod(), (String)requestContext.getSignatureRequestUri(), (byte[])nonceBytes, (byte[])requestBytes) + "&" + model.getApplicationSecret();
        byte[] ctrData = CounterUtil.getCtrData(resultStatusObject, stepContext.getStepLogger());
        PowerAuthSignatureFormat signatureFormat = PowerAuthSignatureFormat.getFormatForSignatureVersion((String)model.getVersion().value());
        if (PowerAuthSignatureTypes.POSSESSION.equals((Object)model.getSignatureType())) {
            signatureSecretKeys = Collections.singletonList(signaturePossessionKey);
        } else if (PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE.equals((Object)model.getSignatureType())) {
            signatureKnowledgeKey = this.getSignatureKnowledgeKey(model);
            signatureSecretKeys = Arrays.asList(signaturePossessionKey, signatureKnowledgeKey);
        } else {
            signatureKnowledgeKey = this.getSignatureKnowledgeKey(model);
            signatureSecretKeys = KEY_FACTORY.keysForSignatureType(model.getSignatureType(), signaturePossessionKey, signatureKnowledgeKey, signatureBiometryKey);
        }
        String signatureValue = SIGNATURE.signatureForData(signatureBaseString.getBytes(StandardCharsets.UTF_8), signatureSecretKeys, ctrData, signatureFormat);
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader(resultStatusObject.getActivationId(), model.getApplicationKey(), signatureValue, model.getSignatureType().toString(), BaseEncoding.base64().encode(nonceBytes), model.getVersion().value());
        HashMap<String, String> lowLevelData = new HashMap<String, String>();
        lowLevelData.put("counter", String.valueOf(resultStatusObject.getCounter()));
        int version = resultStatusObject.getVersion().intValue();
        if (version == 3) {
            lowLevelData.put("ctrData", BaseEncoding.base64().encode(ctrData));
        }
        lowLevelData.put("signatureBaseString", signatureBaseString);
        lowLevelData.put("nonce", BaseEncoding.base64().encode(nonceBytes));
        lowLevelData.put("applicationSecret", model.getApplicationSecret());
        if (model instanceof VerifySignatureStepModel) {
            lowLevelData.put("activationId", resultStatusObject.getActivationId());
            lowLevelData.put("applicationKey", model.getApplicationKey());
            lowLevelData.put("resourceId", ((VerifySignatureStepModel)model).getResourceId());
            lowLevelData.put("serverPublicKey", resultStatusObject.getServerPublicKey());
            lowLevelData.put("transportKey", resultStatusObject.getTransportMasterKey());
        }
        stepContext.getStepLogger().writeItem(stepContext.getStep().id() + "-prepare-request", "Signature Calculation Parameters", "Low level cryptographic inputs required to compute signature - mainly a signature base string and a counter value.", "OK", lowLevelData);
        String headerValue = header.buildHttpHeader();
        requestContext.setAuthorizationHeader(headerValue);
        requestContext.setAuthorizationHeaderName("X-PowerAuth-Authorization");
        requestContext.getHttpHeaders().put("X-PowerAuth-Authorization", headerValue);
    }

    private <M extends SignatureHeaderData> SecretKey getSignatureKnowledgeKey(M model) throws Exception {
        char[] password;
        byte[] signatureKnowledgeKeySalt = model.getResultStatus().getSignatureKnowledgeKeySaltBytes();
        byte[] signatureKnowledgeKeyEncryptedBytes = model.getResultStatus().getSignatureKnowledgeKeyEncryptedBytes();
        if (model.getPassword() == null) {
            Console console = System.console();
            password = console.readPassword("Enter your password to unlock the knowledge related key: ", new Object[0]);
        } else {
            password = model.getPassword().toCharArray();
        }
        return EncryptedStorageUtil.getSignatureKnowledgeKey(password, signatureKnowledgeKeyEncryptedBytes, signatureKnowledgeKeySalt, KEY_GENERATOR);
    }
}

