/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.logging;

import io.getlime.security.powerauth.lib.cmd.consts.StepLoggerType;
import io.getlime.security.powerauth.lib.cmd.logging.DisabledStepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.JsonStepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.ObjectStepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.config.StepLoggerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StepLoggerFactory {
    private final StepLoggerConfig config;

    public StepLoggerFactory(StepLoggerType stepLoggerType) {
        this.config = new StepLoggerConfig();
        this.config.setType(stepLoggerType);
    }

    @Autowired
    public StepLoggerFactory(StepLoggerConfig config) {
        this.config = config;
    }

    public StepLogger createStepLogger() {
        if (this.config == null || this.config.getType() == null) {
            return DisabledStepLogger.INSTANCE;
        }
        switch (this.config.getType()) {
            case DISABLED: {
                return DisabledStepLogger.INSTANCE;
            }
            case JSON: {
                return new JsonStepLogger(System.out);
            }
            case OBJECT: {
                return new ObjectStepLogger(System.out);
            }
        }
        throw new IllegalStateException("Unrecognized step logger type: " + (Object)((Object)this.config.getType()));
    }
}

