/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.logging.model;

import io.getlime.security.powerauth.crypto.lib.model.ActivationStatusBlobInfo;

public class ExtendedActivationStatusBlobInfo
extends ActivationStatusBlobInfo {
    private String activationStatusName;

    public static ExtendedActivationStatusBlobInfo copy(ActivationStatusBlobInfo orig) {
        ExtendedActivationStatusBlobInfo result = new ExtendedActivationStatusBlobInfo();
        result.setActivationStatus(orig.getActivationStatus());
        result.setCtrByte(orig.getCtrByte());
        result.setCtrDataHash(orig.getCtrDataHash());
        result.setCtrLookAhead(orig.getCtrLookAhead());
        result.setCurrentVersion(orig.getCurrentVersion());
        result.setFailedAttempts(orig.getFailedAttempts());
        result.setMaxFailedAttempts(orig.getMaxFailedAttempts());
        result.setUpgradeVersion(orig.getUpgradeVersion());
        result.setValid(orig.isValid());
        result.setActivationStatusName(result.convertStatusToStatusName(orig.getActivationStatus()));
        return result;
    }

    public void setActivationStatusName(String activationStatusName) {
        this.activationStatusName = activationStatusName;
    }

    public String getActivationStatusName() {
        return this.activationStatusName;
    }

    private String convertStatusToStatusName(byte status) {
        switch (status) {
            case 1: {
                return "CREATED";
            }
            case 2: {
                return "PENDING_COMMIT";
            }
            case 3: {
                return "ACTIVE";
            }
            case 4: {
                return "BLOCKED";
            }
            case 5: {
                return "REMOVED";
            }
        }
        return "UNKNOWN";
    }
}

