/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderFactory;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.VerifyTokenStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.TokenHeaderData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
public class VerifyTokenStep
extends AbstractBaseStep<VerifyTokenStepModel, Map<String, Object>> {
    ParameterizedTypeReference<Map<String, Object>> RESPONSE_TYPE_REFERENCE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final PowerAuthHeaderFactory powerAuthHeaderFactory;

    @Autowired
    public VerifyTokenStep(PowerAuthHeaderFactory powerAuthHeaderFactory, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.TOKEN_VALIDATE, (List<PowerAuthVersion>)PowerAuthVersion.ALL_VERSIONS, resultStatusService, stepLoggerFactory);
        this.powerAuthHeaderFactory = powerAuthHeaderFactory;
    }

    public VerifyTokenStep() {
        this(BackwardCompatibilityConst.POWER_AUTH_HEADER_FACTORY, BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    public ParameterizedTypeReference<Map<String, Object>> getResponseTypeReference() {
        return this.RESPONSE_TYPE_REFERENCE;
    }

    @Override
    public StepContext<VerifyTokenStepModel, Map<String, Object>> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        VerifyTokenStepModel model = new VerifyTokenStepModel();
        model.fromMap(context);
        RequestContext requestContext = RequestContext.builder().httpMethod(HttpMethod.valueOf((String)model.getHttpMethod())).uri(model.getUriString()).build();
        StepContext<VerifyTokenStepModel, Map<String, Object>> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TOKEN_ID", model.getTokenId());
        map.put("TOKEN_SECRET", model.getTokenSecret());
        stepLogger.writeItem("token-validate-start", "Token Digest Validation Started", null, "OK", map);
        this.powerAuthHeaderFactory.getHeaderProvider(model).addHeader((StepContext<? extends TokenHeaderData, ?>)stepContext);
        if (model.getHttpMethod() == null) {
            stepLogger.writeError("token-validate-error-http-method", "HTTP method not specified", "Specify HTTP method to use for sending request");
            stepLogger.writeDoneFailed("token-validate-failed");
            return null;
        }
        byte[] requestDataBytes = null;
        if (!(HttpMethod.GET.name().equals(model.getHttpMethod().toUpperCase()) || (requestDataBytes = model.getData()) != null && requestDataBytes.length != 0)) {
            requestDataBytes = new byte[]{};
            stepLogger.writeItem("token-validate-warning-empty-data", "Empty data", "Data file was not found, signature will contain no data", "WARNING", null);
        }
        requestContext.setRequestObject(requestDataBytes);
        return stepContext;
    }

    @Override
    public void logDryRun(StepLogger stepLogger) {
        stepLogger.writeItem(this.getStep().id() + "-token-computed", "Token value computed (dry run)", "Token value header was computed successfully", "OK", null);
    }

    @Override
    public void processResponse(StepContext<VerifyTokenStepModel, Map<String, Object>> stepContext) throws Exception {
        stepContext.getStepLogger().writeItem(this.getStep().id() + "-digest-verified", "Token digest verified", "Token based authentication was successful", "OK", null);
    }
}

