/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.model;

import io.getlime.security.powerauth.lib.cmd.steps.model.BaseStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.EncryptionHeaderData;
import io.getlime.security.powerauth.lib.cmd.steps.model.feature.DryRunCapable;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Map;

public class EncryptStepModel
extends BaseStepModel
implements EncryptionHeaderData,
DryRunCapable {
    private byte[] data;
    private String applicationKey;
    private String applicationSecret;
    private boolean dryRun;
    private PublicKey masterPublicKey;
    private String scope;

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> context = super.toMap();
        context.put("DATA", this.data);
        context.put("APPLICATION_KEY", this.applicationKey);
        context.put("APPLICATION_SECRET", this.applicationSecret);
        context.put("DRY_RUN", this.dryRun);
        context.put("MASTER_PUBLIC_KEY", this.masterPublicKey);
        context.put("SCOPE", this.scope);
        return context;
    }

    @Override
    public void fromMap(Map<String, Object> context) {
        super.fromMap(context);
        this.setData((byte[])context.get("DATA"));
        this.setApplicationKey((String)context.get("APPLICATION_KEY"));
        this.setApplicationSecret((String)context.get("APPLICATION_SECRET"));
        this.setDryRun((Boolean)context.get("DRY_RUN"));
        this.setMasterPublicKey((PublicKey)context.get("MASTER_PUBLIC_KEY"));
        this.setScope((String)context.get("SCOPE"));
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getApplicationSecret() {
        return this.applicationSecret;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    public PublicKey getMasterPublicKey() {
        return this.masterPublicKey;
    }

    public String getScope() {
        return this.scope;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public void setApplicationSecret(String applicationSecret) {
        this.applicationSecret = applicationSecret;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setMasterPublicKey(PublicKey masterPublicKey) {
        this.masterPublicKey = masterPublicKey;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public String toString() {
        return "EncryptStepModel(data=" + Arrays.toString(this.getData()) + ", applicationKey=" + this.getApplicationKey() + ", applicationSecret=" + this.getApplicationSecret() + ", dryRun=" + this.isDryRun() + ", masterPublicKey=" + this.getMasterPublicKey() + ", scope=" + this.getScope() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptStepModel)) {
            return false;
        }
        EncryptStepModel other = (EncryptStepModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDryRun() != other.isDryRun()) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        String this$applicationKey = this.getApplicationKey();
        String other$applicationKey = other.getApplicationKey();
        if (this$applicationKey == null ? other$applicationKey != null : !this$applicationKey.equals(other$applicationKey)) {
            return false;
        }
        String this$applicationSecret = this.getApplicationSecret();
        String other$applicationSecret = other.getApplicationSecret();
        if (this$applicationSecret == null ? other$applicationSecret != null : !this$applicationSecret.equals(other$applicationSecret)) {
            return false;
        }
        PublicKey this$masterPublicKey = this.getMasterPublicKey();
        PublicKey other$masterPublicKey = other.getMasterPublicKey();
        if (this$masterPublicKey == null ? other$masterPublicKey != null : !this$masterPublicKey.equals(other$masterPublicKey)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EncryptStepModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDryRun() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getData());
        String $applicationKey = this.getApplicationKey();
        result = result * 59 + ($applicationKey == null ? 43 : $applicationKey.hashCode());
        String $applicationSecret = this.getApplicationSecret();
        result = result * 59 + ($applicationSecret == null ? 43 : $applicationSecret.hashCode());
        PublicKey $masterPublicKey = this.getMasterPublicKey();
        result = result * 59 + ($masterPublicKey == null ? 43 : $masterPublicKey.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }
}

